package com.artfess.workflow.conf;

import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.artfess.bpm.model.form.Form;
import com.artfess.bpm.model.process.nodedef.ext.extmodel.DefaultFormExt;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

import java.io.IOException;

public class FormExtEventDeserializer extends StdDeserializer<FormExt> {
    private static final long serialVersionUID = 1L;

    protected FormExtEventDeserializer() {
        super(Form.class);
    }

    @Override
    public FormExt deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        TreeNode readValueAsTree = jp.readValueAsTree();
        String json = readValueAsTree.toString();
        DefaultFormExt form = JsonUtil.toBean(json, DefaultFormExt.class);
        return form;
    }
}
