package com.artfess.uc.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import java.time.LocalDateTime;
import java.util.List;

/**
* 矩阵管理
* <pre>
* 描述：矩阵管理 实体对象
* 构建组：x7
* 作者:pangq
* 邮箱:pangq@jee-soft.cn
* 日期:2020-06-05 10:24:44
* 版权：广州宏天软件股份有限公司
* </pre>
*/
@TableName("uc_matrix")
@ApiModel(value = "Matrix",description = "矩阵管理")
public class Matrix extends BaseModel<Matrix>{
    /**
     * 矩阵表名前缀
     */
    public static final String TABLE_NAME_PRE = "UC_MATRIX_";

   private static final long serialVersionUID = 1L;
   @XmlTransient
   @TableId("ID_")
   @ApiModelProperty(value="主键")
   protected String id;

   @XmlAttribute(name = "code")
   @TableField("CODE_")
   @ApiModelProperty(value="编码/别名")
   protected String code;

   @XmlAttribute(name = "name")
   @TableField("NAME_")
   @ApiModelProperty(value="名称")
   protected String name;

   @XmlAttribute(name = "typeId")
   @TableField("TYPE_ID_")
   @ApiModelProperty(value="分类ID")
   protected String typeId;
   @XmlAttribute(name = "typeName")
   @TableField("TYPE_NAME_")
   @ApiModelProperty(value="分类名称")
   protected String typeName;

   @XmlAttribute(name = "status")
   @TableField("STATUS_")
   @ApiModelProperty(value="状态：0待发布、1已发布")
   protected Integer status=0;

   @XmlAttribute(name = "managerId")
   @TableField("MANAGER_ID_")
   @ApiModelProperty(value="管理员ID")
   protected String managerId;

   @XmlAttribute(name = "managerName")
   @TableField("MANAGER_NAME_")
   @ApiModelProperty(value="管理员名称")
   protected String managerName;

   @XmlAttribute(name = "isDele")
   @TableField("IS_DELE_")
   @ApiModelProperty(value="是否删除：0未除、1已删")
   protected Integer isDele=0;

   @XmlAttribute(name = "createBy")
   @TableField("CREATE_BY_")
   @ApiModelProperty(value="创建人")
   protected String createBy;

   @XmlAttribute(name = "createTime")
   @TableField("CREATE_TIME_")
   @ApiModelProperty(value="创建时间")
   protected LocalDateTime createTime;

   @XmlAttribute(name = "createOrgId")
   @TableField("CREATE_ORG_ID_")
   @ApiModelProperty(value="创建人部门id")
   protected String createOrgId;

   @XmlAttribute(name = "updateBy")
   @TableField("UPDATE_BY_")
   @ApiModelProperty(value="更新人")
   protected String updateBy;

   @XmlAttribute(name = "updateTime")
   @TableField("UPDATE_TIME_")
   @ApiModelProperty(value="更新时间")
   protected LocalDateTime updateTime;

   @XmlAttribute(name = "tenantId")
   @TableField("tenant_id_")
   @ApiModelProperty(name="tenant_id_",notes="租户id")
   protected String tenantId;

   /**
    * 条件列定义列表
    */
   @TableField(exist=false)
   protected List<MatrixColDef> condList;

   /**
    * 角色列定义列表
    */
   @TableField(exist=false)
   protected List<MatrixColDef> roleList;

   public void setId(String id) {
       this.id = id;
   }

   /**
    * 返回 主键
    * @return
    */
   public String getId() {
       return this.id;
   }
   public void setCode(String code) {
       this.code = code;
   }

   /**
    * 返回 编码
    * @return
    */
   public String getCode() {
       return this.code;
   }
   public void setName(String name) {
       this.name = name;
   }

   /**
    * 返回 名称
    * @return
    */
   public String getName() {
       return this.name;
   }
   public void setTypeId(String typeId) {
       this.typeId = typeId;
   }

   /**
    * 返回 分类ID
    * @return
    */
   public String getTypeId() {
       return this.typeId;
   }
   public void setStatus(Integer status) {
       this.status = status;
   }

   /**
    * 返回 状态：0待发布、1已发布
    * @return
    */
   public Integer getStatus() {
       return this.status;
   }
   public void setManagerId(String managerId) {
       this.managerId = managerId;
   }

   /**
    * 返回 管理员ID
    * @return
    */
   public String getManagerId() {
       return this.managerId;
   }
   public void setManagerName(String managerName) {
       this.managerName = managerName;
   }

   /**
    * 返回 管理员名称
    * @return
    */
   public String getManagerName() {
       return this.managerName;
   }
   public void setIsDele(Integer isDele) {
       this.isDele = isDele;
   }

   /**
    * 返回 是否删除：0未除、1已删
    * @return
    */
   public Integer getIsDele() {
       return this.isDele;
   }
   public void setCreateBy(String createBy) {
       this.createBy = createBy;
   }

   /**
    * 返回 创建人
    * @return
    */
   public String getCreateBy() {
       return this.createBy;
   }
   public void setCreateTime(LocalDateTime createTime) {
       this.createTime = createTime;
   }

   /**
    * 返回 创建时间
    * @return
    */
   public LocalDateTime getCreateTime() {
       return this.createTime;
   }
   public void setCreateOrgId(String createOrgId) {
       this.createOrgId = createOrgId;
   }

   /**
    * 返回 创建人部门id
    * @return
    */
   public String getCreateOrgId() {
       return this.createOrgId;
   }
   public void setUpdateBy(String updateBy) {
       this.updateBy = updateBy;
   }

   /**
    * 返回 更新人
    * @return
    */
   public String getUpdateBy() {
       return this.updateBy;
   }
   public void setUpdateTime(LocalDateTime updateTime) {
       this.updateTime = updateTime;
   }

   /**
    * 返回 更新时间
    * @return
    */
   public LocalDateTime getUpdateTime() {
       return this.updateTime;
   }
   public String getTypeName() {
       return typeName;
   }

   public void setTypeName(String typeName) {
       this.typeName = typeName;
   }

   public String getTenantId() {
       return tenantId;
   }


   public void setTenantId(String tenantId) {
       this.tenantId = tenantId;
   }

   public List<com.artfess.uc.model.MatrixColDef> getCondList() {
       return condList;
   }

   public void setCondList(List<com.artfess.uc.model.MatrixColDef> condList) {
       this.condList = condList;
   }

   public List<com.artfess.uc.model.MatrixColDef> getRoleList() {
       return roleList;
   }

   public void setRoleList(List<com.artfess.uc.model.MatrixColDef> roleList) {
       this.roleList = roleList;
   }

   /**
    * @see Object#toString()
    */
   public String toString() {
       return new ToStringBuilder(this)
       .append("id", this.id)
       .append("code", this.code)
       .append("name", this.name)
       .append("typeId", this.typeId)
       .append("status", this.status)
       .append("managerId", this.managerId)
       .append("managerName", this.managerName)
       .append("isDele", this.isDele)
       .append("createBy", this.createBy)
       .append("createTime", this.createTime)
       .append("createOrgId", this.createOrgId)
       .append("updateBy", this.updateBy)
       .append("updateTime", this.updateTime)
       .append("condList",this.condList)
       .append("roleList",this.roleList)
       .toString();
   }
}