package com.artfess.dataAccess.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 数据权限——授权
 *
 * @author llj
 * @since 2021-04-01
 */
@ApiModel(value="DataAccessControl对象", description="数据权限授权")
@TableName("PORTAL_SYS_DATA_ACCESS_CONTROL")
public class DataAccessControl extends AutoFillModel<DataAccessControl> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "权限id")
    @TableField("ACCESS_DEFINED_ID_")
    private String accessDefinedId;

    @ApiModelProperty(value = "权限受控类型（1：所有人  2：组织 3：用户 4 ：角色）")
    @TableField("ACCESS_CONTROL_TYPE_")
    private Integer accessControlType;

    @ApiModelProperty(value = "受控id(用户id或组织id或角色id)")
    @TableField("ACCESS_CONTROL_ID_")
    private String accessControlId;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAccessDefinedId() {
        return accessDefinedId;
    }

    public void setAccessDefinedId(String accessDefinedId) {
        this.accessDefinedId = accessDefinedId;
    }

    public Integer getAccessControlType() {
        return accessControlType;
    }

    public void setAccessControlType(Integer accessControlType) {
        this.accessControlType = accessControlType;
    }

    public String getAccessControlId() {
        return accessControlId;
    }

    public void setAccessControlId(String accessControlId) {
        this.accessControlId = accessControlId;
    }

    @Override
    public String toString() {
        return "DataAccessControl{" +
            "id=" + id +
            ", accessDefinedId=" + accessDefinedId +
            ", accessControlType=" + accessControlType +
            ", accessControlId=" + accessControlId +
        "}";
    }
}
