package com.artfess.dataAccess.manager;



import com.artfess.base.manager.BaseManager;
import com.artfess.dataAccess.model.DataAccessDefined;

import java.util.List;
import java.util.Map;

/**
 * 数据权限定义 服务类
 *
 * @author llj
 * @since 2021-04-01
 */
public interface DataAccessDefinedManager extends BaseManager<DataAccessDefined> {
    /**
    * @Description:  根据接口id查询所有权限id
    * @param interfaceId 接口id
    * @Return: java.util.List<com.artfess.portal.permission.model.DataAccessDefined>
    * @Author: llj
    * @Date: 2021/4/1 10:26
    */
    List<DataAccessDefined> queryListDataAccessDefined(String interfaceId);
    /**
    * @Description: 保存权限定义
     * @param DataAccessDefined 权限定义对象
    * @Return: java.lang.String
    * @Author: llj
    * @Date: 2021/4/1 10:28
    */
    String saveDataAccessDefined(DataAccessDefined DataAccessDefined);
    /**
    * @Description: 删除权限定义
    * @param ids 权限定义id
    * @Return: java.lang.String
    * @Author: llj
    * @Date: 2021/4/1 10:30
    */
    void deleteDataAccessDefinedByIds(List<String> ids);

    /**
    * @Description: 根据主键id查询权限定义
    * @param  id  主键id
    * @Return: com.artfess.portal.permission.model.DataAccessDefined
    * @Author: llj
    * @Date: 2021/4/1 11:40
    */
    DataAccessDefined loadDataAccessDefined(String id);


    /**
    * @Description: 获取登陆人员所有的权限范围
    * @param   alias  接口别名
    * @Return: java.util.List<com.artfess.portal.permission.model.DataAccessDefined>
    * @Author: llj
    * @Date: 2021/4/2 10:22
    */
    List<Map<String, Object>> getDataAccessDefinedList(String alias);
}
