package com.artfess.sysConfig.persistence.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 系统字典详情信息表
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "SysDictionaryDetail", description = "系统字典详情信息表")
@TableName("portal_sys_dictionary_detail")
@Data
public class SysDictionaryDetail extends BaseModel<SysDictionaryDetail> {

    @ApiModelProperty(value = "主键ID")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "字典_ID【外键】")
    @TableField("DICTIONARY_ID_")
    private String dictionaryId;

    @ApiModelProperty(value = "成员名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "成员数据值")
    @TableField("VALUE_")
    private String value;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "有效标志（0：无效  1：有效）")
    @TableField("FLAG_")
    private Integer flag;

}
