package com.artfess.file.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import java.util.List;

/**
 * 流程附件上传配置
 * <pre>
 * 描述：流程附件上传配置 实体对象
 * 构建组：x7
 * 作者:zhangxw
 * 邮箱:zhangxw@jee-soft.cn
 * 日期:2020-06-01 20:53:49
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@TableName("PORTAL_FLOW_UPLOAD_PROPERTIES")
@ApiModel(value = "FlowUploadProperties", description = "流程附件上传配置")
public class FlowUploadProperties extends AutoFillModel<FlowUploadProperties> {

    private static final long serialVersionUID = 1L;
    @XmlTransient
    @TableId("ID_")
    @ApiModelProperty(value = "主键")
    protected String id;

    @ApiModelProperty(value = "附件存储配置ID")
    @TableField("STORAGE_ID_")
    private String storageId;

    @XmlAttribute(name = "name")
    @TableField("NAME_")
    @ApiModelProperty(value = "名称")
    protected String name;

    @XmlAttribute(name = "flowKey")
    @TableField("FLOW_KEY_")
    @ApiModelProperty(value = "流程key")
    protected String flowKey;

    @XmlAttribute(name = "flowName")
    @TableField("FLOW_NAME_")
    @ApiModelProperty(value = "流程名称")
    protected String flowName;

    @XmlAttribute(name = "desc")
    @TableField("DESC_")
    @ApiModelProperty(value = "描述")
    protected String desc;

    @TableField("TENANT_ID_")
    @ApiModelProperty(name = "tenantId", notes = "租户id")
    protected String tenantId;

    @TableField(exist = false)
    @ApiModelProperty(name = "fileStorage", notes = "附件存储明细")
    protected List<FileStorage> fileStorage;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStorageId() {
        return storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFlowKey() {
        return flowKey;
    }

    public void setFlowKey(String flowKey) {
        this.flowKey = flowKey;
    }

    public String getFlowName() {
        return flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public List<FileStorage> getFileStorage() {
        return fileStorage;
    }

    public void setFileStorage(List<FileStorage> fileStorage) {
        this.fileStorage = fileStorage;
    }

    /**
     * @see Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this)
                .append("id", this.id)
                .append("name", this.name)
                .append("flowKey", this.flowKey)
                .append("flowName", this.flowName)
                .append("desc", this.desc)
                .append("tenantId", this.tenantId)
                .toString();
    }
}