package com.artfess.bo.persistence.manager.impl;

import java.io.IOException;
import java.util.List;

import javax.annotation.Resource;

import com.artfess.bo.persistence.manager.BoDefManager;
import org.springframework.stereotype.Service;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.persistence.dao.BoAttributeDao;
import com.artfess.bo.persistence.dao.BoEntDao;
import com.artfess.bo.persistence.manager.BoAttributeManager;

/**
 * 业务实体定义属性 处理实现类
 *
 * @author heyifan
 * @company 广州宏天软件股份有限公司
 * @email heyf@jee-soft.cn
 * @date 2018年4月12日
 */
@Service("boAttributeManager")
public class BoAttributeManagerImpl extends BaseManagerImpl<BoAttributeDao, BoAttribute> implements BoAttributeManager {
    @Resource
    BoEntDao boEntDao;
    @Resource
    BoDefManager boDefManager;

    @Override
    public List<BoAttribute> getByEntId(String entId) {
        BoEnt ent = boEntDao.selectById(entId);
        List<BoAttribute> list = baseMapper.getByEntId(entId);
        for (BoAttribute attribute : list) {
            attribute.setBoEnt(ent);
        }
        return list;
    }

    @Override
    public List<BoAttribute> getByBoEnt(BoEnt boEnt) {
        List<BoAttribute> list = baseMapper.getByEntId(boEnt.getId());
        for (BoAttribute attribute : list) {
            attribute.setBoEnt(boEnt);
        }
        return list;
    }

    @Override
    public void removeByEntId(String entId) {
        baseMapper.removeByEntId(entId);
    }

    @Override
    public void updateAttrStatus(String json, String alias) throws IOException {
        BoAttribute boAttribute = JsonUtil.toBean(json, BoAttribute.class);
        if (StringUtil.isNotEmpty(boAttribute.getId())) {
            boDefManager.delBodefFromCache(alias);
            boAttribute.setStatus("hide");
            baseMapper.updateById(boAttribute);
        }
    }

    @Override
    public void recovery(String json, String alias) throws Exception {
        BoAttribute boAttribute = JsonUtil.toBean(json, BoAttribute.class);
        if (StringUtil.isNotEmpty(boAttribute.getId())) {
            boDefManager.delBodefFromCache(alias);
            boAttribute.setStatus("show");
            baseMapper.updateById(boAttribute);
        }
    }

    @Override
    public void deleteByDefId(String defId) {
        baseMapper.deleteByDefId(defId);
    }

    @Override
    public void create(BoAttribute attr) {
        validateAttrDataType(attr);
        super.create(attr);
    }

    @Override
    public void update(BoAttribute attr) {
        validateAttrDataType(attr);
        super.update(attr);
    }

    private void validateAttrDataType(BoAttribute attr) {
        if (!BoAttribute.ATTR_TYPE_LIST.contains(attr.getDataType())) {
            throw new BaseException(String.format("实体【%s】下的字段【%s】数据类型为【%s】不符合规范，只能是【%s】其中一种", attr.getBoEnt().getDesc(),
                    attr.getDesc(), attr.getDataType(), StringUtil.join(BoAttribute.ATTR_TYPE_LIST)));
        }
    }
}
