package com.artfess.form.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.form.model.ComponentFunctionEntity;
import com.artfess.form.persistence.dao.ComponentFunctionDao;
import com.artfess.form.persistence.manager.ComponentFunctionManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @program: cqgs
 * @Date: 2020/9/26 15:44
 * @Author: ZQF
 * @Description: 建模引擎-元件管理-取值函数
 */
@Service
public class ComponentFunctionServiceImpl extends BaseManagerImpl<ComponentFunctionDao, ComponentFunctionEntity> implements ComponentFunctionManager {

    @Autowired
    ComponentFunctionDao componentFunctionMapper;

    @Override
    @Transactional
    public String insertComponentFunction(ComponentFunctionEntity componentFunctionEntity) {
        Assert.notNull(componentFunctionEntity, "参数为空，请检查后尝试！");
        //获取排序号
        Integer nextSequence = this.getNextSequence(null);
        componentFunctionEntity.setSn(nextSequence);
        //数据合法性验证
        this.checkValidity(componentFunctionEntity);
        this.componentFunctionMapper.insert(componentFunctionEntity);
        return componentFunctionEntity.getId();
    }

    @Override
    @Transactional
    public String updateComponentFunction(ComponentFunctionEntity componentFunctionEntity) {
        Assert.notNull(componentFunctionEntity, "参数为空，请检查后尝试！");
        //数据合法性验证
        this.checkValidity(componentFunctionEntity);
        this.componentFunctionMapper.updateById(componentFunctionEntity);
        return componentFunctionEntity.getId();
    }

    @Override
    public ComponentFunctionEntity loadComponentFunction(String id) {
        Assert.hasText(id, "参数id为空，请检查后尝试！");
        return this.getById(id);
    }

    @Override
    @Transactional
    public Integer deleteComponentFunction(String ids) {
        Assert.hasText(ids, "参数ids为空，请检查后尝试！");
        List<String> idsList = Arrays.asList(ids.split(","));
        return this.componentFunctionMapper.deleteBatchIds(idsList);
    }

    @Override
    public List<ComponentFunctionEntity> queryComponentFunction(ComponentFunctionEntity componentFunctionEntity) {
        QueryWrapper<ComponentFunctionEntity> queryWrapper = new QueryWrapper<>();
        //查询条件
        queryWrapper.like(StringUtils.isNotBlank(componentFunctionEntity.getFunName()), "FUN_NAME", componentFunctionEntity.getFunName());
        queryWrapper.eq(Objects.nonNull(componentFunctionEntity.getFunType()), "FUN_TYPE", componentFunctionEntity.getFunType());
        queryWrapper.like(StringUtils.isNotBlank(componentFunctionEntity.getFunQzCode()), "FUN_QZ_CODE", componentFunctionEntity.getFunQzCode());
        //排序规则
        queryWrapper.orderByAsc("SEQUENCE");
        return this.componentFunctionMapper.selectList(queryWrapper);
    }

//    @Override
//    public Page<ComponentFunctionEntity> slicedQueryComponentFunction(BasePage<ComponentFunctionEntity> pageRequest) {
//        QueryWrapper<ComponentFunctionEntity> queryWrapper = new QueryWrapper<>();
//        //分页查询条件
//        queryWrapper.like(StringUtils.isNotBlank(pageRequest.getParam().getFunName()), "FUN_NAME", pageRequest.getParam().getFunName());
//        queryWrapper.eq(Objects.nonNull(pageRequest.getParam().getFunType()), "FUN_TYPE", pageRequest.getParam().getFunType());
//        queryWrapper.like(StringUtils.isNotBlank(pageRequest.getParam().getFunQzCode()), "FUN_QZ_CODE", pageRequest.getParam().getFunQzCode());
//        queryWrapper.eq(Objects.nonNull(pageRequest.getParam().getFlag()), "FLAG", pageRequest.getParam().getFlag());
//        //分页查询排序规则
//        pageRequest.getOrders().forEach(s -> queryWrapper.orderBy(StringUtils.isNotBlank(s.getColumn()), s.isAsc(), s.getColumn()));
//        IPage<ComponentFunctionEntity> pages = this.componentFunctionMapper.selectPage(pageRequest, queryWrapper);
//        Page<ComponentFunctionEntity> page = new Page<>(pageRequest.getCurrent(), pageRequest.getSize());
//        page.setRecords(pages.getRecords());
//        if (pageRequest.isSearchCount()) {
//            page.setTotal(pages.getTotal());
//        }
//        return page;
//    }

    @Override
    @Transactional
    public void updateComponentFunctionStatus(String ids, Integer status) {
        List<String> idsList = Arrays.asList(ids.split(","));
//        checkIdsNotEmpty(idsList);
//        this.updateEntityFlags(idsList, status);

//        List<ComponentFunctionEntity> list=this.componentFunctionMapper.selectBatchIds(idsList);
//        for(ComponentFunctionEntity item : list){
//            this.update(item);
//        }


    }

    /**
     * @param componentFunctionEntity
     * @Description: 数据合法性校验
     * @Return: void
     * @Author: ZQF
     * @Date: 2020/9/27 9:40
     */
    private void checkValidity(ComponentFunctionEntity componentFunctionEntity) {
        //名称不重复
        QueryWrapper<ComponentFunctionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotBlank(componentFunctionEntity.getFunName()), "FUN_NAME", componentFunctionEntity.getFunName());
        queryWrapper.ne(StringUtils.isNotBlank(componentFunctionEntity.getId()), "ID", componentFunctionEntity.getId());
        Integer count = this.componentFunctionMapper.selectCount(queryWrapper);
        if (count > 0) {
            throw new ApplicationException("名称已存在，请检查后尝试！");
        }
    }

}
