package com.artfess.form.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import java.time.LocalDateTime;

/**
 * 数据报表草稿数据
 * <pre>
 * 描述：数据报表草稿数据 实体对象
 * 构建组：x7
 * 作者:pangq
 * 邮箱:pangq@jee-soft.cn
 * 日期:2020-06-13 13:45:06
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@TableName("form_data_template_draft")
@ApiModel(value = "FormDataTemplateDraft", description = "数据报表草稿数据")
public class FormDataTemplateDraft extends BaseModel<FormDataTemplateDraft> {

    private static final long serialVersionUID = 1L;
    @XmlTransient
    @TableId("ID_")
    @ApiModelProperty(value = "主键")
    protected String id;

    @XmlAttribute(name = "title")
    @TableField("TITLE_")
    @ApiModelProperty(value = "标题")
    protected String title;

    @XmlAttribute(name = "tempAlias")
    @TableField("TEMP_ALIAS_")
    @ApiModelProperty(value = "数据报表别名")
    protected String tempAlias;

    @XmlAttribute(name = "dataJson")
    @TableField("DATA_JSON_")
    @ApiModelProperty(value = "报表数据json")
    protected String dataJson;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "CREATE_TIME_", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "创建人")
    @TableField(value = "CREATE_BY_", fill = FieldFill.INSERT)
    private String createBy;

    @ApiModelProperty(value = "更新时间")
    @TableField(value = "UPDATE_TIME_", fill = FieldFill.UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "更新人")
    @TableField(value = "UPDATE_BY_", fill = FieldFill.UPDATE)
    private String updateBy;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTempAlias() {
        return tempAlias;
    }

    public void setTempAlias(String tempAlias) {
        this.tempAlias = tempAlias;
    }

    public String getDataJson() {
        return dataJson;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }
}