package com.artfess.form.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.JsonUtil;
import com.artfess.form.dao.FormDataTemplateExtendDao;
import com.artfess.form.manager.FormDataTemplateExtendManager;
import com.artfess.form.manager.FormRemindDataManager;
import com.artfess.form.model.FormDataTemplateExtend;
import com.artfess.form.model.FormRemindData;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Service
public class FormDataTemplateExtendManagerImpl extends BaseManagerImpl<FormDataTemplateExtendDao, FormDataTemplateExtend> implements FormDataTemplateExtendManager {

    @Resource
    FormRemindDataManager formRemindDataManager;

    @Override
    public void save(String json, String formDataTemplateId) throws IOException {
        List<FormDataTemplateExtend> listFormDataTemplateExtend = baseMapper.selectList(new QueryWrapper<FormDataTemplateExtend>().eq("FORM_DATA_TEMPLATE_ID", formDataTemplateId));
        for (int i = 0; i < listFormDataTemplateExtend.size(); i++) {
            formRemindDataManager.deleteFormRemindDataByBoDataId(new QueryWrapper<FormRemindData>().eq("REF_ID_", listFormDataTemplateExtend.get(i).getId()));
        }
        baseMapper.delete(new QueryWrapper<FormDataTemplateExtend>().eq("FORM_DATA_TEMPLATE_ID", formDataTemplateId));
        List<FormDataTemplateExtend> list = new ArrayList<>();
        ArrayNode node = (ArrayNode) JsonUtil.toJsonNode(json);
        for (int i = 0; i < node.size(); i++) {
            FormDataTemplateExtend item = JsonUtil.toBean(node.get(i), FormDataTemplateExtend.class);
            item.setFormDataTemplateId(formDataTemplateId);
            list.add(item);
        }
        this.saveBatch(list);
    }

    @Override
    public String getJsonByFormDataTemplateId(String formDataTemplateId) throws IOException {
        String json = "";
        List<FormDataTemplateExtend> list = baseMapper.selectList(new QueryWrapper<FormDataTemplateExtend>().eq("FORM_DATA_TEMPLATE_ID", formDataTemplateId));
        if (list.size() > 0) {
            json = JsonUtil.toJson(list);
        }
        return json;
    }

    @Override
    public List<FormDataTemplateExtend> getDataTemplateExtendByFormKey(String formKey) {

        return baseMapper.getDataTemplateExtendByFormKey(formKey);
    }

}
