package com.artfess.form.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.form.model.FormDataImportLog;
import com.artfess.form.persistence.manager.FormDataImportLogManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <pre>
 * 描述：form_data_import_log 控制器类
 * 构建组：x7
 * 作者:heyf
 * 邮箱:heyf@jee-soft.cn
 * 日期:2020-06-18 14:10:21
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value = "/form/formDataImportLog/v1")
@Api(tags = "formDataImportLogController")
public class FormDataImportLogController extends BaseController<FormDataImportLogManager, FormDataImportLog> {
    @Resource
    FormDataImportLogManager formDataImportLogManager;

    /**
     * form_data_import_log列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/listJson")
    @ApiOperation(value = "form_data_import_log数据列表", httpMethod = "POST", notes = "获取form_data_import_log列表")
    public PageList<FormDataImportLog> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter queryFilter) throws Exception {
        return formDataImportLogManager.query(queryFilter);
    }

    /**
     * form_data_import_log明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/getJson")
    @ApiOperation(value = "form_data_import_log数据详情", httpMethod = "GET", notes = "form_data_import_log数据详情")
    public FormDataImportLog get(@ApiParam(name = "id", value = "业务对象主键", required = true) @RequestParam String id) throws Exception {
        return formDataImportLogManager.get(id);
    }

    /**
     * 新增form_data_import_log
     *
     * @param formDataImportLog
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "save")
    @ApiOperation(value = "新增,更新form_data_import_log数据", httpMethod = "POST", notes = "新增,更新form_data_import_log数据")
    public CommonResult<String> save(@ApiParam(name = "formDataImportLog", value = "form_data_import_log业务对象", required = true) @RequestBody FormDataImportLog formDataImportLog) throws Exception {
        String msg = "添加form_data_import_log成功";
        if (StringUtil.isEmpty(formDataImportLog.getId())) {
            formDataImportLogManager.create(formDataImportLog);
        } else {
            formDataImportLogManager.update(formDataImportLog);
            msg = "更新form_data_import_log成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 批量删除form_data_import_log记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove")
    @ApiOperation(value = "批量删除form_data_import_log记录", httpMethod = "DELETE", notes = "批量删除form_data_import_log记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        formDataImportLogManager.removeByIds(ids);
        return new CommonResult<String>(true, "批量删除成功");
    }
}
