package com.artfess.base.entity;

import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.artfess.base.util.CommonUtil;
import io.swagger.annotations.ApiModelProperty;
import org.jsoup.helper.StringUtil;
import org.springframework.util.Assert;

/**
 * 基础树实体类
 *
 * @company 阿特菲斯
 * @author chens
 * @email chens@artfess.com
 * @date 2021年3月5日
 */
public abstract class BaseTreeModel<T extends BaseTreeModel<?>> extends BaseModel<T>{
	private static final long serialVersionUID = 1L;

	@TableId("ID_")
	@ApiModelProperty(value="主键")
	protected String id;

	@ApiModelProperty(value = "编码")
	@TableField(value = "CODE_",condition=SqlCondition.LIKE)
	protected String code;

	@ApiModelProperty(value = "名称")
	@TableField(value = "NAME_",condition=SqlCondition.LIKE)
	protected String name;

	@ApiModelProperty(value = "上级_ID")
	@TableField("PARENT_ID_")
	protected String parentId;

	@ApiModelProperty(value = "子节点个数")
	@TableField("HAS_CHILDREN_")
	protected Integer hasChildren;

	@ApiModelProperty(value = "ID_全路径")
	@TableField(value = "FULL_ID_",condition = SqlCondition.LIKE_RIGHT)
	protected String fullId;

	@ApiModelProperty(value = "名称_全路径")
	@TableField(value = "FULL_NAME_",condition = SqlCondition.LIKE_RIGHT )
	protected String fullName;

	@ApiModelProperty(value = "排序号")
	@TableField("SN_")
	protected Integer sn;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public Integer getHasChildren() {
		return hasChildren;
	}

	public void setHasChildren(Integer hasChildren) {
		this.hasChildren = hasChildren;
	}

	public String getFullId() {
		return fullId;
	}

	public void setFullId(String fullId) {
		this.fullId = fullId;
	}

	public String getFullName() {
		return fullName;
	}

	public void setFullName(String fullName) {
		this.fullName = fullName;
	}

	public Integer getSn() {
		return sn;
	}

	public void setSn(Integer sn) {
		this.sn = sn;
	}

	public void checkConstraints() {
		Assert.hasText(this.code, "编码不能为空。");
		Assert.hasText(this.name, "名称不能为空。");
	}

	public void checkConstraints(BaseTreeModel other) {
		checkConstraints();
		if (other != null) {
			Assert.isTrue(!getCode().equalsIgnoreCase(other.getCode()),"编码不能重复。");
			Assert.isTrue(!getName().equalsIgnoreCase(other.getName()),"名称不能重复。");
		}
	}

	public void buildFullIdAndName(BaseTreeModel parent) {
		String fullId = CommonUtil.createFileFullName(((parent == null) || (parent.getFullId() == null)) ? "": parent.getFullId(), getId().toString(), "");
		String fullName = CommonUtil.createFileFullName(((parent == null) || (parent.getFullName() == null)) ? "": parent.getFullName(), getName(), "");
		setFullId(fullId);
		setFullName(fullName);
	}

	@JsonIgnore(value = true)
	public boolean isNew() {
		return StringUtil.isBlank(this.id);
	}

	public boolean isUpdateName(String oldName) {
		return ((!(isNew())) && (!(this.name.equalsIgnoreCase(oldName))));
	}
}
