package com.artfess.application.persistence.manager.impl;

import com.artfess.application.model.MessageConfig;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.persistence.dao.MsgConfigDao;
import com.artfess.application.persistence.dao.MsgTemplateDao;
import com.artfess.application.persistence.manager.MessageConfigManager;
import com.artfess.base.exception.SystemException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service("MessageConfigManager")
public class MessageConfigManagerImpl extends BaseManagerImpl<MsgConfigDao, MessageConfig> implements MessageConfigManager {
    @Resource
    MsgConfigDao msgconfigDao;
    @Override
    public PageList<MessageConfig> queryByTemplateName(QueryFilter queryFilter) {
        this.copyQuerysInParams(queryFilter);
        handleQueryFilter(queryFilter);
        PageBean pageBean = queryFilter.getPageBean();
        if (BeanUtils.isEmpty(pageBean)) {
            pageBean = new PageBean(1, 50, true);
        }
        IPage<MessageConfig> query = msgconfigDao.queryByTemplateName(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<MessageConfig>(query);
    }
    private void handleQueryFilter(QueryFilter queryFilter) throws SystemException {
        if (BeanUtils.isEmpty(queryFilter)) {
            throw new SystemException("QueryFilter通用查询对象不能为空.");
        }
    }
}
