package com.artfess.application.persistence.manager.impl;

import com.artfess.application.model.BizErrLogs;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.WebUtil;
import com.artfess.es.unit.ElasticSearchApplication;
import com.mzt.logapi.beans.LogRecord;
import com.mzt.logapi.service.ILogRecordService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

/**
 * @program: edp
 * @Date: 2021/3/10 16:59
 * @Author: llj
 * @Description:
 */
@Service
public class DbLogRecordServiceImpl implements ILogRecordService {

    //将日志写入es
    @Resource
    ElasticSearchApplication elasticSearchApplication;

    @Override
    public void record(LogRecord logRecord) {
        //重写日志保存方法
        BizErrLogs bizErrLogs = new BizErrLogs(logRecord);
        HttpServletRequest request = HttpUtil.getRequest();
        String action = logRecord.getAction();
        if(null != request){
            bizErrLogs.setIp(WebUtil.getIpAddr(request));
            bizErrLogs.setReqUrl(request.getRequestURI());
        }
        if(action.contains("exception") || action.contains("Exception") || action.contains("失败")){
            bizErrLogs.setLogType("异常日志");
        }else{
            bizErrLogs.setLogType("操作日志");
        }
        bizErrLogs.setExecutionTime(new Date().getTime());

//        String executor = "系统[无用户登录系统]";
//        if(StringUtil.isNotEmpty(AuthenticationUtil.getCurrentUserFullname())){
//            executor = String.format("%s[%s]",AuthenticationUtil.getCurrentUserFullname(),AuthenticationUtil.getCurrentUsername());
//        }

        //租户id
//        String tenantId = ContextUtil.getCurrentUser().getTenantId();
//        logRecord.setTenant(tenantId);

//        boolean edp_log = elasticSearchApplication.existsIndex("edp_log", "1");
        elasticSearchApplication.insertDocument("bpm_log", UniqueIdUtil.getSuid(),bizErrLogs);
//        String ceshiku = elasticSearchApplication.queryById("ceshiku", bizNo, String.class);
//        System.out.println("es:"+  ceshiku);


    }

    @Override
    public List<LogRecord> queryLog(String bizKey) {
        return null;
    }

    @Override
    public List<LogRecord> queryLogByBizNo(String bizNo) {
        return null;
    }
}
