package com.artfess.xqxt.meeting.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.uc.exception.BaseException;
import com.artfess.xqxt.meeting.dao.BizMeetingEntrustLogDao;
import com.artfess.xqxt.meeting.manager.BizMeetingEntrustLogManager;
import com.artfess.xqxt.meeting.manager.MeetingManager;
import com.artfess.xqxt.meeting.manager.MeetingUserManager;
import com.artfess.xqxt.meeting.model.BizMeetingEntrustLog;
import com.artfess.xqxt.meeting.model.Meeting;
import com.artfess.xqxt.meeting.model.MeetingUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 参会人员变更记录 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author naf
 * @since 2023-05-17
 */
@Service
public class BizMeetingEntrustLogManagerImpl extends BaseManagerImpl<BizMeetingEntrustLogDao, BizMeetingEntrustLog> implements BizMeetingEntrustLogManager {

    @Resource
    MeetingManager meetingManager;


    @Resource
    private MeetingUserManager meetingUserManager;


    /**
     * 参会人委托他人参会
     * @param entity 参会人员变更记录 实体对象
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int entruset(BizMeetingEntrustLog entity) {

        String meetingId = entity.getMeetingId();
        Assert.notNull(meetingId, "会议ID不能为空");
        QueryWrapper<MeetingUser> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("MEETING_ID_", meetingId).eq("USER_ID_", entity.getEntrustUser());
        List<MeetingUser> list = meetingUserManager.list(queryWrapper);
        if(null == list || list.size() == 0){
            throw new BaseException("未查询到您参加该会议，无需反馈！");
        }
        String feedBack = list.get(0).getFeedBack();
        if(null != feedBack  && feedBack.equals("4")){
            throw new BaseException("您已委托他人，无法继续委托！");
        }

        QueryWrapper<MeetingUser> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("MEETING_ID_", meetingId).eq("USER_ID_", entity.getEntrustMeetUser());
        List<MeetingUser> list1 = meetingUserManager.list(queryWrapper);
        if(null != list1 && list1.size() > 0){
            throw new BaseException("该人员已在参会名单中，无法委托！");
        }

        Meeting meeting = meetingManager.getById(meetingId);

        //修改参会人反馈相关信息
        for (MeetingUser meetingUser : list) {
            // 状态置为已反馈
            meetingUser.setFeedBackStatus("0");
            //设置原因
            meetingUser.setNotJoiningReasons(entity.getEntrustReason());
            // 设置反馈时间
            meetingUser.setFeedBackDate(LocalDateTime.now());
            meetingUser.setFeedBackStatus("4");
            meetingUserManager.update(meetingUser);
        }
        //新增参会人员
        MeetingUser user = new MeetingUser();
        user.setUserName(entity.getEntrustMeetUserName());
        user.setUserId(entity.getEntrustMeetUser());
        user.setMeetingId(meeting.getId());
        user.setSignInStatus(1);
        user.setSignOutStatus(1);
        user.setSignInType(2);
        //由他人委托
        user.setIsEntrust(1);
        meetingUserManager.save(user);

        //新增变更记录
        if(null == entity.getRootUser()){
            entity.setRootUser(entity.getEntrustUser());
            entity.setRootUserName(entity.getEntrustUserName());
        }
        if(null == entity.getVersion()){
            int i =0;
            entity.setVersion(i++);
        }else {
            entity.setVersion(entity.getVersion()+1);
        }
        //保证ID为null
        entity.setId(null);
        this.save(entity);
        // 发送会议委托企业微信提醒
        meetingManager.toEntrustSend(meeting,entity.getEntrustUserName(), entity.getEntrustMeetUser(),entity.getEntrustMeetUserName());
        return 0;
    }

}
