package com.artfess.xqxt.meeting.controller;



import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.CertificateException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.TokenUtils;
import com.artfess.uc.exception.BaseException;
import com.artfess.xqxt.meeting.manager.BizMeetingAccessoryManager;
import com.artfess.xqxt.meeting.manager.BizMeetingVoteManager;
import com.artfess.xqxt.meeting.model.BizMeetingAccessory;
import com.artfess.xqxt.meeting.model.BizMeetingVote;
import com.artfess.xqxt.meeting.vo.MeetingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import io.swagger.annotations.ApiParam;
import lombok.AllArgsConstructor;
import org.springframework.security.authentication.LockedException;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;



@RestController
@Api(value = "文件本地上传下载", tags = "文件本地上传下载")
@RequestMapping("/api/file/local")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class MeetingFileController extends BaseController<BizMeetingAccessoryManager, BizMeetingAccessory> {

    @Resource
    private BizMeetingAccessoryManager bizMeetingAccessoryManager;


    /**
     * 文件上传
     *
     * @return
     */
    @ApiOperation(value = "文件上传")
    @PostMapping("/upload/{id}")
    public CommonResult<String> upload(@RequestParam MultipartFile file, @PathVariable String id) throws IOException {
        return new CommonResult<>(true, "上传成功",  bizMeetingAccessoryManager.upload(file,id));

    }

    /**
     * 文件上传
     *
     * @return
     */
    @ApiOperation(value = "单独文件上传")
    @PostMapping("/uploadFile")
    public CommonResult<String> uploadFile(@RequestParam MultipartFile file) throws IOException {
        return new CommonResult<>(true, "上传成功",  bizMeetingAccessoryManager.upload(file,null));

    }

    /**
     * 文件下载
     */
    @ApiOperation(value = "文件下载")
    @GetMapping("/download/{id}")
    public void download(@PathVariable Long id, HttpServletRequest req, HttpServletResponse res) {
        bizMeetingAccessoryManager.download(id, req, res);
    }

    /**
     * 文件预览
     */
    @ApiOperation(value = "文件预览-返回二进制")
    @GetMapping("/preview/{id}")
    public void preview(@PathVariable Long id, HttpServletRequest req, HttpServletResponse res) {
        bizMeetingAccessoryManager.preview(id, req, res);
    }

    /**
     * 文件预览
     */
    @ApiOperation(value = "文件预览-通过请求地址预览")
    @PostMapping("/online/")
    public void previewOnline(@RequestBody String token) throws  Exception{
       Assert.notNull(token, "Token不能为空");
//       token = Base64.getFromBase64(token);
       if(!TokenUtils.verifyToken(token)){
           System.out.println("nnnnnnnnnnnnnnnnnnnn");
//           throw new BaseException("Token验证不通过，请刷新后重试！");
       }
        System.out.println("ttttttttttttttttttttttt");
//        throw new BaseException("验证通过了。。。。。。。！");
    }


}
