package com.artfess.xqxt.meeting.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.xqxt.meeting.manager.BizTerminalManager;
import com.artfess.xqxt.meeting.model.BizMeetingPlaceName;
import com.artfess.xqxt.meeting.model.BizTerminal;
import com.artfess.xqxt.meeting.model.Meeting;
import com.artfess.xqxt.meeting.vo.BizSiteParamExVO;
import com.artfess.xqxt.meeting.vo.MeetingVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.xqxt.meeting.model.BizSiteParamEx;
import com.artfess.xqxt.meeting.manager.BizSiteParamExManager;

import javax.annotation.Resource;
import java.text.ParseException;
import java.util.*;

/**
 *  前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-08-05
 */
@RestController
@RequestMapping("/bizSiteParamEx/v1/")
@Api(tags = "会议室模块")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizSiteParamExController extends BaseController<BizSiteParamExManager, BizSiteParamEx> {


    @Autowired
    private BizSiteParamExManager siteParamExManager;


    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="实体信息") @RequestBody BizSiteParamEx entity) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("type","1");
        Integer nextSequence = baseService.getNextSequence(map);
        entity.setSequence(nextSequence);

        boolean result = baseService.save(entity);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }


    @RequestMapping(value = "/getJsonById/{id}", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "根据分组ID查询会议室", httpMethod = "POST")
    public CommonResult<List<BizSiteParamExVO>> getJsonById(
            @ApiParam(name = "id", value = "业务对象主键", required = false) @PathVariable String id,
            @RequestParam(value ="type", required = false)String type
            ,@RequestParam(value ="name",required = false)String name,
            @RequestParam(value ="startTime",required = false)String startTime,
            @RequestParam(value ="endTime",required = false)String endTime) throws ParseException {
        return new CommonResult<List<BizSiteParamExVO>>
                (true, "数据查询成功", baseService.findByGroupId(id, type,name,startTime,endTime));
    }

    @Override
    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<BizSiteParamEx> query(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizSiteParamEx> queryFilter) {

        List<FieldSort> sorter = new ArrayList<>();
        sorter.add(new FieldSort("SEQUENCE", Direction.ASC));
        queryFilter.setSorter(sorter);

        return baseService.query(queryFilter);
    }






    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除会议室", httpMethod = "DELETE", notes = "批量删除会议室")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }



    @RequestMapping(value = "/updateGroupBySiteId", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改会场分组", httpMethod = "POST", notes = "修改会场分组")
    public CommonResult<String> updateGroupBySiteId(@ApiParam(name = "id", value = "会场ID", required = true) @RequestParam String id,
                                        @ApiParam(name = "groupId", value = "组织ID") @RequestParam String groupId) throws Exception {
        siteParamExManager.updateGroupBySiteId(id, groupId);
        return new CommonResult<String>(true, "会场分组修改成功");
    }


}
