/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.persistence.dao.BpmCallLogDao;
import com.artfess.bpm.persistence.manager.BpmCallLogManager;
import com.artfess.bpm.persistence.model.BpmCallLog;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmCallLogManager")
public class BpmCallLogManagerImpl
extends BaseManagerImpl<BpmCallLogDao, BpmCallLog>
implements BpmCallLogManager {
    @Resource
    BpmCallLogDao bpmCallLogDao;

    @Override
    @Transactional
    public void reinvoke(String id) throws Exception {
        BpmCallLog bpmCallLog = (BpmCallLog)this.get((Serializable)((Object)id));
        try {
            String response = this.reinvokeByLog(bpmCallLog);
            bpmCallLog.setResponse(response);
            int time = BeanUtils.isEmpty((Object)bpmCallLog.getRetryCount()) ? 0 : bpmCallLog.getRetryCount();
            bpmCallLog.setRetryCount(time + 1);
            bpmCallLog.setIsSuccess(BpmCallLog.SUCCESS_YES);
            this.update((Model)bpmCallLog);
        }
        catch (Exception e) {
            bpmCallLog.setIsSuccess(BpmCallLog.SUCCESS_NO);
            this.update((Model)bpmCallLog);
            throw new WorkFlowException("\u91cd\u8c03\u5931\u8d25\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    @Override
    @Transactional
    public void signSuccess(String id) {
        BpmCallLog bpmCallLog = (BpmCallLog)this.get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)((Object)bpmCallLog))) {
            bpmCallLog.setIsSuccess(BpmCallLog.SUCCESS_YES);
            this.update((Model)bpmCallLog);
        }
    }

    private String reinvokeByLog(BpmCallLog bpmCallLog) throws Exception {
        Request request = Request.Post((String)bpmCallLog.getUrl());
        request = this.setHeaders(request, bpmCallLog.getHeader());
        String response = request.bodyString(bpmCallLog.getParams(), ContentType.APPLICATION_JSON).execute().returnContent().toString();
        return response;
    }

    private Request setHeaders(Request request, String headerStr) {
        if (StringUtil.isNotEmpty((String)headerStr)) {
            try {
                headerStr = Base64.getFromBase64((String)headerStr);
                if (StringUtil.isEmpty((String)headerStr) || "\"\"".equals(headerStr)) {
                    return request;
                }
                ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((String)headerStr);
                Iterator it = obj.fieldNames();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    request.setHeader(key, obj.get(key).asText());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return request;
    }
}

