/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.handler;

import com.artfess.base.aop.AopCacheHelper;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ExceptionUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.WebUtil;
import com.artfess.base.util.time.DateUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import feign.RetryableException;
import java.io.Serializable;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ibatis.binding.BindingException;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice(annotations={RestController.class, Controller.class})
public class BaseExceptionHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static String moduleType = "base";

    @Value(value="${spring.profiles.title:base}")
    public void setModuleType(String param) {
        moduleType = param;
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public CommonResult<String> badRequest(BindException e) {
        String opeContent = ExceptionUtil.getFullStackTrace((Throwable)e);
        this.log.error("occurs error when execute method ,message {}", (Object)opeContent);
        this.saveExceptionLogs(opeContent);
        return new CommonResult<String>(ResponseErrorEnums.BAD_REQUEST);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public CommonResult<String> badRequestNotFound(BindException e) {
        String opeContent = ExceptionUtil.getFullStackTrace((Throwable)e);
        this.log.error("occurs error when execute method ,message {}", (Object)opeContent);
        this.saveExceptionLogs(opeContent);
        return new CommonResult<String>(ResponseErrorEnums.NOT_FOUND);
    }

    @ExceptionHandler(value={BindingException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> mybatis(Exception e) {
        String opeContent = ExceptionUtil.getFullStackTrace(e);
        this.log.error("occurs error when execute method ,message {}", (Object)opeContent);
        this.saveExceptionLogs(opeContent);
        return new CommonResult<String>(ResponseErrorEnums.BOUND_STATEMENT_NOT_FOUNT);
    }

    @ExceptionHandler(value={BaseException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public <T extends Serializable> CommonResult<T> sendError(BaseException exception, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String opContent = this.getErrorDetail(exception);
        this.log.error("occurs error when execute url ={} ,message {}", (Object)requestURI, (Object)opContent);
        String errorId = this.saveExceptionLogs(opContent);
        CommonResult commonResult = new CommonResult(exception.getCode(), exception.getMessage());
        commonResult.setLogId(errorId);
        return commonResult;
    }

    @ExceptionHandler(value={SQLException.class, DataAccessException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> systemError(Exception e) {
        String opeContent = ExceptionUtil.getFullStackTrace(e);
        this.log.error("occurs error when execute method ,message {}", (Object)opeContent);
        String errorId = this.saveExceptionLogs(opeContent);
        if (e instanceof MyBatisSystemException) {
            return new CommonResult<String>(((MyBatisSystemException)e).getRootCause().getMessage());
        }
        CommonResult<String> commonResult = new CommonResult<String>(ResponseErrorEnums.DATABASE_ERROR);
        commonResult.setMessage("\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u67e5\u770b\u65e5\u5fd7\uff01");
        commonResult.setLogId(errorId);
        return commonResult;
    }

    @ExceptionHandler(value={ConnectException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> connect(Exception e) {
        String opeContent = ExceptionUtil.getFullStackTrace(e);
        this.log.error("occurs error when execute method ,message {}", (Object)opeContent);
        this.saveExceptionLogs(opeContent);
        return new CommonResult<String>(ResponseErrorEnums.CONNECTION_ERROR);
    }

    @ExceptionHandler(value={HystrixRuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> hystrixRuntimeError(HystrixRuntimeException e) {
        this.log.error("occurs error when execute method ,message {}", (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        CommonResult<String> result = null;
        result = e.getCause() instanceof TimeoutException || e.getCause() instanceof RetryableException ? new CommonResult<String>(ResponseErrorEnums.SERVICE_INVOKE_ERROR, "\u670d\u52a1\u8c03\u7528\u8d85\u65f6\uff1a" + e.getLocalizedMessage()) : new CommonResult(false, "\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        String opeContent = ExceptionUtil.getFullStackTrace((Throwable)e);
        this.saveExceptionLogs(opeContent);
        return result;
    }

    private String getErrorDetail(BaseException e) {
        String opeContent = "";
        opeContent = BeanUtils.isNotEmpty(ExceptionUtil.getRootCauseMessage(e)) ? ExceptionUtil.getFullStackTrace(ExceptionUtil.getRootCause(e)) : ExceptionUtil.getFullStackTrace(e);
        return opeContent;
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> runTimeError(Exception e) {
        String[] msgs;
        String opeContent = ExceptionUtil.getFullStackTrace(e);
        this.log.error("occurs error when execute method ,message {}", (Object)opeContent);
        String errorMsg = ExceptionUtil.getRootCauseMessage(e);
        String flowErrorMsg = ThreadMsgUtil.getMapMsg("msg_flow_error", true);
        if (StringUtil.isNotEmpty(errorMsg) && errorMsg.indexOf("\u6d41\u7a0b\u5f02\u5e38") > -1 && StringUtil.isNotEmpty(flowErrorMsg)) {
            errorMsg = flowErrorMsg;
        } else if (StringUtil.isNotEmpty(errorMsg) && (msgs = errorMsg.split("Exception:")).length == 2) {
            errorMsg = msgs[1];
        }
        String errorId = this.saveExceptionLogs(opeContent);
        CommonResult<String> commonResult = new CommonResult<String>(false, errorMsg);
        commonResult.setLogId(errorId);
        return commonResult;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> notAllowed(Exception e) {
        String opeContent = ExceptionUtil.getFullStackTrace(e);
        String errorMsg = "";
        errorMsg = BeanUtils.isNotEmpty(ExceptionUtil.extractMessageFromXML(e.getMessage())) ? ExceptionUtil.extractMessageFromXML(e.getMessage()) : e.getMessage();
        this.log.error("occurs error when execute method ,message {}", (Object)opeContent);
        String errorId = this.saveExceptionLogs(opeContent);
        CommonResult<String> commonResult = new CommonResult<String>(false, errorMsg);
        commonResult.setLogId(errorId);
        return commonResult;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> methodArgumentNotValidException(MethodArgumentNotValidException e) {
        StringBuffer stringBuffer = new StringBuffer();
        BindingResult bindingResult = e.getBindingResult();
        bindingResult.getAllErrors().forEach(error -> stringBuffer.append(error.getDefaultMessage() + " "));
        this.log.error("occurs error when execute method ,message {}", (Object)stringBuffer.toString());
        return new CommonResult<String>(ResponseErrorEnums.ILLEGAL_ARGUMENT.getCode(), stringBuffer.toString());
    }

    @ExceptionHandler(value={HttpMessageNotWritableException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> methodHttpMessageNotWritableException(HttpMessageNotWritableException e) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != e.getMessage() && e.getMessage().indexOf("application/octet-stream") != -1) {
            return null;
        }
        return new CommonResult<String>(ResponseErrorEnums.ILLEGAL_ARGUMENT.getCode(), stringBuffer.toString());
    }

    private String addErrorIdForMsg(String errorId, String errorMsg) {
        return "\u3010\u65e5\u5fd7ID\uff1a" + errorId + "\u3011" + errorMsg;
    }

    private String saveExceptionLogs(String opeContent) {
        AopCacheHelper aopCacheHelper = AppUtil.getBean(AopCacheHelper.class);
        JmsProducer jmsProducer = AppUtil.getBean(JmsProducer.class);
        String errorId = "";
        try {
            String executor = "\u7cfb\u7edf[\u65e0\u7528\u6237\u767b\u5f55\u7cfb\u7edf]";
            if (StringUtil.isNotEmpty(AuthenticationUtil.getCurrentUserFullname())) {
                executor = String.format("%s[%s]", AuthenticationUtil.getCurrentUserFullname(), AuthenticationUtil.getCurrentUsername());
            }
            HttpServletRequest request = HttpUtil.getRequest();
            String reqUrl = HttpUtil.getRequest().getRequestURI();
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            errorId = UniqueIdUtil.getSuid();
            objectNode.put("id", errorId);
            objectNode.put("opeName", "\u7cfb\u7edf\u5f02\u5e38");
            objectNode.put("moduleType", moduleType);
            objectNode.put("reqUrl", reqUrl);
            objectNode.put("opeContent", opeContent);
            objectNode.put("type", "sysLog");
            objectNode.putPOJO("executionTime", (Object)DateUtil.getCurrentDate());
            String tenantId = HttpUtil.getTenantId();
            if (BeanUtils.isEmpty(tenantId)) {
                tenantId = "-1";
            }
            objectNode.put("tenantId", tenantId);
            objectNode.put("logType", "\u5f02\u5e38\u65e5\u5fd7");
            objectNode.put("executor", executor);
            objectNode.put("ip", WebUtil.getIpAddr(request));
            jmsProducer.sendToQueue(JsonUtil.toJson(objectNode), "sysErrLogQueue");
        }
        catch (Exception err) {
            this.log.error("\u4fdd\u5b58\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25\u3002" + ExceptionUtils.getFullStackTrace((Throwable)err));
        }
        return errorId;
    }
}

