/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.xqxt.meeting.controller;

import com.alibaba.fastjson.JSONArray;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.xqxt.meeting.manager.BizMeetingTopicManager;
import com.artfess.xqxt.meeting.manager.BizMeetingVoteManager;
import com.artfess.xqxt.meeting.model.BizMeetingTopic;
import com.artfess.xqxt.meeting.model.BizMeetingVote;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizMeetingVote/v1"})
@Api(value="\u4f1a\u8bae\u6295\u7968", tags={"\u4f1a\u8bae\u6295\u7968"})
@ApiGroup(group={"group_biz"})
public class BizMeetingVoteController
extends BaseController<BizMeetingVoteManager, BizMeetingVote> {
    @Autowired
    private BizMeetingTopicManager topicManager;

    @ApiOperation(value="\u4fdd\u5b58\u6295\u7968\u4fe1\u606f", notes="\u517c\u5bb9\u65b0\u589e\u53ca\u4fee\u6539")
    @PostMapping(value={"/createVote"})
    public CommonResult<String> createVote(@RequestBody BizMeetingTopic topic) {
        boolean result = ((BizMeetingVoteManager)this.baseService).createVote(topic);
        return new CommonResult(result, "\u64cd\u4f5c" + (result ? "\u6210\u529f" : "\u5931\u8d25"), (Object)topic.getId());
    }

    @ApiOperation(value="\u7528\u6237\u6295\u7968")
    @PostMapping(value={"/vote"})
    @Transactional
    public CommonResult<String> vote(@RequestBody List<BizMeetingVote> vote) {
        boolean result = false;
        for (BizMeetingVote v : vote) {
            result = ((BizMeetingVoteManager)this.baseService).vote(v);
            if (result) continue;
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25\uff0c\u56de\u6eda\u4e8b\u52a1......");
        }
        return new CommonResult(result, "\u64cd\u4f5c" + (result ? "\u6210\u529f" : "\u5931\u8d25"));
    }

    @ApiOperation(value="\u4fee\u6539\u6295\u7968\u72b6\u6001", notes="\u4f7f\u7528\u5b57\u5178\uff081\uff1a\u5df2\u4fdd\u5b58\uff0c2\uff1a\u5f00\u542f\u6295\u7968\uff0c3\uff1a\u5173\u95ed\u6295\u7968\uff0c4\uff1a\u5df2\u53d1\u5e03\u6295\u7968\u7ed3\u679c\uff09")
    @PostMapping(value={"/changeVoteStatus"})
    public CommonResult<String> changeVoteStatus(@RequestBody BizMeetingTopic topic) {
        boolean result = ((BizMeetingVoteManager)this.baseService).changeVoteStatus(topic);
        return new CommonResult(result, "\u64cd\u4f5c" + (result ? "\u6210\u529f" : "\u5931\u8d25"));
    }

    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="\u6295\u7968\u8be6\u60c5\u00b7ID\u67e5\u8be2")
    public BizMeetingTopic getDetail(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizMeetingVoteManager)this.baseService).detail(id);
    }

    @PostMapping(value={"/queryVote"})
    @ApiOperation(value="\u6295\u7968\u8be6\u60c5\u00b7\u5206\u9875")
    public PageList<BizMeetingTopic> queryVote(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizMeetingTopic> queryFilter) {
        return ((BizMeetingVoteManager)this.baseService).selectByUserId(queryFilter);
    }

    @PostMapping(value={"/checkUserVote"})
    @ApiOperation(value="\u68c0\u67e5\u5f53\u524d\u7528\u6237\u662f\u5426\u5df2\u7ecf\u6295\u8fc7\u7968", notes="key \u4e3a\u95ee\u9898ID\uff0cvalue \u4e3a true \u8868\u793a\u5f53\u524d\u767b\u5f55\u7528\u6237\u5df2\u7ecf\u4e3a\u8be5\u95ee\u9898\u6295\u8fc7\u7968\u4e86")
    public CommonResult<Map<String, Boolean>> checkUserVote(@RequestParam String topicId) {
        Map<String, Boolean> result = ((BizMeetingVoteManager)this.baseService).checkUserVote(topicId);
        return new CommonResult(true, "", result);
    }

    @DeleteMapping(value={"/deleteVoteInfoByTopicIds"})
    @ApiOperation(value="\u6839\u636etopicId\u6279\u91cf\u5220\u9664\u6295\u7968\u4fe1\u606f")
    public CommonResult<String> deleteVoteInfoByTopicIds(String ... topicIds) {
        boolean result = this.topicManager.removeByIds(Arrays.asList(topicIds));
        return new CommonResult(result, "\u64cd\u4f5c" + (result ? "\u6210\u529f" : "\u5931\u8d25"));
    }

    @PostMapping(value={"/exportDataToExcel"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u5230Excel")
    public CommonResult<String> exportDataToExcel(@ApiParam(name="queryFilter", value="topic\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizMeetingTopic> queryFilter, HttpServletResponse response) throws IOException {
        ((BizMeetingVoteManager)this.baseService).exportDataToExcel(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }

    @PostMapping(value={"/getVoteResult"})
    @ApiOperation(value="\u6295\u7968\u7ed3\u679c", notes="\u4f20\u5165\u4f1a\u8baeID")
    public JSONArray getVoteResult(@ApiParam(name="meetingId", value="\u4f1a\u8baeID") @RequestParam String meetingId) {
        return ((BizMeetingVoteManager)this.baseService).getVoteResult(meetingId);
    }

    @PostMapping(value={"/votedCount"})
    @ApiOperation(value="\u6295\u7968\u7edf\u8ba1", notes="\u4f20\u5165topicId")
    public CommonResult<Integer> votedCount(@ApiParam(name="topicId", value="topicId") @RequestParam String topicId) {
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)((BizMeetingVoteManager)this.baseService).votedCount(topicId));
    }

    @PostMapping(value={"/checkTheme"})
    @ApiOperation(value="\u6295\u7968\u4e3b\u9898\u9a8c\u8bc1")
    public CommonResult<Integer> checkTheme(@ApiParam(name="meetingId", value="meetingId") @RequestParam String meetingId, @ApiParam(name="theme", value="theme") @RequestParam String theme) {
        if (((BizMeetingVoteManager)this.baseService).checkTheme(meetingId, theme) > 0) {
            return new CommonResult(false, "\u4e3b\u9898\u5df2\u5b58\u5728");
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }
}

