/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.JsonUtil;
import com.artfess.sysConfig.enums.BaseInfoStatus;
import com.artfess.sysConfig.persistence.dao.SysDictionaryCascadeDao;
import com.artfess.sysConfig.persistence.dao.SysDictionaryDao;
import com.artfess.sysConfig.persistence.dao.SysDictionaryDetailDao;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.model.SysDictionary;
import com.artfess.sysConfig.persistence.model.SysDictionaryCascade;
import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.sysConfig.vo.DictionaryDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.jsonwebtoken.lang.Collections;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SysDictionaryDetailManagerImpl
extends BaseManagerImpl<SysDictionaryDetailDao, SysDictionaryDetail>
implements SysDictionaryDetailManager {
    @Resource
    SysDictionaryDetailDao sysDictionaryDetailDao;
    @Resource
    SysDictionaryCascadeDao sysDictionaryCascadeDao;
    @Resource
    SysDictionaryManager sysDictionaryManager;
    @Resource
    SysDictionaryDao sysDictionaryDao;
    @Resource
    BaseContext baseContext;
    @Resource
    CacheManager cacheManager;
    private static final CacheSetting cacheSetting = CacheSetting.buildDefault((String)"\u5b57\u5178\u7f13\u5b58");

    @Override
    @Transactional
    public void deleteDictionaryDetails(String ids) {
        Assert.hasText((String)ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        List<String> idsList = Arrays.asList(ids.split(","));
        List list = this.sysDictionaryDetailDao.selectBatchIds(idsList);
        if (list != null && list.size() > 0) {
            String dictionaryId = "";
            for (SysDictionaryDetail sysDictionaryDetail : list) {
                dictionaryId = sysDictionaryDetail.getDictionaryId();
                Assert.isTrue((boolean)BaseInfoStatus.isDraft(sysDictionaryDetail.getFlag()), (String)String.format("%s\u72b6\u6001\u4e0d\u4e3a\u201c\u8349\u7a3f\u201d\u72b6\u6001,\u4e0d\u80fd\u5220\u9664\u3002", sysDictionaryDetail.getName()));
                UpdateWrapper wrapper = new UpdateWrapper();
                wrapper.eq((Object)"DETAIL_ID_", (Object)sysDictionaryDetail.getId());
                wrapper.or(wq -> {
                    UpdateWrapper cfr_ignored_0 = (UpdateWrapper)wq.eq((Object)"LOWER_DETAIL_ID_", (Object)sysDictionaryDetail.getId());
                });
                this.sysDictionaryCascadeDao.delete((Wrapper)wrapper);
            }
            this.sysDictionaryDetailDao.deleteBatchIds(idsList);
            SysDictionary dictionaryEntity = (SysDictionary)((Object)this.sysDictionaryDao.selectById((Serializable)((Object)dictionaryId)));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.like((Object)"DICTIONARY_ID_", (Object)dictionaryEntity.getId());
            queryWrapper.eq((Object)"FLAG_", (Object)1);
            List detailEntityList = this.sysDictionaryDetailDao.selectList((Wrapper)queryWrapper);
            String key = "sys:dictionary:new:" + dictionaryEntity.getCode().toUpperCase() + ":";
            if (dictionaryEntity.getKindId() != 1 && StringUtils.isNotEmpty((CharSequence)dictionaryEntity.getTenantId())) {
                key = key + dictionaryEntity.getTenantId().toUpperCase();
            }
            cache.delLike("sys:dict:all:new:");
        }
    }

    @Override
    @Transactional
    public void updateDictionariesDetailsStatus(String ids, Integer status) {
        Assert.hasText((String)ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        List<String> idsList = Arrays.asList(ids.split(","));
        this.sysDictionaryDetailDao.updateDictionariesDetailsStatus(idsList, status);
        String id = idsList.get(0);
        SysDictionaryDetail sysDictionaryDetail = (SysDictionaryDetail)((Object)this.sysDictionaryDetailDao.selectById((Serializable)((Object)id)));
        SysDictionary sysDictionary = (SysDictionary)((Object)this.sysDictionaryDao.selectById((Serializable)((Object)sysDictionaryDetail.getDictionaryId())));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like((Object)"DICTIONARY_ID_", (Object)sysDictionary.getId());
        queryWrapper.eq((Object)"FLAG_", (Object)1);
        List detailEntityList = this.sysDictionaryDetailDao.selectList((Wrapper)queryWrapper);
        String key = "sys:dictionary:new:" + sysDictionary.getCode().toUpperCase() + ":";
        if (sysDictionary.getKindId() != 1 && StringUtils.isNotEmpty((CharSequence)sysDictionary.getTenantId())) {
            key = key + sysDictionary.getTenantId().toUpperCase();
        }
        cache.delLike("sys:dict:all:new:");
    }

    @Override
    @Transactional
    public void updateDictionariesDetailsSequence(HashMap<String, Integer> map) {
        this.updateSequence(map);
    }

    @Override
    public List<DictModel> queryDictModelItemsByCode(String code, String tenantId) {
        return this.sysDictionaryDetailDao.queryDictModelItemsByCode(code, "");
    }

    @Override
    public List<SysDictionaryDetail> queryDictItemsByCode(String code, String tenantId) {
        return this.sysDictionaryDetailDao.queryDictItemsByCode(code, tenantId);
    }

    @Override
    public Integer getNextDetailSequence(Map<String, Object> criteriaMap) {
        return this.getNextSequence(criteriaMap);
    }

    @Override
    public void saveDictDetailLowerDetails(String detailId, String lowerDictId, String lowerDetailIds) {
        Assert.hasText((String)detailId, (String)"\u88ab\u5173\u8054\u7684\u5b57\u5178\u9879ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)lowerDictId, (String)"\u5173\u8054\u7684\u5b57\u5178id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)lowerDetailIds, (String)"\u5173\u8054\u7684\u5b57\u5178\u9879ID\u4e0d\u80fd\u4e3a\u7a7a");
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        List<String> ids = Arrays.asList(lowerDetailIds.split(","));
        if (ids != null && ids.size() > 0) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.eq((Object)"DETAIL_ID_", (Object)detailId)).in((Object)"LOWER_DETAIL_ID_", ids);
            this.sysDictionaryCascadeDao.delete((Wrapper)updateWrapper);
            for (String lowerDetailId : ids) {
                SysDictionaryCascade dictionaryCascade = new SysDictionaryCascade();
                dictionaryCascade.setDetailId(detailId);
                dictionaryCascade.setLowerDicId(lowerDictId);
                dictionaryCascade.setLowerDetailId(lowerDetailId);
                this.sysDictionaryCascadeDao.insert((Object)dictionaryCascade);
            }
            cache.delLike("sys:dict:all:new:");
        }
    }

    @Override
    public void delLowerDetails(String detailId, String lowerDetailIds) {
        Assert.hasText((String)detailId, (String)"\u88ab\u5173\u8054\u7684\u5b57\u5178\u9879ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)lowerDetailIds, (String)"\u5173\u8054\u7684\u5b57\u5178\u9879ID\u4e0d\u80fd\u4e3a\u7a7a");
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        List<String> ids = Arrays.asList(lowerDetailIds.split(","));
        if (ids != null && ids.size() > 0) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.eq((Object)"DETAIL_ID_", (Object)detailId)).in((Object)"LOWER_DETAIL_ID_", ids);
            this.sysDictionaryCascadeDao.delete((Wrapper)updateWrapper);
            cache.delLike("sys:dict:all:new:");
        }
    }

    @Override
    public List<SysDictionaryDetail> querySysDictionaryDetail(SysDictionaryDetail sysDictionaryDetail) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)sysDictionaryDetail.getDictionaryId()), (Object)"DICTIONARY_ID_", (Object)sysDictionaryDetail.getDictionaryId());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)sysDictionaryDetail.getName()), (Object)"NAME_", (Object)sysDictionaryDetail.getName());
        queryWrapper.eq(Objects.nonNull(sysDictionaryDetail.getFlag()), (Object)"FLAG_", (Object)sysDictionaryDetail.getFlag());
        return this.sysDictionaryDetailDao.selectList((Wrapper)queryWrapper);
    }

    @Override
    public String getTextByValue(String code, String val) throws Exception {
        Assert.hasText((String)code, (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)val, (String)"\u5b57\u5178\u9879\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        String tenantId = this.baseContext.getCurrentTenantId();
        Map res = null;
        if (cache.get((Object)("sys:dict:all:new:" + tenantId)) != null) {
            res = JsonUtil.toMap((String)cache.get((Object)("sys:dict:all:new:" + tenantId)).toString());
            List list = (List)res.get(code);
            for (LinkedHashMap vo : list) {
                if (!vo.get("value").toString().trim().equals(val.trim())) continue;
                return vo.get("name").toString();
            }
        } else {
            List<DictModel> dicList = this.sysDictionaryManager.queryDictListItemsByCode(code);
            if (Collections.isEmpty(dicList)) {
                return "";
            }
            for (DictModel ele : dicList) {
                if (!ele.getValue().equals(val)) continue;
                return ele.getName();
            }
        }
        return "";
    }

    @Override
    public Map<String, DictionaryDetailVo> getTextByMap(String code) {
        Assert.hasText((String)code, (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        String tenantId = this.baseContext.getCurrentTenantId();
        Object o = cache.get((Object)("sys:dict:all:new:" + tenantId));
        if (o != null) {
            JSONObject jsonValue = JSON.parseObject((String)o.toString());
            List<DictionaryDetailVo> detailVos = this.convertToList(jsonValue, code);
            return detailVos.stream().collect(Collectors.groupingBy(DictionaryDetailVo::getValue, Collectors.collectingAndThen(Collectors.toList(), list -> (DictionaryDetailVo)list.get(0))));
        }
        return new HashMap<String, DictionaryDetailVo>();
    }

    public List<DictionaryDetailVo> convertToList(JSONObject jsonObject, String key) {
        JSONArray array = jsonObject.getJSONArray(key);
        return array.toJavaList(DictionaryDetailVo.class);
    }
}

