/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.FlowUploadProperties;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/file/flowUploadProperties/v1"})
@Api(tags={"\u6d41\u7a0b\u9644\u4ef6\u5b58\u50a8\u914d\u7f6e"})
@ApiGroup(group={"group_bpm"})
public class FlowUploadPropertiesController
extends BaseController<FlowUploadPropertiesManager, FlowUploadProperties> {
    @Resource
    FlowUploadPropertiesManager flowUploadPropertiesManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u5217\u8868")
    public PageList<FlowUploadProperties> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.flowUploadPropertiesManager.query(queryFilter);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u6570\u636e\u8be6\u60c5")
    public FlowUploadProperties get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (FlowUploadProperties)this.flowUploadPropertiesManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="flowUploadProperties", value="\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody FlowUploadProperties flowUploadProperties) throws Exception {
        String msg = "\u6dfb\u52a0\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u6210\u529f";
        CommonResult<String> validateResult = this.isExist(flowUploadProperties.getId(), flowUploadProperties.getFlowKey(), flowUploadProperties.getFlowName());
        if (!validateResult.getState().booleanValue()) {
            return validateResult;
        }
        if (StringUtil.isEmpty((String)flowUploadProperties.getId())) {
            if (StringUtil.isNotEmpty((String)flowUploadProperties.getFlowKey())) {
                flowUploadProperties.setFlowKey("," + flowUploadProperties.getFlowKey() + ",");
                flowUploadProperties.setFlowName("," + flowUploadProperties.getFlowName() + ",");
            }
            this.flowUploadPropertiesManager.create((Model)flowUploadProperties);
        } else {
            if (StringUtil.isNotEmpty((String)flowUploadProperties.getFlowKey())) {
                if (!flowUploadProperties.getFlowKey().startsWith(",")) {
                    flowUploadProperties.setFlowKey("," + flowUploadProperties.getFlowKey());
                    flowUploadProperties.setFlowName("," + flowUploadProperties.getFlowName());
                }
                if (!flowUploadProperties.getFlowKey().endsWith(",")) {
                    flowUploadProperties.setFlowKey(flowUploadProperties.getFlowKey() + ",");
                    flowUploadProperties.setFlowName(flowUploadProperties.getFlowName() + ",");
                }
            }
            this.flowUploadPropertiesManager.update((Model)flowUploadProperties);
            msg = "\u66f4\u65b0\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    private CommonResult<String> isExist(String id, String flowKeys, String flowNames) {
        if (StringUtil.isNotEmpty((String)flowKeys)) {
            String[] flowKeyArray = flowKeys.split(",");
            String[] flowNameArray = flowNames.split(",");
            boolean exist = false;
            String existFlowNames = "";
            for (int i = 0; i < flowKeyArray.length; ++i) {
                FlowUploadPropertiesStorageDTO properties;
                String flowKey = flowKeyArray[i];
                if (!StringUtil.isNotEmpty((String)flowKey) || !BeanUtils.isNotEmpty((Object)(properties = this.flowUploadPropertiesManager.getByFlowKey(flowKey))) || !StringUtil.isEmpty((String)id) && properties.getId().equals(id)) continue;
                exist = true;
                if (StringUtil.isNotEmpty((String)existFlowNames)) {
                    existFlowNames = existFlowNames + "\uff0c";
                }
                existFlowNames = existFlowNames + flowNameArray[i];
            }
            if (exist) {
                return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff01\u6d41\u7a0b\u3010" + existFlowNames + "\u3011\u5728\u5176\u4ed6\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e\u3002");
            }
        }
        return new CommonResult(true, "");
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u9644\u4ef6\u4e0a\u4f20\u914d\u7f6e\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.flowUploadPropertiesManager.removeByIds(ids);
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getByFlowKey"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bkey\u83b7\u53d6", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0bkey\u83b7\u53d6")
    public CommonResult<FlowUploadPropertiesStorageDTO> getByFlowKey(@ApiParam(name="flowKey", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String flowKey) throws Exception {
        FlowUploadPropertiesStorageDTO properties = this.flowUploadPropertiesManager.getByFlowKey(flowKey);
        if (BeanUtils.isNotEmpty((Object)properties)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)properties);
        }
        return new CommonResult(false, "\u6839\u636e\u6d41\u7a0bkey\u672a\u83b7\u53d6\u5230\u4e0a\u6b21\u914d\u7f6e\uff01");
    }
}

