/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.kafka;

import com.alibaba.fastjson.JSON;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.persistence.manager.BpmCallLogManager;
import com.artfess.bpm.persistence.model.BpmCallLog;
import com.artfess.uc.dto.OrgKafkaDTO;
import com.artfess.uc.dto.UserKafkaDTO;
import com.artfess.uc.dto.UserOrgInfoDTO;
import com.artfess.uc.dto.UserRoleItemDTO;
import com.artfess.uc.dto.UserRoleRelationDTO;
import com.artfess.uc.enums.MsgTypeEnum;
import com.artfess.uc.manager.DemensionManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.PwdStrategyManager;
import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserRoleManager;
import com.artfess.uc.model.Demension;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.Role;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserRole;
import com.artfess.uc.params.org.OrgUserVo;
import com.artfess.uc.params.org.OrgVo;
import com.artfess.uc.params.user.UserVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@ConditionalOnProperty(name={"spring.kafka.enable"}, havingValue="true", matchIfMissing=false)
@Component
public class KafkaConsumer {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumer.class);
    @Resource
    private BpmCallLogManager bpmCallLogManager;
    @Resource
    private DemensionManager demensionManager;
    @Resource
    private OrgManager orgManager;
    @Resource
    private UserManager userManager;
    @Resource
    private RoleManager roleManager;
    @Resource
    private UserRoleManager userRoleManager;
    @Resource
    private PwdStrategyManager pwdStrategyManager;
    @Resource
    private OrgUserManager orgUserService;
    private static final String SYS_CODE = "XCJYN";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(id="orgListenerContainer", topics={"basic-org-info"}, groupId="consumer-xcjy-user", autoStartup="false")
    public void consumeOrg(ConsumerRecord<?, ?> record, Acknowledgment ack, @Header(value="kafka_receivedTopic") String topic) {
        Object msg = this.preHandleKafkaMsg(record, ack, topic);
        if (msg == null) {
            return;
        }
        BpmCallLog callLog = new BpmCallLog();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(msg.toString());
            String msgType = rootNode.path("msgType").asText();
            String puuid = rootNode.path("puuid").asText();
            callLog = this.buildCallLog(record.topic(), msg.toString(), msgType, puuid, "\u7ec4\u7ec7\u540c\u6b65\u6d88\u606f", "kafka\u6d88\u8d39\u7ec4\u7ec7\u540c\u6b65\u6d88\u606f");
            JsonNode dataNode = rootNode.get("data");
            OrgKafkaDTO orgDto = (OrgKafkaDTO)objectMapper.treeToValue((TreeNode)dataNode, OrgKafkaDTO.class);
            OrgVo orgVo = this.buildOrgVo(orgDto);
            MsgTypeEnum typeEnum = MsgTypeEnum.fromCode(msgType);
            if (typeEnum == null) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b: " + msgType);
            }
            switch (typeEnum) {
                case ADD: {
                    this.orgManager.addOrg(orgVo);
                    break;
                }
                case UPDATE: {
                    this.orgManager.updateOrg(orgVo);
                    break;
                }
                case DELETE: {
                    this.orgManager.deleteOrg(orgVo.getCode());
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b: " + msgType);
                }
            }
            callLog.setIsSuccess(Integer.valueOf(1));
        }
        catch (Exception e) {
            callLog.setParams(e.getMessage());
            callLog.setIsSuccess(Integer.valueOf(0));
            log.error("Kafka \u6d88\u8d39\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.bpmCallLogManager.save((Object)callLog);
            ack.acknowledge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(id="userListenerContainer", topics={"basic-user-info"}, groupId="consumer-xcjy-user", autoStartup="false")
    public void consumeUser(ConsumerRecord<?, ?> record, Acknowledgment ack, @Header(value="kafka_receivedTopic") String topic) {
        Object msg = this.preHandleKafkaMsg(record, ack, topic);
        if (msg == null) {
            return;
        }
        BpmCallLog callLog = new BpmCallLog();
        try {
            String jsonStr = JSON.toJSON((Object)msg).toString();
            JsonNode rootNode = new ObjectMapper().readTree(jsonStr);
            String msgType = rootNode.path("msgType").asText();
            callLog = this.buildCallLog(record.topic(), jsonStr, msgType, null, "\u7528\u6237\u540c\u6b65\u6d88\u606f", "kafka\u6d88\u8d39\u7528\u6237\u540c\u6b65\u6d88\u606f");
            JsonNode dataNode = rootNode.get("data");
            ObjectMapper objectMapper = new ObjectMapper();
            UserKafkaDTO userDto = (UserKafkaDTO)objectMapper.treeToValue((TreeNode)dataNode, UserKafkaDTO.class);
            UserVo userVo = this.buildUser(userDto);
            MsgTypeEnum typeEnum = MsgTypeEnum.fromCode(msgType);
            if (typeEnum == null) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b: " + msgType);
            }
            switch (typeEnum) {
                case ADD: {
                    if (userVo.getId() != null) {
                        this.userManager.updateUser(userVo);
                        this.updateUserOrg(userVo, userDto);
                        break;
                    }
                    userVo.setStatus(1);
                    this.userManager.addUser(userVo);
                    this.setAddUserOrg(userVo.getAccount(), userDto);
                    break;
                }
                case UPDATE: {
                    this.userManager.updateUser(userVo);
                    this.updateUserOrg(userVo, userDto);
                    break;
                }
                case DELETE: {
                    User user = this.userManager.getByAccount(userDto.getUserCode());
                    if (!BeanUtils.isNotEmpty((Object)user)) break;
                    this.userManager.deleteUserByIds(user.getId());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b: " + msgType);
                }
            }
            callLog.setIsSuccess(Integer.valueOf(1));
        }
        catch (Exception e) {
            callLog.setParams(e.getMessage());
            callLog.setIsSuccess(Integer.valueOf(0));
            log.error("Kafka \u6d88\u8d39\u7528\u6237\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.bpmCallLogManager.save((Object)callLog);
            ack.acknowledge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(id="roleListenerContainer", topics={"basic-userrole-info"}, groupId="consumer-xcjy-user", autoStartup="false")
    public void consumeRole(ConsumerRecord<?, ?> record, Acknowledgment ack, @Header(value="kafka_receivedTopic") String topic) {
        Object msg = this.preHandleKafkaMsg(record, ack, topic);
        if (msg == null) {
            return;
        }
        BpmCallLog callLog = new BpmCallLog();
        try {
            String jsonStr = JSON.toJSON((Object)msg).toString();
            ObjectMapper objectMapper = new ObjectMapper();
            UserRoleItemDTO dto = (UserRoleItemDTO)objectMapper.readValue(jsonStr, UserRoleItemDTO.class);
            callLog = this.buildCallLog(record.topic(), jsonStr, String.valueOf(dto.getType()), null, "\u89d2\u8272\u540c\u6b65\u6d88\u606f", dto.getDesc());
            ArrayList userRoleRelationDtoList = new ArrayList();
            dto.getValue().forEach(userRoleRelationDto -> {
                if (SYS_CODE.equals(userRoleRelationDto.getModuleCode())) {
                    userRoleRelationDtoList.add(userRoleRelationDto);
                }
            });
            if (CollectionUtils.isEmpty(userRoleRelationDtoList)) {
                callLog.setIsSuccess(Integer.valueOf(1));
                return;
            }
            if (1 == dto.getType()) {
                User user = this.userManager.getByAccount(dto.getKey());
                if (Objects.isNull(user)) {
                    throw new RuntimeException("\u6839\u636e\u624b\u673a\u53f7: " + dto.getKey() + "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
                }
                String[] zsRoleCodes = (String[])userRoleRelationDtoList.stream().map(UserRoleRelationDTO::getRoleCode).toArray(String[]::new);
                String[] roleCodes = Arrays.copyOf(zsRoleCodes, zsRoleCodes.length + 1);
                roleCodes[zsRoleCodes.length] = "ybry";
                this.userRoleManager.saveUserRole(user.getAccount(), roleCodes);
            } else if (2 == dto.getType()) {
                Role role = this.roleManager.getRole(dto.getKey());
                if (Objects.isNull(role)) {
                    throw new RuntimeException("\u6839\u636e\u89d2\u8272Code: " + dto.getKey() + "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff01");
                }
                ArrayList<UserRole> userRoleList = new ArrayList<UserRole>();
                for (UserRoleRelationDTO userRoleRelationDto2 : userRoleRelationDtoList) {
                    User user = this.userManager.getByAccount(userRoleRelationDto2.getPhone());
                    if (Objects.isNull(user)) continue;
                    UserRole userRole = new UserRole();
                    userRole.setRoleId(role.getId());
                    userRole.setUserId(user.getId());
                    userRoleList.add(userRole);
                }
                if (CollectionUtils.isEmpty(userRoleList)) {
                    throw new RuntimeException("\u6784\u5efa\u89d2\u8272\u5173\u8054\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u65e0\u6cd5\u5339\u914d");
                }
                this.userRoleManager.removeByRoleId(role.getId(), LocalDateTime.now());
                this.userRoleManager.saveBatch(userRoleList);
            } else {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b: " + dto.getType());
            }
            callLog.setIsSuccess(Integer.valueOf(1));
        }
        catch (Exception e) {
            callLog.setParams(e.getMessage());
            callLog.setIsSuccess(Integer.valueOf(0));
            log.error("Kafka \u6d88\u8d39\u89d2\u8272\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.bpmCallLogManager.save((Object)callLog);
            ack.acknowledge();
        }
    }

    private Object preHandleKafkaMsg(ConsumerRecord<?, ?> record, Acknowledgment ack, String topic) {
        log.info("Kafka \u76d1\u542c\u4e3b\u9898:{},\u6d88\u8d39\u5185\u5bb9:{}", (Object)record.topic(), record.value());
        Object msg = record.value();
        if (msg == null) {
            log.warn("Kafka \u6d88\u606f\u4e3a\u7a7a\uff0ctopic:{}", (Object)topic);
            ack.acknowledge();
            return null;
        }
        return msg;
    }

    private BpmCallLog buildCallLog(String topic, String msgStr, String msgType, String puuid, String subject, String desc) {
        BpmCallLog callLog = new BpmCallLog();
        callLog.setUrl(topic);
        callLog.setCallTime(LocalDateTime.now());
        callLog.setSubject(subject);
        callLog.setDesc(desc);
        callLog.setResponse(msgStr);
        callLog.setEventType(msgType);
        callLog.setTaskId(puuid);
        return callLog;
    }

    private OrgVo buildOrgVo(OrgKafkaDTO orgDto) {
        Demension defaultDemension = this.demensionManager.getDefaultDemension();
        String demId = defaultDemension.getId();
        OrgVo orgVo = new OrgVo();
        orgVo.setDemId(demId);
        orgVo.setCode(orgDto.getCode());
        orgVo.setName(orgDto.getName());
        orgVo.setOrgKind(orgDto.getType() != null && orgDto.getType() == 1 ? "ogn" : "dept");
        if (orgDto.getSort() != null) {
            orgVo.setOrderNo((long)orgDto.getSort());
        } else {
            orgVo.setOrderNo(999L);
        }
        if (StringUtil.isEmpty((String)orgDto.getParentCode())) {
            orgVo.setParentId("0");
            orgVo.setGrade("1");
        } else {
            orgVo.setParentCode(orgDto.getParentCode());
        }
        return orgVo;
    }

    private UserVo buildUser(UserKafkaDTO dto) throws Exception {
        UserVo user = new UserVo();
        User account = this.userManager.getByAccount(dto.getUserCode());
        user.setAccount(dto.getUserCode());
        user.setFullname(dto.getName());
        if (dto.getUserCode().matches("^1[3-9]\\d{9}$")) {
            user.setMobile(dto.getUserCode());
        }
        if (BeanUtils.isNotEmpty((Object)account)) {
            user.setId(account.getId());
            user.setStatus(account.getStatus());
            user.setUserType(account.getUserType());
            user.setPassword(account.getPassword());
        } else {
            user.setUserType(2);
            String pwd = this.pwdStrategyManager.getDefault().getInitPwd();
            user.setPassword(pwd);
        }
        return user;
    }

    public void setAddUserOrg(String account, UserKafkaDTO userKafkaDto) throws Exception {
        if (CollectionUtils.isNotEmpty(userKafkaDto.getOrgInfoDtos())) {
            for (UserOrgInfoDTO orgInfoDto : userKafkaDto.getOrgInfoDtos()) {
                OrgUserVo orgUserVo = new OrgUserVo();
                orgUserVo.setAccount(account);
                orgUserVo.setOrgCode(orgInfoDto.getOrgCode());
                if (orgInfoDto.getOrgCode().equals(userKafkaDto.getDeptCode())) {
                    orgUserVo.setIsMaster(1);
                } else {
                    orgUserVo.setIsMaster(0);
                }
                this.orgManager.addOrgUser(orgUserVo);
            }
        } else {
            OrgUserVo orgUserVo = new OrgUserVo();
            orgUserVo.setAccount(account);
            orgUserVo.setOrgCode(userKafkaDto.getDeptCode());
            orgUserVo.setIsMaster(1);
            this.orgManager.addOrgUser(orgUserVo);
        }
    }

    public void updateUserOrg(UserVo userVo, UserKafkaDTO userKafkaDto) throws Exception {
        List<Org> existingOrgs = this.orgManager.getOrgsByAccount(userVo.getAccount());
        if (CollectionUtils.isEmpty(existingOrgs)) {
            return;
        }
        Set existingOrgCodes = existingOrgs.stream().map(Org::getCode).collect(Collectors.toSet());
        List<UserOrgInfoDTO> orgInfoList = userKafkaDto.getOrgInfoDtos();
        if (CollectionUtils.isNotEmpty(orgInfoList)) {
            this.deleteUserUnboundOrg(userVo.getId());
            for (UserOrgInfoDTO orgInfoDto : orgInfoList) {
                OrgUserVo orgUserVo = new OrgUserVo();
                orgUserVo.setAccount(userVo.getAccount());
                orgUserVo.setOrgCode(orgInfoDto.getOrgCode());
                orgUserVo.setIsMaster(orgInfoDto.getOrgCode().equals(userKafkaDto.getDeptCode()) ? 1 : 0);
                this.orgManager.addOrgUser(orgUserVo);
            }
        } else if (!existingOrgCodes.contains(userKafkaDto.getDeptCode())) {
            this.deleteUserUnboundOrg(userVo.getId());
            OrgUserVo orgUserVo = new OrgUserVo();
            orgUserVo.setAccount(userVo.getAccount());
            orgUserVo.setOrgCode(userKafkaDto.getDeptCode());
            orgUserVo.setIsMaster(1);
            this.orgManager.addOrgUser(orgUserVo);
        }
    }

    private void deleteUserUnboundOrg(String userId) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"USER_ID_", (Object)userId);
        List list = this.orgUserService.listMaps((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Map map : list) {
                Object relId = map.get("relId");
                if (!ObjectUtils.isEmpty(relId)) continue;
                Object id = map.get("ID_");
                if (ObjectUtils.isEmpty(id)) {
                    id = map.get("id_");
                }
                if (id == null) break;
                this.orgManager.delOrgUser(id.toString());
                break;
            }
        }
    }
}

