/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.video.util;

import com.alibaba.fastjson.JSON;
import com.artfess.rescue.video.dto.CamerasRequest;
import com.artfess.rescue.video.dto.GetCamerasBySpatialIndexWithPageRequest;
import com.artfess.rescue.video.dto.GetTopicInfoRequest;
import com.artfess.rescue.video.dto.PreviewURLsRequest;
import com.artfess.rescue.video.dto.RegionsRequest;
import com.artfess.rescue.video.util.ArtemisHttp;
import com.hikvision.artemis.sdk.config.ArtemisConfig;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HkArtemisRequest {
    @Resource
    private ArtemisHttp artemisHttp;
    @Value(value="${artemis.hk-host}")
    private String host;
    @Value(value="${artemis.hk-app-key}")
    private String appKey;
    @Value(value="${artemis.hk-app-secret}")
    private String appSecret;
    private static final String ARTEMIS_PATH = "/artemis";

    private ArtemisConfig getArtemisConfig() {
        ArtemisConfig config = new ArtemisConfig();
        config.setHost(this.host);
        config.setAppKey(this.appKey);
        config.setAppSecret(this.appSecret);
        return config;
    }

    public String regions(RegionsRequest regionsRequest) throws Exception {
        ArtemisConfig config = this.getArtemisConfig();
        final String regionsDataApi = "/artemis/api/resource/v1/regions";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", regionsDataApi);
            }
        };
        String body = JSON.toJSONString((Object)regionsRequest);
        return this.artemisHttp.doPostStringArtemis(config, (Map<String, String>)path, body, null, null, "application/json");
    }

    public String cameras(CamerasRequest camerasRequest) throws Exception {
        ArtemisConfig config = this.getArtemisConfig();
        final String camerasDataApi = "/artemis/api/resource/v1/regions/regionIndexCode/cameras";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", camerasDataApi);
            }
        };
        String body = JSON.toJSONString((Object)camerasRequest);
        return this.artemisHttp.doPostStringArtemis(config, (Map<String, String>)path, body, null, null, "application/json");
    }

    public String previewURLs(PreviewURLsRequest previewURLsRequest) throws Exception {
        ArtemisConfig config = this.getArtemisConfig();
        final String previewURLsDataApi = "/artemis/api/video/v1/cameras/previewURLs";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", previewURLsDataApi);
            }
        };
        String body = JSON.toJSONString((Object)previewURLsRequest);
        return this.artemisHttp.doPostStringArtemis(config, (Map<String, String>)path, body, null, null, "application/json");
    }

    public String getTopicInfo(GetTopicInfoRequest getTopicInfoRequest) throws Exception {
        ArtemisConfig config = this.getArtemisConfig();
        final String getTopicInfoDataApi = "/artemis/api/common/v1/event/getTopicInfo";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", getTopicInfoDataApi);
            }
        };
        String body = JSON.toJSONString((Object)getTopicInfoRequest);
        return this.artemisHttp.doPostStringArtemis(config, (Map<String, String>)path, body, null, null, "application/json");
    }

    public String getCamerasBySpatialIndexWithPage(GetCamerasBySpatialIndexWithPageRequest getCamerasBySpatialIndexWithPageRequest) throws Exception {
        ArtemisConfig config = this.getArtemisConfig();
        final String getCamerasBySpatialIndexWithPageDataApi = "/artemis/api/resource/v1/camera/getCamerasBySpatialIndexWithPage";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", getCamerasBySpatialIndexWithPageDataApi);
            }
        };
        String body = JSON.toJSONString((Object)getCamerasBySpatialIndexWithPageRequest);
        return this.artemisHttp.doPostStringArtemis(config, (Map<String, String>)path, body, null, null, "application/json");
    }
}

