/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.open.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.rescue.base.manager.BizBaseCarManager;
import com.artfess.rescue.base.manager.BizBaseStationaryManager;
import com.artfess.rescue.base.manager.BizBaseTeamManager;
import com.artfess.rescue.base.manager.BizBaseTeamMemberManager;
import com.artfess.rescue.base.manager.BizBindMemberManager;
import com.artfess.rescue.base.model.BizBaseCar;
import com.artfess.rescue.base.model.BizBaseStationary;
import com.artfess.rescue.base.model.BizBaseTeam;
import com.artfess.rescue.base.model.BizBaseTeamMember;
import com.artfess.rescue.base.model.BizBindMember;
import com.artfess.rescue.common.util.PointUtil;
import com.artfess.rescue.event.enums.EventTypeLwEnum;
import com.artfess.rescue.event.manager.BizEventInfoManager;
import com.artfess.rescue.event.manager.BizRescueInfoManager;
import com.artfess.rescue.event.model.BizEventInfo;
import com.artfess.rescue.event.model.BizRescueInfo;
import com.artfess.rescue.open.dao.OpenCountDao;
import com.artfess.rescue.open.dto.CameraInfoDTO;
import com.artfess.rescue.open.dto.InspectionTaskQueryResultDTO;
import com.artfess.rescue.open.dto.OpenBaseQueryDTO;
import com.artfess.rescue.open.dto.RescueTaskQueryResultDTO;
import com.artfess.rescue.open.dto.SurroundingCameraInfoQueryDTO;
import com.artfess.rescue.open.manager.OpenCountManager;
import com.artfess.rescue.open.vo.AbnormalListVO;
import com.artfess.rescue.open.vo.EventTypeVO;
import com.artfess.rescue.open.vo.PatrolCountVO;
import com.artfess.rescue.open.vo.PatrolInfoVO;
import com.artfess.rescue.open.vo.SurroundingCameraInfoQueryVO;
import com.artfess.rescue.open.vo.TaskCountVO;
import com.artfess.rescue.open.vo.TaskListVO;
import com.artfess.rescue.patrol.manager.BizInspectionVideoManager;
import com.artfess.rescue.patrol.manager.BizInspectionVideoTaskManager;
import com.artfess.rescue.patrol.model.BizInspectionVideo;
import com.artfess.rescue.patrol.model.BizInspectionVideoTask;
import com.artfess.rescue.utils.RoadMarkerProcessor;
import com.artfess.rescue.video.dto.GetCamerasBySpatialIndexWithPageRequest;
import com.artfess.rescue.video.model.BizVideoMonitorPointInfo;
import com.artfess.rescue.video.util.HkArtemisRequest;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class OpenCountManagerImpl
implements OpenCountManager {
    private static final Logger log = LoggerFactory.getLogger(OpenCountManagerImpl.class);
    @Resource
    private OpenCountDao openCountDao;
    @Resource
    private BizBaseStationaryManager baseRescueManager;
    @Resource
    private BizBaseCarManager baseCarManager;
    @Resource
    private BizBaseTeamMemberManager baseTeamMemberManager;
    @Resource
    private BizBindMemberManager bindMemberManager;
    @Resource
    private BizBaseTeamManager bizBaseTeamManager;
    @Resource
    private BizInspectionVideoTaskManager inspectionVideoTaskManager;
    @Resource
    private BizEventInfoManager eventInfoManager;
    @Resource
    private BizRescueInfoManager rescueInfoManager;
    @Resource
    private BizInspectionVideoManager inspectionVideoManager;
    @Resource
    private HkArtemisRequest hkArtemisRequest;
    @Resource
    private PointUtil pointUtil;

    @Override
    public CommonResult<PatrolInfoVO> getPatrolInfo(OpenBaseQueryDTO dto) {
        RescueTaskQueryResultDTO rescueTaskQueryResultDTO;
        PatrolInfoVO vo = new PatrolInfoVO();
        List<BizBaseStationary> baseRescues = this.getBaseRescues(dto);
        vo.setPatrolPoint(this.countRescueOrPatrolPoints(baseRescues, 1));
        vo.setRescuePoint(this.countRescueOrPatrolPoints(baseRescues, 2));
        this.getBaseTeams(dto, vo);
        List<BizBaseCar> baseCars = this.getBaseCars(dto, null);
        vo.setPatrolCar(this.countCars(baseCars, 1));
        vo.setRescueCar(this.countCars(baseCars, 2));
        List<String> userIds = this.openCountDao.queryNowTaskTeam(dto);
        if (CollectionUtils.isNotEmpty(userIds)) {
            Set uniqueUserIds = userIds.stream().filter(Objects::nonNull).flatMap(ids -> {
                String[] parts = ids.split(",");
                return Arrays.stream(parts);
            }).filter(part -> !part.isEmpty()).collect(Collectors.toSet());
            vo.setNowPatrolUser(uniqueUserIds.size());
            vo.setNowPatrolCar(userIds.size());
        }
        if (Objects.nonNull(rescueTaskQueryResultDTO = this.openCountDao.queryNowRescueTask(dto))) {
            vo.setNowRescueUser(rescueTaskQueryResultDTO.getUserNum());
            vo.setNowRescueCar(rescueTaskQueryResultDTO.getCarNum());
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResult<PatrolCountVO> getPatrolCount(OpenBaseQueryDTO dto) {
        LocalDateTime startTime = dto.getStartTime();
        LocalDateTime endTime = dto.getEndTime();
        if (BeanUtils.isEmpty((Object)startTime) || BeanUtils.isEmpty((Object)endTime)) {
            LocalDate now = LocalDate.now();
            dto.setStartTime(LocalDateTime.of(now, LocalTime.MIN));
            dto.setEndTime(LocalDateTime.of(now, LocalTime.MAX));
        }
        PatrolCountVO vo = new PatrolCountVO();
        List<InspectionTaskQueryResultDTO> taskQueryResult = this.openCountDao.queryNowTaskMileage(dto);
        HashSet<String> ids = new HashSet<String>();
        BigDecimal patrolMileage = new BigDecimal(0);
        int abnormalFrequency = 0;
        int disposedFrequency = 0;
        ArrayList<AbnormalListVO> abnormalList = new ArrayList<AbnormalListVO>();
        ArrayList<String> mileageIds = new ArrayList<String>();
        for (InspectionTaskQueryResultDTO inspectionTaskQueryResultDTO : taskQueryResult) {
            Integer abnormalNum;
            ids.add(inspectionTaskQueryResultDTO.getId());
            if (!mileageIds.contains(inspectionTaskQueryResultDTO.getId())) {
                patrolMileage = Optional.ofNullable(inspectionTaskQueryResultDTO.getMileage()).map(patrolMileage::add).orElse(patrolMileage);
                mileageIds.add(inspectionTaskQueryResultDTO.getId());
            }
            if ((abnormalNum = inspectionTaskQueryResultDTO.getAbnormalNum()) == null) continue;
            ++abnormalFrequency;
            Integer disposeNum = inspectionTaskQueryResultDTO.getDisposeNum();
            if (disposeNum != null) {
                ++disposedFrequency;
            }
            AbnormalListVO abnormal = new AbnormalListVO();
            abnormal.setRoadName(inspectionTaskQueryResultDTO.getRoadName());
            abnormal.setStakeMark("K" + inspectionTaskQueryResultDTO.getStakeMark());
            abnormal.setType(inspectionTaskQueryResultDTO.getType());
            abnormal.setTypeContent(inspectionTaskQueryResultDTO.getTypeContent());
            abnormal.setAbnormalTime(inspectionTaskQueryResultDTO.getAbnormalTime());
            abnormal.setInspectInfo(inspectionTaskQueryResultDTO.getInspectInfo());
            abnormalList.add(abnormal);
        }
        vo.setPatrolMileage(patrolMileage);
        vo.setPatrolFrequency(ids.size());
        vo.setAbnormalFrequency(abnormalFrequency);
        vo.setDisposedFrequency(disposedFrequency);
        vo.setAbnormalList(abnormalList);
        LambdaQueryWrapper videoTaskQueryWrapper = new LambdaQueryWrapper();
        videoTaskQueryWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            videoTaskQueryWrapper.in(BizInspectionVideoTask::getRoadId, dto.getRoadIds());
        }
        videoTaskQueryWrapper.in(BizInspectionVideoTask::getTaskStatus, new Object[]{1, 2});
        videoTaskQueryWrapper.between(BizInspectionVideoTask::getInspectDate, (Object)dto.getStartTime(), (Object)dto.getEndTime());
        List list = this.inspectionVideoTaskManager.list((Wrapper)videoTaskQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setVideoPatrolFrequency(list.size());
            LambdaQueryWrapper videoQueryWrapper = new LambdaQueryWrapper();
            videoQueryWrapper.in(BizInspectionVideo::getTaskId, (Collection)list.stream().map(BizInspectionVideoTask::getId).collect(Collectors.toList()));
            videoQueryWrapper.eq(BizDelModel::getIsDele, (Object)"0");
            videoQueryWrapper.eq(BizInspectionVideo::getInspecetStatus, (Object)"1");
            int count = this.inspectionVideoManager.count((Wrapper)videoQueryWrapper);
            vo.setVideoAbnormalFrequency(count);
            vo.setVideoDisposedFrequency(count);
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f \uff01", (Object)vo);
    }

    @Override
    public CommonResult<TaskCountVO> getTaskCount(OpenBaseQueryDTO dto) {
        TaskCountVO vo = new TaskCountVO();
        List<BizEventInfo> eventInfos = this.getEventInfos(dto.getRoadIds(), dto.getStartTime(), dto.getEndTime(), null);
        if (CollectionUtils.isNotEmpty(eventInfos)) {
            vo.setEventTaskFrequency(eventInfos.size());
            int eventComplete = 0;
            int eventDisposal = 0;
            int eventNotDisposal = 0;
            ArrayList<TaskListVO> taskList = new ArrayList<TaskListVO>();
            for (BizEventInfo eventInfo : eventInfos) {
                int status = eventInfo.getEventStatus();
                if (status == 4) {
                    ++eventComplete;
                }
                if (status == 2 || status == 3) {
                    ++eventDisposal;
                }
                if (status == 1 || status == 0 || status == -1) {
                    ++eventNotDisposal;
                }
                taskList.add(new TaskListVO(eventInfo.getId(), eventInfo.getRoadName(), eventInfo.getPegSVal(), eventInfo.getPegEVal(), eventInfo.getEventLevel(), eventInfo.getEventType(), eventInfo.getEventTime(), eventInfo.getLng(), eventInfo.getLat(), EventTypeLwEnum.getResultByValue(eventInfo.getLwEventType()), eventInfo.getMemo(), this.cameraInfos(eventInfo.getLng(), eventInfo.getLat())));
            }
            vo.setEventComplete(eventComplete);
            vo.setEventDisposal(eventDisposal);
            vo.setEventNotDisposal(eventNotDisposal);
            vo.setEventTaskList(taskList);
        }
        LambdaQueryWrapper rescueQueryWrapper = new LambdaQueryWrapper();
        rescueQueryWrapper.eq(BizRescueInfo::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            rescueQueryWrapper.in(BizRescueInfo::getRoadId, dto.getRoadIds());
        }
        rescueQueryWrapper.in(BizRescueInfo::getRescueStatus, new Object[]{2, 3, 4, 5, 6, 7, 8});
        rescueQueryWrapper.between(BizRescueInfo::getRescueTime, (Object)dto.getStartTime(), (Object)dto.getEndTime());
        List rescueInfos = this.rescueInfoManager.list((Wrapper)rescueQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)rescueInfos)) {
            vo.setRescueTaskFrequency(rescueInfos.size());
            vo.setRescueComplete((int)rescueInfos.stream().filter(e -> e.getRescueStatus() == 5).count());
            vo.setRescueEmpty((int)rescueInfos.stream().filter(e -> e.getRescueStatus() == 6).count());
            vo.setRescueAbort((int)rescueInfos.stream().filter(e -> e.getRescueStatus() == 3).count());
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResult<List<EventTypeVO>> getTaskTypeCount(OpenBaseQueryDTO dto) {
        List<Object> vos = new ArrayList();
        Map<String, Integer> eventTypeMap = OpenCountManagerImpl.getEventTypeMap();
        LocalDateTime startTime = dto.getMonth().atStartOfDay();
        LocalDateTime endTime = dto.getMonth().with(TemporalAdjusters.lastDayOfMonth()).atTime(LocalTime.MAX);
        List<BizEventInfo> eventInfos = this.getEventInfos(dto.getRoadIds(), startTime, endTime, null);
        if (CollectionUtils.isNotEmpty(eventInfos)) {
            for (BizEventInfo eventInfo : eventInfos) {
                eventTypeMap.merge(eventInfo.getEventType(), 1, Integer::sum);
            }
            vos = eventTypeMap.entrySet().stream().map(entry -> new EventTypeVO((String)entry.getKey(), (Integer)entry.getValue())).collect(Collectors.toList());
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", vos);
    }

    @Override
    public List<BizBaseCar> getBaseCars(OpenBaseQueryDTO dto, Integer useType) {
        LambdaQueryWrapper carQueryWrapper = new LambdaQueryWrapper();
        carQueryWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            carQueryWrapper.in(BizBaseCar::getRoadId, dto.getRoadIds());
        }
        if (useType != null) {
            carQueryWrapper.eq(BizBaseCar::getUseType, (Object)useType);
        }
        return this.baseCarManager.list((Wrapper)carQueryWrapper);
    }

    @Override
    public List<BizBaseTeam> getBaseTeams(OpenBaseQueryDTO dto) {
        LambdaQueryWrapper teamQueryWrapper = new LambdaQueryWrapper();
        teamQueryWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            teamQueryWrapper.in(BizBaseTeam::getRoadId, dto.getRoadIds());
        }
        return this.bizBaseTeamManager.list((Wrapper)teamQueryWrapper);
    }

    @Override
    public List<BizEventInfo> getEventInfos(List<String> roadIds, LocalDateTime startTime, LocalDateTime endTime, List<Integer> statusList) {
        LambdaQueryWrapper eventQueryWrapper = new LambdaQueryWrapper();
        eventQueryWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(roadIds)) {
            eventQueryWrapper.in(BizEventInfo::getRoadId, roadIds);
        }
        eventQueryWrapper.in(CollectionUtils.isNotEmpty(statusList), BizEventInfo::getEventStatus, statusList);
        eventQueryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.or(subWrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)subWrapper.between(BizEventInfo::getEventTime, (Object)startTime, (Object)endTime);
            })).or(subWrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)subWrapper.lt(BizEventInfo::getEventTime, (Object)startTime)).ne(BizEventInfo::getEventStatus, (Object)4);
            });
        });
        return this.eventInfoManager.list((Wrapper)eventQueryWrapper);
    }

    @Override
    public List<CameraInfoDTO> cameraInfos(String lng, String lat) {
        ArrayList<CameraInfoDTO> list = new ArrayList<CameraInfoDTO>();
        if (StringUtil.isEmpty((String)lng) || StringUtil.isEmpty((String)lat)) {
            return list;
        }
        GetCamerasBySpatialIndexWithPageRequest request = GetCamerasBySpatialIndexWithPageRequest.builder().pageNo(1).pageSize(20).geometryType("Circle").treeCode("0").longitude(lng).latitude(lat).distance(1000).build();
        try {
            JSONObject data;
            JSONArray jsonArray;
            String cameraJsonString = this.hkArtemisRequest.getCamerasBySpatialIndexWithPage(request);
            JSONObject jsonResult = JSONObject.parseObject((String)cameraJsonString);
            if ("0".equals(jsonResult.getString("code")) && CollectionUtils.isNotEmpty((Collection)(jsonArray = (data = jsonResult.getJSONObject("data")).getJSONArray("list")))) {
                List bizVideoAreaInfos = jsonArray.toJavaList(BizVideoMonitorPointInfo.class);
                bizVideoAreaInfos.forEach(info -> {
                    CameraInfoDTO dto = new CameraInfoDTO();
                    dto.setId(info.getCameraIndexCode());
                    dto.setName(info.getName());
                    dto.setCameraType(info.getCameraTypeName());
                    dto.setStatus(info.getStatus());
                    list.add(dto);
                });
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u7ecf\u7eac\u5ea6\u83b7\u53d6\u5468\u8fb9\u6444\u50cf\u5934\u4fe1\u606f\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            return list;
        }
        return list;
    }

    @Override
    public List<CameraInfoDTO> querySurroundingCameraInfo(SurroundingCameraInfoQueryVO vo) {
        Assert.notNull((Object)vo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String region = vo.getRegion();
        String sectionId = vo.getSectionId();
        String sectionName = vo.getSectionName();
        Integer areaType = vo.getAreaType();
        String areaName = vo.getAreaName();
        Integer scope = vo.getScope();
        String pegSVal = vo.getPegSVal();
        String pegEVal = vo.getPegEVal();
        String cameraType = vo.getCameraType();
        Assert.hasText((String)sectionId, (String)"\u8def\u6bb5ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)region, (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)areaType, (String)"\u533a\u57df\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (scope <= 0) {
            throw new BaseException("\u67e5\u8be2\u8303\u56f4\u5fc5\u987b\u5927\u4e8e0");
        }
        List<Map<String, Object>> queryCameraInfoBySectionId = this.openCountDao.queryCameraInfoBySectionId(sectionId);
        if (queryCameraInfoBySectionId == null || queryCameraInfoBySectionId.isEmpty()) {
            throw new BaseException("\u6839\u636e\u4f20\u5165\u7684\u8def\u6bb5id[" + sectionId + "],\u672a\u627e\u5230\u76f8\u5173\u8def\u6bb5");
        }
        SurroundingCameraInfoQueryDTO dto = new SurroundingCameraInfoQueryDTO();
        ArrayList<String> numList = new ArrayList<String>();
        if (areaType == 1) {
            if (StringUtil.isEmpty((String)pegSVal) && StringUtil.isEmpty((String)pegEVal)) {
                throw new BaseException("\u533a\u57df\u7c7b\u578b\u4e3a\u6869\u53f7\u65f6\uff0c\u5f00\u59cb\u7ed3\u675f\u6869\u53f7\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.computeStationNumber(numList, scope, pegSVal, pegEVal);
        } else {
            Assert.hasText((String)areaName, (String)"\u533a\u57df\u7c7b\u578b\u4e3a\u7ed3\u6784\u7269\u65f6\uff0c\u7ed3\u6784\u7269\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            this.computeStationNumber(numList, scope, pegSVal, pegEVal);
            numList.add(areaName);
        }
        System.out.println("****************************************************");
        System.out.println(numList);
        if (null != numList && numList.size() > 0) {
            LinkedHashSet<String> hashSet = new LinkedHashSet<String>(numList);
            numList = new ArrayList<String>(hashSet);
        }
        System.out.println(numList);
        dto.setSectionId(sectionId);
        dto.setSectionName(sectionName);
        dto.setCameraType(cameraType);
        dto.setList(numList);
        List<CameraInfoDTO> cameraInfoDTOList = this.openCountDao.querySurroundingCameraInfo(dto);
        cameraInfoDTOList.sort(RoadMarkerProcessor.createSafeMarkerComparator(CameraInfoDTO::getName, true));
        return cameraInfoDTOList;
    }

    private void computeStationNumber(List<String> numList, Integer scope, String pegSVal, String pegEVal) {
        String pegSValUpperCase;
        String prefix = "K";
        String connector = "+";
        if (StringUtil.isNotEmpty((String)pegSVal) && StringUtil.isNotEmpty((String)pegEVal)) {
            pegSValUpperCase = pegSVal.toUpperCase();
            Matcher matcher = Pattern.compile("^([A-Z]+)").matcher(pegSValUpperCase);
            if (matcher.find()) {
                prefix = matcher.group(1);
            }
            String replacePart = pegSValUpperCase.replace(prefix, "");
            String numberPart = replacePart.split("\\+")[0];
            if (pegSValUpperCase.contains(".")) {
                numberPart = replacePart.split("\\.")[0];
            }
            int snumber = Integer.parseInt(numberPart);
            String pegEValUpperCase = pegEVal.toUpperCase();
            String numberEnd = pegEValUpperCase.substring(1).split("\\+")[0];
            int enumber = Integer.parseInt(numberEnd);
            this.computeRangeStationNumber(numList, scope, this.compare(snumber, enumber, -1), prefix, connector, -1);
            this.computeRangeStationNumber(numList, scope, snumber, enumber, prefix, connector, 1);
            this.computeRangeStationNumber(numList, scope, this.compare(snumber, enumber, 1), prefix, connector, 1);
        }
        if (StringUtil.isNotEmpty((String)pegSVal) && StringUtil.isEmpty((String)pegEVal)) {
            pegSValUpperCase = pegSVal.toUpperCase();
            String numberPart = pegSValUpperCase.substring(1).split("\\+")[0];
            int snumber = Integer.parseInt(numberPart);
            this.computeRangeStationNumber(numList, scope, snumber, prefix, connector, -1);
            this.computeRangeStationNumber(numList, scope, snumber, prefix, connector, 1);
        }
        if (StringUtil.isEmpty((String)pegSVal) && StringUtil.isNotEmpty((String)pegEVal)) {
            String pegEValUpperCase = pegEVal.toUpperCase();
            String numberEnd = pegEValUpperCase.substring(1).split("\\+")[0];
            int enumber = Integer.parseInt(numberEnd);
            this.computeRangeStationNumber(numList, scope, enumber, prefix, connector, -1);
            this.computeRangeStationNumber(numList, scope, enumber, prefix, connector, 1);
        }
    }

    private void computeRangeStationNumber(List<String> numList, Integer scope, int num, String prefix, String connector, int option) {
        int i;
        int j;
        if (-1 == option) {
            j = num - scope;
            for (i = num - 1; i >= j && i >= 0; --i) {
                numList.add(prefix + i + connector);
            }
        }
        if (1 == option) {
            j = num + scope;
            for (i = num + 1; i <= j; ++i) {
                numList.add(prefix + i + connector);
            }
        }
        numList.add(prefix + num + connector);
    }

    private void computeRangeStationNumber(List<String> numList, Integer scope, int num1, int num2, String prefix, String connector, int option) {
        int start = Math.min(num1, num2);
        int end = Math.max(num1, num2);
        System.out.println("\n\u533a\u95f4\u8303\u56f4: " + start + " \u5230 " + end);
        for (int i = start + 1; i < end; ++i) {
            numList.add(prefix + i + connector);
        }
        numList.add(prefix + start + connector);
        numList.add(prefix + end + connector);
    }

    private int compare(int num1, int num2, int result) {
        if (result == -1) {
            return Math.min(num1, num2);
        }
        return Math.max(num1, num2);
    }

    private List<BizBaseStationary> getBaseRescues(OpenBaseQueryDTO dto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizDelModel::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            wrapper.in(BizBaseStationary::getRoadId, dto.getRoadIds());
        }
        return this.baseRescueManager.list((Wrapper)wrapper);
    }

    private int countRescueOrPatrolPoints(List<BizBaseStationary> baseRescues, int type) {
        return CollectionUtils.isEmpty(baseRescues) ? 0 : (int)baseRescues.stream().filter(e -> e.getType() == type).count();
    }

    private void getBaseTeams(OpenBaseQueryDTO dto, PatrolInfoVO vo) {
        List<BizBaseTeam> baseTeams = this.getBaseTeams(dto);
        if (CollectionUtils.isEmpty(baseTeams)) {
            return;
        }
        LambdaQueryWrapper bindMemberWrapper = new LambdaQueryWrapper();
        List teamIds = baseTeams.stream().map(BizBaseTeam::getId).collect(Collectors.toList());
        bindMemberWrapper.in(BizBindMember::getTeamId, teamIds);
        List bindMembers = this.bindMemberManager.list((Wrapper)bindMemberWrapper);
        LambdaQueryWrapper teamMemberWrapper = new LambdaQueryWrapper();
        List memberIds = bindMembers.stream().map(BizBindMember::getMemberId).collect(Collectors.toList());
        teamMemberWrapper.in(BizBaseTeamMember::getId, memberIds);
        List teamMembers = this.baseTeamMemberManager.list((Wrapper)teamMemberWrapper);
        vo.setPatrolUser(teamMembers == null ? 0 : (int)teamMembers.stream().filter(e -> "1".equals(e.getType())).count());
        vo.setRescueUser(teamMembers == null ? 0 : (int)teamMembers.stream().filter(e -> "2".equals(e.getType())).count());
    }

    private int countCars(List<BizBaseCar> baseCars, int useType) {
        return CollectionUtils.isEmpty(baseCars) ? 0 : (int)baseCars.stream().filter(e -> e.getUseType() == useType).count();
    }

    private static Map<String, Integer> getEventTypeMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", 0);
        map.put("2", 0);
        map.put("3", 0);
        map.put("4", 0);
        map.put("5", 0);
        map.put("6", 0);
        map.put("7", 0);
        map.put("8", 0);
        return map;
    }
}

