/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.monitor.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.rescue.base.manager.BizOrgReflectionManager;
import com.artfess.rescue.base.model.BizOrgReflection;
import com.artfess.rescue.monitor.dao.BizEarlyWarningCallManagementDao;
import com.artfess.rescue.monitor.manager.BizEarlyWarningCallManagementManager;
import com.artfess.rescue.monitor.manager.BizEarlyWarningManagementManager;
import com.artfess.rescue.monitor.model.BizEarlyWarningCallManagement;
import com.artfess.rescue.monitor.model.BizEarlyWarningManagement;
import com.artfess.rescue.monitor.vo.CallBaseVO;
import com.artfess.rescue.monitor.vo.EarlyCallWarningExportVo;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.vo.DictionaryDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Service;

@Service
public class BizEarlyWarningCallManagementManagerImpl
extends BaseManagerImpl<BizEarlyWarningCallManagementDao, BizEarlyWarningCallManagement>
implements BizEarlyWarningCallManagementManager {
    @Resource
    BizEarlyWarningManagementManager managementManager;
    @Resource
    SysDictionaryDetailManager sysDictionaryDetailManager;
    @Resource
    BizOrgReflectionManager orgReflectionManager;

    @Override
    public PageList<BizEarlyWarningCallManagement> intoBase(QueryFilter<BizEarlyWarningManagement> queryFilter) {
        queryFilter.addFilter("WARNING_VALUE_", (Object)"07", QueryOP.EQUAL);
        PageList earlyPage = this.managementManager.query(queryFilter);
        PageList callPage = new PageList();
        ArrayList<BizEarlyWarningCallManagement> callManagementList = new ArrayList<BizEarlyWarningCallManagement>();
        List rows = earlyPage.getRows();
        if (rows == null || rows.isEmpty()) {
            return callPage;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        List orgReflections = this.orgReflectionManager.list((Wrapper)wrapper);
        Map<String, List<BizOrgReflection>> listMap = orgReflections.stream().filter(o -> o.getRoadId() != null).collect(Collectors.groupingBy(BizOrgReflection::getRoadId));
        for (BizEarlyWarningManagement e : rows) {
            String group;
            Pattern pattern;
            Matcher matcher;
            List<BizOrgReflection> reflectionList;
            BizEarlyWarningCallManagement call = new BizEarlyWarningCallManagement();
            call.setPubStatus(0);
            call.setEarlyId(e.getId());
            call.setRoadId(e.getRoadId());
            call.setRoadName(e.getRoadName());
            call.setRoadCode(e.getRoadCode());
            call.setWarningTime(e.getWarningTime());
            call.setWarningLevel(e.getWarningLevel());
            call.setWarningChannel(e.getPublishDeviceName());
            call.setWarningContent(e.getWarningContent());
            call.setPegEVal(e.getPegEVal());
            call.setPegSVal(e.getPegSVal());
            call.setLng(e.getLng());
            call.setLat(e.getLat());
            call.setWarningType(e.getWarningType());
            call.setWarningValue(e.getWarningValue());
            call.setRegionalCode(e.getRegionalCode());
            call.setRegionalName(e.getRegionalName());
            if (listMap != null && (reflectionList = listMap.get(e.getRoadId())) != null && !reflectionList.isEmpty()) {
                call.setProvince(reflectionList.get(0).getProvince());
            }
            if ((matcher = (pattern = Pattern.compile("^(.*?\u6c14\u8c61\u53f0)")).matcher(e.getWarningContent())).find() && StringUtils.isNotEmpty((CharSequence)(group = matcher.group(1)))) {
                call.setWarningUnit(group);
                call.setWarnRange(group.replace("\u6c14\u8c61\u53f0", ""));
            }
            callManagementList.add(call);
        }
        callPage.setPage(earlyPage.getPage());
        callPage.setPageSize(earlyPage.getPageSize());
        callPage.setTotal(earlyPage.getTotal());
        callPage.setRows(callManagementList);
        return callPage;
    }

    @Override
    public void export(HttpServletResponse response, QueryFilter<BizEarlyWarningCallManagement> queryFilter) throws Exception {
        PageList query = this.query(queryFilter);
        List rows = query.getRows();
        if (Objects.isNull(rows)) {
            throw new RuntimeException("\u65e0\u6570\u636e\u5bfc\u51fa");
        }
        ArrayList<EarlyCallWarningExportVo> voList = new ArrayList<EarlyCallWarningExportVo>();
        int num = 1;
        Map yjdj = this.sysDictionaryDetailManager.getTextByMap("yxjc-yjdj");
        Map yjlx = this.sysDictionaryDetailManager.getTextByMap("yjlxdm");
        for (BizEarlyWarningCallManagement e : rows) {
            DictionaryDetailVo detailVo;
            EarlyCallWarningExportVo exportVo = new EarlyCallWarningExportVo();
            if (yjdj != null && e.getWarningLevel() != null && yjdj.get(e.getWarningLevel().toString()) != null) {
                detailVo = (DictionaryDetailVo)yjdj.get(e.getWarningLevel().toString());
                exportVo.setWarningLevel(detailVo.getName());
            }
            if (yjlx != null && e.getWarningValue() != null && yjlx.get(e.getWarningValue().toString()) != null) {
                detailVo = (DictionaryDetailVo)yjlx.get(e.getWarningValue().toString());
                exportVo.setWarningValue(detailVo.getName());
            }
            if (e.getWarningTime() != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String formattedDate = e.getWarningTime().format(formatter);
                exportVo.setWarningTime(formattedDate);
            }
            exportVo.setNo(num);
            exportVo.setProvince(e.getProvince());
            exportVo.setRoadName(e.getRoadName());
            exportVo.setWarningChannel(e.getWarningChannel());
            exportVo.setWarningName(e.getWarningName());
            exportVo.setWarningUnit(e.getWarningUnit());
            exportVo.setWarnRange(e.getWarnRange());
            exportVo.setResponseMechanism(e.getResponseMechanism() != null && e.getResponseMechanism().equals("1") ? "\u662f" : "\u5426");
            exportVo.setControlThreshold(e.getControlThreshold());
            exportVo.setWaterContent(e.getWaterContent());
            exportVo.setTakeAction(e.getTakeAction());
            exportVo.setControlSituation(e.getControlSituation());
            exportVo.setPublishSituation(e.getPublishSituation());
            exportVo.setPeopleSituation(e.getPeopleSituation());
            exportVo.setCarSituation(e.getCarSituation());
            exportVo.setInspectMileage(e.getInspectMileage());
            exportVo.setPresetsTeamSituation(e.getPresetsTeamSituation());
            exportVo.setPresetsPeopleSituation(e.getPresetsPeopleSituation());
            exportVo.setPresetsCarSituation(e.getPresetsCarSituation());
            exportVo.setPresetsGoodsSituation(e.getPresetsGoodsSituation());
            ++num;
            voList.add(exportVo);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("list", voList);
        TemplateExportParams params = new TemplateExportParams("model/callWarnExport.xlsx", new Integer[0]);
        String fileName = "\u9884\u8b66\u53eb\u5e94\u4fe1\u606f\u5bfc\u51fa.xlsx";
        this.exportExcelWorkbook(fileName, params, map, response);
    }

    @Override
    public CallBaseVO getCallBase(String roadId) {
        return ((BizEarlyWarningCallManagementDao)this.baseMapper).getCallBase(roadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcelWorkbook(String fileName, TemplateExportParams params, Map<String, Object> map, HttpServletResponse response) {
        OutputStream os = null;
        try {
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
            String encodedFileName = URLEncoder.encode(fileName, "utf-8");
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "attachment; filename=" + encodedFileName);
            response.addHeader("fileName", encodedFileName);
            os = response.getOutputStream();
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25\uff01");
                }
            }
        }
    }
}

