/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.rescue.patrol.dao.BizInspectionVideoTaskDao;
import com.artfess.rescue.patrol.manager.BizInspectionVideoManager;
import com.artfess.rescue.patrol.manager.BizInspectionVideoTaskManager;
import com.artfess.rescue.patrol.model.BizInspectionVideo;
import com.artfess.rescue.patrol.model.BizInspectionVideoTask;
import com.artfess.rescue.patrol.vo.VideoMonitorPointInfoVO;
import com.artfess.rescue.video.manager.BizVideoMonitorPointInfoManager;
import com.artfess.rescue.video.model.BizVideoMonitorPointInfo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizInspectionVideoTaskManagerImpl
extends BaseManagerImpl<BizInspectionVideoTaskDao, BizInspectionVideoTask>
implements BizInspectionVideoTaskManager {
    @Resource
    private BizInspectionVideoManager inspectionVideoManager;
    @Resource
    private BizVideoMonitorPointInfoManager videoMonitorPointInfoManager;

    @Override
    @Transactional(readOnly=true)
    public BizInspectionVideoTask getInfoById(String id) {
        BizInspectionVideoTask bizInspectionVideoTask = (BizInspectionVideoTask)((Object)super.getById((Serializable)((Object)id)));
        List<BizInspectionVideo> videoTaskResultList = this.inspectionVideoManager.getVideoTaskStatus(id);
        if (CollectionUtils.isNotEmpty(videoTaskResultList)) {
            Optional<BizInspectionVideo> maxRankTask = videoTaskResultList.stream().filter(task -> task.getTaskStatus() == 1).max(Comparator.comparingInt(BizInspectionVideo::getRank));
            bizInspectionVideoTask.setRank(maxRankTask.map(BizInspectionVideo::getRank).orElse(0));
            List<String> videoIds = videoTaskResultList.stream().map(BizInspectionVideo::getVideoId).collect(Collectors.toList());
            List<BizVideoMonitorPointInfo> taskVideos = this.videoMonitorPointInfoManager.getMonitorPointInfosByIds(videoIds);
            Map videoMap = taskVideos.stream().collect(Collectors.toMap(BizVideoMonitorPointInfo::getId, Function.identity()));
            List<VideoMonitorPointInfoVO> vos = videoTaskResultList.stream().map(taskVideo -> {
                BizVideoMonitorPointInfo videoMonitorPointInfo = (BizVideoMonitorPointInfo)((Object)((Object)videoMap.get(taskVideo.getVideoId())));
                if (!Objects.isNull((Object)videoMonitorPointInfo)) {
                    VideoMonitorPointInfoVO vo = new VideoMonitorPointInfoVO();
                    vo.setId(taskVideo.getId());
                    vo.setCameraIndexCode(videoMonitorPointInfo.getCameraIndexCode());
                    vo.setName(videoMonitorPointInfo.getName());
                    vo.setTransType(videoMonitorPointInfo.getTransType());
                    vo.setStatus(videoMonitorPointInfo.getStatus());
                    vo.setRank(taskVideo.getRank());
                    vo.setTaskStatus(taskVideo.getTaskStatus());
                    vo.setInspecetStatus(videoMonitorPointInfo.getStatus());
                    return vo;
                }
                return null;
            }).filter(Objects::nonNull).sorted(Comparator.comparing(VideoMonitorPointInfoVO::getRank)).collect(Collectors.toList());
            bizInspectionVideoTask.setTaskVideo(vos);
        }
        return bizInspectionVideoTask;
    }
}

