/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.controller;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.rescue.event.dto.FullEventDto;
import com.artfess.rescue.event.manager.BizEventInfoManager;
import com.artfess.rescue.event.model.BizEventInfo;
import com.artfess.rescue.event.vo.CountEventByTimeVO;
import com.artfess.rescue.event.vo.CountEventByTypeVO;
import com.artfess.rescue.event.vo.EventInfoVO;
import com.artfess.rescue.event.vo.EventLedgerVO;
import com.artfess.rescue.event.vo.TrafficControlIlboVO;
import com.artfess.rescue.monitor.aop.WebSocketNotify;
import com.artfess.rescue.monitor.eunms.RefreshType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/event/bizEventInfo/v1/"})
@Api(tags={"\u4e8b\u4ef6\u4fe1\u606f"})
@ApiGroup(group={"group_biz_rescue"})
public class BizEventInfoController
extends BaseController<BizEventInfoManager, BizEventInfo> {
    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    @WebSocketNotify(topic=RefreshType.SSSJ, operateType="ADD")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizEventInfo t) {
        boolean res = ((BizEventInfoManager)this.baseService).saveInfo(t);
        return new CommonResult(res ? "\u6dfb\u52a0\u6210\u529f" : "\u6dfb\u52a0\u5931\u8d25");
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    @WebSocketNotify(topic=RefreshType.SSSJ, operateType="DELETE")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((BizEventInfoManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    @WebSocketNotify(topic=RefreshType.DLYXJC, operateType="UPDATE")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={UpdateGroup.class}) @RequestBody BizEventInfo t) {
        boolean res = ((BizEventInfoManager)this.baseService).updateInfo(t);
        if (!res) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult("\u66f4\u65b0\u5b9e\u4f53\u6210\u529f");
    }

    @RequestMapping(value={"appoint"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e8b\u4ef6\u59d4\u6d3e", httpMethod="POST", notes="\u4e8b\u4ef6\u59d4\u6d3e")
    @WebSocketNotify(topic=RefreshType.SSSJ, operateType="ADD")
    public CommonResult<String> appoint(@RequestBody FullEventDto entity) {
        boolean res;
        return new CommonResult(res, (res = ((BizEventInfoManager)this.baseService).appoint(entity)) ? "\u59d4\u6d3e\u6210\u529f" : "\u59d4\u6d3e\u5931\u8d25");
    }

    @RequestMapping(value={"cancel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e8b\u4ef6\u64a4\u9500", httpMethod="POST", notes="\u4e8b\u4ef6\u64a4\u9500")
    public CommonResult<String> cancel(@RequestParam(value="id") String id) {
        boolean res;
        return new CommonResult(res, (res = ((BizEventInfoManager)this.baseService).cancel(id)) ? "\u64a4\u9500\u6210\u529f" : "\u64a4\u9500\u5931\u8d25");
    }

    @RequestMapping(value={"end"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e8b\u4ef6\u5b8c\u7ed3", httpMethod="POST", notes="\u4e8b\u4ef6\u5b8c\u7ed3")
    public CommonResult<String> cancel(@RequestBody BizEventInfo t) {
        boolean res;
        return new CommonResult(res, (res = ((BizEventInfoManager)this.baseService).end(t)) ? "\u5b8c\u7ed3\u6210\u529f" : "\u5b8c\u7ed3\u5931\u8d25");
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53-\u7528\u4e8eapp\u7aef")
    public EventInfoVO getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizEventInfoManager)this.baseService).getInfoById(id);
    }

    @GetMapping(value={"/full/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53-\u7528\u4e8epc\u7aef")
    public EventInfoVO getFullById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizEventInfoManager)this.baseService).getFullInfoById(id);
    }

    @RequestMapping(value={"query"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2")
    public PageList<BizEventInfo> query(@RequestBody QueryFilter<BizEventInfo> queryFilter) {
        return ((BizEventInfoManager)this.baseService).queryByIPage(queryFilter);
    }

    @RequestMapping(value={"queryByPower"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e26\u6743\u9650\u5206\u9875\u67e5\u8be2", httpMethod="POST", notes="\u5e26\u6743\u9650\u5206\u9875\u67e5\u8be2")
    public PageList<BizEventInfo> queryByPower(@RequestBody QueryFilter<BizEventInfo> queryFilter) {
        return ((BizEventInfoManager)this.baseService).queryByPower(queryFilter);
    }

    @PostMapping(value={"/ledger/export"})
    @ApiOperation(value="\u53f0\u8d26\u5bfc\u51fa", httpMethod="POST", notes="\u53f0\u8d26\u5bfc\u51fa")
    public ResponseEntity<?> exportToBrowser(@RequestBody QueryFilter<BizEventInfo> queryFilter) {
        return ((BizEventInfoManager)this.baseService).exportLedger(queryFilter);
    }

    @PostMapping(value={"/ledger"})
    @ApiOperation(value="\u53f0\u8d26\u8be6\u60c5", httpMethod="POST", notes="\u53f0\u8d26\u8be6\u60c5")
    public EventLedgerVO getEventTaskLedger(@RequestBody QueryFilter<BizEventInfo> queryFilter) {
        return ((BizEventInfoManager)this.baseService).getEventTaskLedger(queryFilter);
    }

    @PostMapping(value={"/ledger/excelExport"})
    @ApiOperation(value="\u53f0\u8d26\u8be6\u60c5", httpMethod="POST", notes="\u53f0\u8d26\u8be6\u60c5\u5bfc\u51fa")
    public void getEventTaskLedger(HttpServletResponse response, @RequestBody QueryFilter<BizEventInfo> queryFilter) {
        ((BizEventInfoManager)this.baseService).EventLedgerExport(response, queryFilter);
    }

    @RequestMapping(value={"/count/type"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e8b\u4ef6\u7edf\u8ba1-\u90e8\u95e8\u4e8b\u4ef6\u7edf\u8ba1\u5206\u7c7b\u8868", httpMethod="POST", notes="\u90e8\u95e8\u4e8b\u4ef6\u7edf\u8ba1\u5206\u7c7b\u8868")
    public CommonResult<JSONObject> countEventByType(@RequestBody QueryFilter<BizEventInfo> queryFilter) {
        return ((BizEventInfoManager)this.baseService).countEventByType(queryFilter);
    }

    @PostMapping(value={"/export/type"})
    @ApiOperation(value="excel\u5bfc\u51fa-\u90e8\u95e8\u4e8b\u4ef6\u7edf\u8ba1\u5206\u7c7b\u8868", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1")
    public void exportByContent(HttpServletResponse response, @RequestBody QueryFilter<BizEventInfo> queryFilter) throws Exception {
        CommonResult<JSONObject> result = ((BizEventInfoManager)this.baseService).countEventByType(queryFilter);
        JSONObject object = (JSONObject)result.getValue();
        List voList = (List)object.get((Object)"data");
        ArrayList<Map> list = new ArrayList<Map>();
        if (voList != null && voList.size() > 0) {
            int i = 1;
            for (CountEventByTypeVO vo : voList) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                map.put("sn", i);
                ++i;
                list.add(map);
            }
        }
        String tempName = "\u8def\u6bb5\u4e8b\u4ef6\u7edf\u8ba1\u5206\u7c7b\u8868";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("sn", "\u5e8f\u53f7");
        exportMaps.put("roadName", "\u8def\u6bb5\u540d\u79f0");
        exportMaps.put("roadAssetLoss", "\u8def\u4ea7\u635f\u5931(\u5143)");
        exportMaps.put("accidentDisaster", "\u4e8b\u6545\u707e\u96be(\u4ef6)");
        exportMaps.put("constructEvent", "\u517b\u62a4\u65bd\u5de5(\u4ef6)");
        exportMaps.put("geologicalDisaster", "\u5730\u8d28\u707e\u5bb3(\u4ef6)");
        exportMaps.put("meteorologicalDisaster", "\u6c14\u8c61\u707e\u5bb3(\u4ef6)");
        exportMaps.put("socialSecurityEvent", "\u793e\u4f1a\u5b89\u5168\u4e8b\u4ef6(\u4ef6)");
        exportMaps.put("otherEvent", "\u5176\u4ed6\u4e8b\u4ef6(\u4ef6)");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/count/time"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e8b\u4ef6\u7edf\u8ba1-\u4e8b\u4ef6\u5904\u7f6e\u65f6\u95f4\u7edf\u8ba1", httpMethod="POST", notes="\u4e8b\u4ef6\u5904\u7f6e\u65f6\u95f4\u7edf\u8ba1")
    public CommonResult<List<CountEventByTimeVO>> countEventByTime(@RequestBody QueryFilter<BizEventInfo> queryFilter) {
        return ((BizEventInfoManager)this.baseService).countEventByTime(queryFilter);
    }

    @RequestMapping(value={"/dayReport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fd0\u884c\u4fe1\u606f-\u65e5\u62a5", httpMethod="POST", notes="\u8fd0\u884c\u4fe1\u606f-\u65e5\u62a5")
    public PageList<TrafficControlIlboVO> dayReport(@RequestBody QueryFilter<BizEventInfo> queryFilter) {
        return ((BizEventInfoManager)this.baseService).runInfoDayReport(queryFilter);
    }

    @RequestMapping(value={"/monthReport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fd0\u884c\u4fe1\u606f-\u6708\u62a5", httpMethod="POST", notes="\u8fd0\u884c\u4fe1\u606f-\u6708\u62a5")
    public CommonResult<JSONObject> monthReport(@RequestBody QueryFilter<BizEventInfo> queryFilter) {
        JSONObject object = ((BizEventInfoManager)this.baseService).runInfoMonthReport(queryFilter);
        return new CommonResult(true, "", (Object)object);
    }
}

