/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.video.util;

import com.hikvision.artemis.sdk.Client;
import com.hikvision.artemis.sdk.Request;
import com.hikvision.artemis.sdk.Response;
import com.hikvision.artemis.sdk.config.ArtemisConfig;
import com.hikvision.artemis.sdk.constant.Constants;
import com.hikvision.artemis.sdk.enums.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ArtemisHttp {
    private static final Logger log = LoggerFactory.getLogger(ArtemisHttp.class);

    public String doPostStringArtemis(ArtemisConfig artemisConfig, Map<String, String> path, String body, Map<String, String> querys, String accept, String contentType) {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema != null && !StringUtils.isEmpty((CharSequence)httpSchema)) {
            String responseStr = null;
            try {
                HashMap<String, String> headers = new HashMap<String, String>();
                if (StringUtils.isNotBlank((CharSequence)accept)) {
                    headers.put("Accept", accept);
                } else {
                    headers.put("Accept", "*/*");
                }
                if (StringUtils.isNotBlank((CharSequence)contentType)) {
                    headers.put("Content-Type", contentType);
                } else {
                    headers.put("Content-Type", "application/text;charset=UTF-8");
                }
                Request request = new Request(Method.POST_STRING, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
                request.setHeaders(headers);
                request.setQuerys(querys);
                request.setStringBody(body);
                Response response = Client.execute((Request)request);
                responseStr = ArtemisHttp.getHttpResponseResult(response);
            }
            catch (Exception e) {
                log.error("the Artemis PostString Request is failed[doPostStringArtemis]", (Throwable)e);
            }
            return responseStr;
        }
        throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
    }

    private static String getHttpResponseResult(Response response) {
        String responseStr = null;
        int statusCode = response.getStatusCode();
        if (!String.valueOf(statusCode).startsWith("2") && !String.valueOf(statusCode).startsWith("3")) {
            String msg = response.getErrorMessage();
            responseStr = response.getBody();
            log.error("the Artemis Request is Failed,statusCode:{},errorMsg:{}", (Object)statusCode, (Object)msg);
        } else {
            responseStr = response.getBody();
            log.debug("the Artemis Request is Success,statusCode:{},SuccessMsg:{}", (Object)statusCode, (Object)response.getBody());
        }
        return responseStr;
    }
}

