/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.rescue.base.dao.BizBaseTunnelDao;
import com.artfess.rescue.base.manager.BizBaseRoadManager;
import com.artfess.rescue.base.manager.BizBaseTunnelManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.model.BizBaseTunnel;
import com.artfess.rescue.integrate.consts.YhxtConsts;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizBaseTunnelManagerImpl
extends BaseManagerImpl<BizBaseTunnelDao, BizBaseTunnel>
implements BizBaseTunnelManager {
    @Resource
    YhxtConsts yhxtConsts;
    @Resource
    BizBaseRoadManager bizBaseRoadManager;

    @Override
    @Transactional
    public void SynchronizeData() {
        List<BizBaseTunnel> tunnels = this.yhxtConsts.getTunnel();
        if (tunnels == null || tunnels.isEmpty()) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u6570\u636e\u4fe1\u606f");
        }
        List ids = tunnels.stream().map(BizBaseTunnel::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().notIn(BizBaseTunnel::getId, ids);
        this.remove((Wrapper)wrapper);
        Map<String, List<BizBaseRoad>> map = this.bizBaseRoadManager.list().stream().collect(Collectors.groupingBy(BizBaseRoad::getId));
        String userName = ContextUtil.getCurrentUserName();
        LocalDateTime now = LocalDateTime.now();
        long timestamp = now.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        tunnels.forEach(t -> {
            BizBaseRoad road = (BizBaseRoad)((Object)((Object)((List)map.get(t.getRoadSegmentId())).get(0)));
            if (road != null) {
                t.setCompanyId(road.getCompanyId());
                t.setCompanyIds(road.getCompanyIds());
                t.setCompanyName(road.getCompanyName());
                t.setLastTime(timestamp);
                t.setUpdateName(userName);
            }
        });
        super.saveOrUpdateBatch(tunnels);
    }
}

