/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.open.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.rescue.base.manager.BizOrgReflectionManager;
import com.artfess.rescue.base.model.BizOrgReflection;
import com.artfess.rescue.event.enums.EventTypeLwEnum;
import com.artfess.rescue.event.manager.BizEventHandleManager;
import com.artfess.rescue.event.manager.BizEventInfoManager;
import com.artfess.rescue.event.manager.BizRescueHandleManager;
import com.artfess.rescue.event.manager.BizRescueInfoManager;
import com.artfess.rescue.event.manager.BizTrafficControlManager;
import com.artfess.rescue.event.model.BizEventInfo;
import com.artfess.rescue.event.model.BizRescueHandle;
import com.artfess.rescue.event.model.BizRescueInfo;
import com.artfess.rescue.event.model.BizTrafficControl;
import com.artfess.rescue.event.vo.HandInfoVO;
import com.artfess.rescue.monitor.manager.BizCallAgentsManager;
import com.artfess.rescue.monitor.manager.BizComplaintManagementManager;
import com.artfess.rescue.monitor.manager.BizEarlyWarningManagementManager;
import com.artfess.rescue.monitor.manager.BizRankOrgManager;
import com.artfess.rescue.monitor.manager.BizRankUserManager;
import com.artfess.rescue.monitor.model.BizCallAgents;
import com.artfess.rescue.monitor.model.BizComplaintManagement;
import com.artfess.rescue.monitor.model.BizEarlyWarningManagement;
import com.artfess.rescue.monitor.model.BizRankOrg;
import com.artfess.rescue.monitor.model.BizRankUser;
import com.artfess.rescue.open.dao.OpenMonitorDao;
import com.artfess.rescue.open.dto.BaseQueryDTO;
import com.artfess.rescue.open.dto.CameraInfoDTO;
import com.artfess.rescue.open.dto.EarlyWarningDTO;
import com.artfess.rescue.open.dto.OpenBaseQueryDTO;
import com.artfess.rescue.open.enums.CallCategoryEnum;
import com.artfess.rescue.open.manager.OpenCountManager;
import com.artfess.rescue.open.manager.OpenMonitorManager;
import com.artfess.rescue.open.vo.CallAgentsCountVO;
import com.artfess.rescue.open.vo.ComplaintVO;
import com.artfess.rescue.open.vo.EarlyWarningInfoVO;
import com.artfess.rescue.open.vo.EarlyWarningVO;
import com.artfess.rescue.open.vo.EventCountVO;
import com.artfess.rescue.open.vo.EventTrafficDetailsVO;
import com.artfess.rescue.open.vo.EventTrafficVO;
import com.artfess.rescue.open.vo.EventTypeVO;
import com.artfess.rescue.open.vo.MonitoringDataCountVo;
import com.artfess.rescue.open.vo.RankUserVO;
import com.artfess.rescue.open.vo.RoadOrgVO;
import com.artfess.rescue.open.vo.TaskCountVO;
import com.artfess.rescue.open.vo.TaskListVO;
import com.artfess.rescue.patrol.manager.BizInspectionResultManager;
import com.artfess.rescue.patrol.model.BizInspectionResult;
import com.artfess.rescue.video.dto.GetCamerasBySpatialIndexWithPageRequest;
import com.artfess.rescue.video.model.BizVideoMonitorPointInfo;
import com.artfess.rescue.video.util.HkArtemisRequest;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.vo.DictionaryDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OpenMonitorManagerImpl
implements OpenMonitorManager {
    private static final Logger log = LoggerFactory.getLogger(OpenMonitorManagerImpl.class);
    @Resource
    private BizRankOrgManager rankOrgManager;
    @Resource
    private BizRankUserManager rankUserManager;
    @Resource
    private OpenMonitorDao monitorDao;
    @Resource
    private BizEarlyWarningManagementManager earlyWarningManagementManager;
    @Resource
    private BizComplaintManagementManager complaintManagementManager;
    @Resource
    private OpenCountManager openCountManager;
    @Resource
    private BizRescueInfoManager rescueInfoManager;
    @Resource
    private BizEventHandleManager eventHandleManager;
    @Resource
    private BizRescueHandleManager handleManager;
    @Resource
    private BizTrafficControlManager trafficControlManager;
    @Resource
    private BizOrgReflectionManager orgReflectionManager;
    @Resource
    private BizCallAgentsManager callAgentsManager;
    @Resource
    private HkArtemisRequest hkArtemisRequest;
    @Resource
    private BizEventInfoManager eventInfoManager;
    @Resource
    private SysDictionaryDetailManager sysDictionaryDetailManager;
    @Resource
    private BizInspectionResultManager resultManager;

    @Override
    public CommonResult<List<RankUserVO>> rankUser(OpenBaseQueryDTO dto) {
        List rankOrgList;
        List<Object> rankUserVOS = new ArrayList();
        LambdaQueryWrapper rankOrgWrapper = new LambdaQueryWrapper();
        rankOrgWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        if (StringUtil.isNotEmpty((String)dto.getOrgId())) {
            rankOrgWrapper.eq(BizRankOrg::getRegionId, (Object)dto.getOrgId());
        }
        if (CollectionUtils.isEmpty((Collection)(rankOrgList = this.rankOrgManager.list((Wrapper)rankOrgWrapper)))) {
            return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", rankUserVOS);
        }
        List<String> ids = rankOrgList.stream().map(BizRankOrg::getId).collect(Collectors.toList());
        List<BizRankUser> rankUserList = this.rankUserManager.getUsers(ids);
        if (CollectionUtils.isEmpty(rankUserList)) {
            return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", rankUserVOS);
        }
        Map<String, List<BizRankOrg>> rankOrgMap = rankOrgList.stream().collect(Collectors.groupingBy(BizRankOrg::getId));
        HashMap<String, String> userMap = new HashMap<String, String>();
        for (BizRankUser bizRankUser : rankUserList) {
            String[] list;
            for (String userId : list = bizRankUser.getUserId().split(",")) {
                userMap.put(userId, rankOrgMap.get(bizRankUser.getOrgId()).get(0).getName());
            }
        }
        ArrayList<String> userIds = new ArrayList<String>(userMap.keySet());
        rankUserVOS = this.monitorDao.getRankUserByUserIds(userIds);
        rankUserVOS.forEach(e -> e.setOrgName((String)userMap.get(e.getUserId())));
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", rankUserVOS);
    }

    @Override
    public CommonResult<EarlyWarningVO> earlyWarning(OpenBaseQueryDTO dto) {
        EarlyWarningVO vo = new EarlyWarningVO();
        EarlyWarningDTO disaster = new EarlyWarningDTO();
        EarlyWarningDTO weather = new EarlyWarningDTO();
        EarlyWarningDTO traffic = new EarlyWarningDTO();
        LambdaQueryWrapper earlyWarningWrapper = new LambdaQueryWrapper();
        earlyWarningWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            earlyWarningWrapper.in(BizEarlyWarningManagement::getRoadId, dto.getRoadIds());
        }
        earlyWarningWrapper.and(e -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.between(BizEarlyWarningManagement::getWarningTime, (Object)dto.getStartTime(), (Object)dto.getEndTime())).or()).ge(BizEarlyWarningManagement::getRelieveWarningTime, (Object)LocalDateTime.now());
        });
        List list = this.earlyWarningManagementManager.list((Wrapper)earlyWarningWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (BizEarlyWarningManagement bizEarlyWarningManagement : list) {
                Integer warningType = bizEarlyWarningManagement.getWarningType();
                Integer warningLevel = bizEarlyWarningManagement.getWarningLevel();
                if (warningLevel == null || warningType == null) continue;
                this.updateWarningFrequency(warningType, warningLevel, weather, disaster, traffic);
            }
        }
        vo.setDisaster(disaster);
        vo.setWeather(weather);
        vo.setTrafficFlow(traffic);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResult<ComplaintVO> complaint(OpenBaseQueryDTO dto) {
        List list;
        ComplaintVO vo = new ComplaintVO();
        LambdaQueryWrapper complaintWrapper = new LambdaQueryWrapper();
        complaintWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            complaintWrapper.in(BizComplaintManagement::getRoadId, dto.getRoadIds());
        }
        if (Objects.nonNull(dto.getMonth())) {
            LocalDate lastDayOfMonth = dto.getMonth().withDayOfMonth(dto.getMonth().lengthOfMonth());
            LocalDateTime startOfMonth = dto.getMonth().atStartOfDay();
            LocalDateTime endOfMonth = lastDayOfMonth.atTime(LocalTime.MAX);
            complaintWrapper.between(BizComplaintManagement::getComplaintTime, (Object)startOfMonth, (Object)endOfMonth);
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.complaintManagementManager.list((Wrapper)complaintWrapper)))) {
            return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
        }
        for (BizComplaintManagement bizComplaintManagement : list) {
            Integer complaintCategory = bizComplaintManagement.getComplaintCategory();
            switch (complaintCategory) {
                case 1: {
                    vo.setTelegraphNumber(vo.getTelegraphNumber() + 1);
                    break;
                }
                case 2: {
                    vo.setComplaintNumber(vo.getComplaintNumber() + 1);
                    break;
                }
                case 3: {
                    vo.setOtherNumber(vo.getOtherNumber() + 1);
                    break;
                }
            }
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResult<EventCountVO> eventCount(OpenBaseQueryDTO dto) {
        List rescueIds;
        List handles;
        List rescueInfos;
        EventCountVO vo = new EventCountVO();
        LocalDateTime startTime = dto.getMonth().atStartOfDay();
        LocalDateTime endTime = dto.getMonth().with(TemporalAdjusters.lastDayOfMonth()).atTime(LocalTime.MAX);
        List<BizEventInfo> eventInfos = this.openCountManager.getEventInfos(dto.getRoadIds(), startTime, endTime, null);
        if (CollectionUtils.isEmpty(eventInfos)) {
            return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
        }
        List trafficCasualtyEvent = eventInfos.stream().filter(e -> e.getEventStatus() == 4 && "19".equals(e.getLwEventType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(trafficCasualtyEvent)) {
            long totalMinutes = trafficCasualtyEvent.stream().mapToLong(eventInfo -> {
                List<HandInfoVO> hands = this.eventHandleManager.getHands(eventInfo.getId());
                if (hands.isEmpty()) {
                    return 0L;
                }
                List sortedList = hands.stream().filter(h -> h.getHandleTime() != null).sorted(Comparator.comparing(HandInfoVO::getHandleTime)).collect(Collectors.toList());
                return Duration.between(((HandInfoVO)sortedList.get(0)).getHandleTime(), ((HandInfoVO)sortedList.get(sortedList.size() - 1)).getHandleTime()).toMinutes();
            }).sum();
            vo.setTrafficAccidentAge(BigDecimal.valueOf(totalMinutes).divide(BigDecimal.valueOf(trafficCasualtyEvent.size()), 2, RoundingMode.HALF_UP));
            vo.setTrafficCasualty(trafficCasualtyEvent.stream().mapToInt(e -> Optional.ofNullable(e.getHurtUserNum()).orElse(0) + Optional.ofNullable(e.getDeadUserNum()).orElse(0)).sum());
            HashSet<String> type = new HashSet<String>(Arrays.asList("19", "20", "21"));
            vo.setSpecialTrafficAccident((int)eventInfos.stream().filter(e -> e.getEventStatus() == 4 && type.contains(e.getLwEventType())).count());
        }
        LambdaQueryWrapper rescueQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)rescueQueryWrapper.eq(BizRescueInfo::getIsDele, (Object)"0")).eq(BizRescueInfo::getRescueStatus, (Object)5)).between(BizRescueInfo::getRescueTime, (Object)startTime, (Object)endTime);
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            rescueQueryWrapper.in(BizRescueInfo::getRoadId, dto.getRoadIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)(rescueInfos = this.rescueInfoManager.list((Wrapper)rescueQueryWrapper))) && CollectionUtils.isNotEmpty((Collection)(handles = this.handleManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BizRescueHandle::getRescueId, rescueIds = rescueInfos.stream().map(BizRescueInfo::getId).collect(Collectors.toList()))).eq(BizRescueHandle::getIsDele, (Object)"0"))))) {
            Map<String, List<BizRescueHandle>> rescueHandleMap = handles.stream().collect(Collectors.groupingBy(BizRescueHandle::getRescueId));
            long rescueMinutes = rescueHandleMap.values().stream().mapToLong(handleList -> {
                List sortedList = handleList.stream().sorted(Comparator.comparing(BizRescueHandle::getHandleTime)).collect(Collectors.toList());
                return Duration.between(((BizRescueHandle)((Object)((Object)sortedList.get(0)))).getHandleTime(), ((BizRescueHandle)((Object)((Object)sortedList.get(sortedList.size() - 1)))).getHandleTime()).toMinutes();
            }).sum();
            vo.setRescueMissionAge(BigDecimal.valueOf(rescueMinutes).divide(BigDecimal.valueOf(handles.size()), 2, RoundingMode.HALF_UP));
        }
        vo.setEventTypes((List)this.openCountManager.getTaskTypeCount(dto).getValue());
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResult<EventTrafficVO> eventTraffic(OpenBaseQueryDTO dto) {
        EventTrafficVO vo = new EventTrafficVO();
        LambdaQueryWrapper trafficQueryWrapper = new LambdaQueryWrapper();
        trafficQueryWrapper.eq(BizTrafficControl::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            trafficQueryWrapper.in(BizTrafficControl::getRoadId, dto.getRoadIds());
        }
        trafficQueryWrapper.between(BizTrafficControl::getStartTime, (Object)dto.getStartTime(), (Object)dto.getEndTime());
        List trafficControls = this.trafficControlManager.list((Wrapper)trafficQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)trafficControls)) {
            for (BizTrafficControl trafficControl : trafficControls) {
                if ("2".equals(trafficControl.getEventPlace())) {
                    vo.setTollStation(vo.getTollStation() + 1);
                    continue;
                }
                vo.setPrincipal(vo.getPrincipal() + 1);
            }
        }
        HashMap measureTypeCountMap = trafficControls == null ? new HashMap() : trafficControls.stream().filter(t -> t.getMeasureType() != null).collect(Collectors.groupingBy(BizTrafficControl::getMeasureType, Collectors.counting()));
        Map gzcs = this.sysDictionaryDetailManager.getTextByMap("gzcs");
        ArrayList<EventTrafficDetailsVO> details = new ArrayList<EventTrafficDetailsVO>();
        vo.setDetails(details);
        for (Map.Entry entry : gzcs.entrySet()) {
            Long aLong = (Long)measureTypeCountMap.get(entry.getKey());
            EventTrafficDetailsVO detailVO = new EventTrafficDetailsVO();
            detailVO.setIndexName(((DictionaryDetailVo)entry.getValue()).getName());
            detailVO.setIndexKey((String)entry.getKey());
            detailVO.setIndexValue(aLong != null ? aLong : 0L);
            details.add(detailVO);
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResult<List<EarlyWarningInfoVO>> earlyWarningInfos(OpenBaseQueryDTO dto, String type) {
        ArrayList vos = new ArrayList();
        LambdaQueryWrapper earlyWarningWrapper = new LambdaQueryWrapper();
        earlyWarningWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            earlyWarningWrapper.in(BizEarlyWarningManagement::getRoadId, dto.getRoadIds());
        }
        switch (type) {
            case "disaster": {
                earlyWarningWrapper.eq(BizEarlyWarningManagement::getWarningType, (Object)2);
                break;
            }
            case "weather": {
                earlyWarningWrapper.eq(BizEarlyWarningManagement::getWarningType, (Object)1);
                break;
            }
            case "trafficFlow": {
                earlyWarningWrapper.eq(BizEarlyWarningManagement::getWarningType, (Object)3);
                break;
            }
        }
        earlyWarningWrapper.and(e -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.between(BizEarlyWarningManagement::getWarningTime, (Object)dto.getStartTime(), (Object)dto.getEndTime())).or()).ge(BizEarlyWarningManagement::getRelieveWarningTime, (Object)LocalDateTime.now());
        });
        List earlyWarningManagementList = this.earlyWarningManagementManager.list((Wrapper)earlyWarningWrapper);
        if (CollectionUtils.isNotEmpty((Collection)earlyWarningManagementList)) {
            earlyWarningManagementList.forEach(e -> vos.add(new EarlyWarningInfoVO(e.getId(), e.getRoadId(), e.getRoadName(), e.getLng(), e.getLat(), e.getPegSVal(), e.getPegEVal(), e.getLocationCatUncle(), e.getWarningLevel(), e.getWarningContent(), e.getWarningTime(), e.getRelieveWarningTime(), e.getRegionalName(), e.getPubStatus())));
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @Override
    public Set<RoadOrgVO> getRoad(String orgId) {
        List<BizOrgReflection> orgReflections = this.orgReflectionManager.getRoad();
        Stream<RoadOrgVO> roadOrgStream = orgReflections.stream().map(e -> {
            RoadOrgVO vo = new RoadOrgVO();
            vo.setId(e.getOrganizationId());
            vo.setName(e.getOrgName());
            vo.setSn(e.getSn());
            return vo;
        });
        if (StringUtils.hasText((String)orgId)) {
            ArrayList<RoadOrgVO> vos = new ArrayList<RoadOrgVO>();
            this.setRoadOrg(orgReflections, vos, orgId);
            roadOrgStream = vos.stream();
        }
        return roadOrgStream.filter(vo -> vo.getName() != null && (vo.getName().contains("\u9ad8\u901f") || vo.getName().contains("\u590d\u7ebf"))).sorted(Comparator.comparing(RoadOrgVO::getSn, Comparator.nullsFirst(Comparator.naturalOrder()))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public CommonResult<CallAgentsCountVO> getCallAgents(OpenBaseQueryDTO dto) {
        CallAgentsCountVO vo = new CallAgentsCountVO();
        LambdaQueryWrapper callAgentsWrapper = new LambdaQueryWrapper();
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(BizOrgReflection::getRoadId, dto.getRoadIds());
            List list = this.orgReflectionManager.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List callAgentsRoadIds = list.stream().map(BizOrgReflection::getCallAgentsRoadId).collect(Collectors.toList());
                callAgentsWrapper.in(BizCallAgents::getRoadId, callAgentsRoadIds);
            }
        }
        callAgentsWrapper.between(BizCallAgents::getCalltime, (Object)dto.getStartTime(), (Object)dto.getEndTime());
        List list = this.callAgentsManager.list((Wrapper)callAgentsWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map<String, Runnable> actionMap = OpenMonitorManagerImpl.getStringRunnableMap(vo);
            list.forEach(e -> {
                String type = e.getLeadtype();
                Optional.ofNullable(actionMap.get(type)).ifPresent(Runnable::run);
            });
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    private void setRoadOrg(List<BizOrgReflection> list, List<RoadOrgVO> vos, String orgId) {
        for (BizOrgReflection orgReflection : list) {
            RoadOrgVO vo;
            if (StringUtil.isNotEmpty((String)orgReflection.getParentId()) && orgReflection.getParentId().equals(orgId)) {
                vo = new RoadOrgVO();
                vo.setId(orgReflection.getOrganizationId());
                vo.setName(orgReflection.getOrgName());
                vo.setSn(orgReflection.getSn());
                vos.add(vo);
                this.setRoadOrg(list, vos, orgReflection.getId());
                continue;
            }
            if (!orgReflection.getId().equals(orgId)) continue;
            vo = new RoadOrgVO();
            vo.setId(orgReflection.getOrganizationId());
            vo.setName(orgReflection.getOrgName());
            vo.setSn(orgReflection.getSn());
            vos.add(vo);
        }
    }

    private void updateWarningFrequency(Integer warningType, Integer warningLevel, EarlyWarningDTO weather, EarlyWarningDTO disaster, EarlyWarningDTO traffic) {
        EarlyWarningDTO target = null;
        switch (warningType) {
            case 1: {
                target = weather;
                break;
            }
            case 2: {
                target = disaster;
                break;
            }
            case 3: {
                target = traffic;
                break;
            }
            default: {
                return;
            }
        }
        target.setAllFrequency(target.getAllFrequency() + 1);
        switch (warningLevel) {
            case 1: {
                target.setRedFrequency(target.getRedFrequency() + 1);
                break;
            }
            case 2: {
                target.setOrangeFrequency(target.getOrangeFrequency() + 1);
                break;
            }
            case 3: {
                target.setYellowFrequency(target.getYellowFrequency() + 1);
                break;
            }
            case 4: {
                target.setBlueFrequency(target.getBlueFrequency() + 1);
                break;
            }
        }
    }

    private static Map<String, Runnable> getStringRunnableMap(CallAgentsCountVO vo) {
        HashMap<String, Runnable> actionMap = new HashMap<String, Runnable>();
        actionMap.put(CallCategoryEnum.SUDDEN_EVENT.getTypeValue(), () -> vo.setSuddenEvent(vo.getSuddenEvent() + 1));
        actionMap.put(CallCategoryEnum.PUBLIC_SERVICE.getTypeValue(), () -> vo.setPublicService(vo.getPublicService() + 1));
        actionMap.put(CallCategoryEnum.CONSTRUCTION.getTypeValue(), () -> vo.setConstruction(vo.getConstruction() + 1));
        actionMap.put(CallCategoryEnum.NOTIFICATION.getTypeValue(), () -> vo.setNotification(vo.getNotification() + 1));
        actionMap.put(CallCategoryEnum.OTHER.getTypeValue(), () -> vo.setOther(vo.getOther() + 1));
        return actionMap;
    }

    @Override
    public CommonResult<MonitoringDataCountVo> getRoadTaskCount(OpenBaseQueryDTO dto) {
        dto.setMonth(Optional.ofNullable(dto.getMonth()).orElse(LocalDate.now()));
        List<EventTypeVO> eventTypeList = this.monitorDao.getEventCount(dto);
        Map sjlxxq = this.sysDictionaryDetailManager.getTextByMap("lx_sjlxxq");
        Integer rescueCount = this.monitorDao.getRescueCount(dto);
        Integer inspectCount = this.monitorDao.getInspectCount(dto);
        eventTypeList.forEach(vo -> Optional.ofNullable(sjlxxq.get(vo.getEventTypeText())).ifPresent(detailVo -> vo.setEventTypeText(detailVo.getName())));
        int totalNum = eventTypeList.stream().mapToInt(EventTypeVO::getCount).sum();
        int noRankTotalNum = eventTypeList.stream().mapToInt(EventTypeVO::getNoRankCount).sum();
        MonitoringDataCountVo countVO = MonitoringDataCountVo.builder().eventTaskFrequency(totalNum).eventTypeList(eventTypeList).eventGradeFrequency(noRankTotalNum).inspectMileage(inspectCount.intValue()).rescueTaskFrequency(rescueCount).build();
        return CommonResult.success((Object)countVO, (String)"");
    }

    @Override
    public PageList<?> getCommonInfo(BaseQueryDTO dto) {
        if (dto.getMonth() == null) {
            dto.setMonth(LocalDate.now());
        }
        QueryFilter queryFilter = dto.getQueryFilter();
        String topic = dto.getTopic();
        if (StringUtil.isNotEmpty((String)topic)) {
            List<LocalDateTime> dateTimes = Arrays.asList(dto.getStartTime(), dto.getEndTime());
            switch (topic) {
                case "tfsj": {
                    queryFilter.addFilter("event_time_", dateTimes, QueryOP.BETWEEN);
                    queryFilter.addFilter("road_id_", dto.getRoadIds(), QueryOP.IN);
                    return this.eventInfoManager.query(queryFilter);
                }
                case "sjdj": {
                    queryFilter.addFilter("event_time_", dateTimes, QueryOP.BETWEEN);
                    queryFilter.addFilter("road_id_", dto.getRoadIds(), QueryOP.IN);
                    queryFilter.addFilter("EVENT_LEVEL_", (Object)"0", QueryOP.NOT_EQUAL);
                    return this.eventInfoManager.query(queryFilter);
                }
                case "xcrw": {
                    queryFilter.addFilter("START_TIME_", dateTimes, QueryOP.BETWEEN);
                    queryFilter.addFilter("road_id_", dto.getRoadIds(), QueryOP.IN);
                    return this.resultManager.queryByPage((QueryFilter<BizInspectionResult>)queryFilter);
                }
                case "jyrw": {
                    queryFilter.addFilter("RESCUE_TIME_", dateTimes, QueryOP.BETWEEN);
                    queryFilter.addFilter("road_id_", dto.getRoadIds(), QueryOP.IN);
                    return this.rescueInfoManager.query(queryFilter);
                }
                case "yjxx": {
                    queryFilter.addFilter("WARNING_TIME_", dateTimes, QueryOP.BETWEEN, FieldRelation.AND, "1");
                    queryFilter.addFilter("RELIEVE_WARNING_TIME_", (Object)LocalDateTime.now(), QueryOP.LESS_EQUAL, FieldRelation.OR, "1");
                    queryFilter.addFilter("road_id_", dto.getRoadIds(), QueryOP.IN);
                    return this.earlyWarningManagementManager.query(queryFilter);
                }
                case "tszx": {
                    queryFilter.addFilter("calltime", dateTimes, QueryOP.BETWEEN);
                    queryFilter.addFilter("road_id_", dto.getRoadIds(), QueryOP.IN);
                    return this.callAgentsManager.query(queryFilter);
                }
                case "jtgz": {
                    queryFilter.addFilter("START_TIME_", dateTimes, QueryOP.BETWEEN);
                    queryFilter.addFilter("road_id_", dto.getRoadIds(), QueryOP.IN);
                    return this.trafficControlManager.query(queryFilter);
                }
            }
        }
        return new PageList();
    }

    @Override
    public CommonResult<TaskCountVO> getTaskCount(OpenBaseQueryDTO dto) {
        TaskCountVO vo = new TaskCountVO();
        List<BizEventInfo> eventInfos = this.getEventInfos(dto.getRoadIds(), dto.getStartTime(), dto.getEndTime());
        if (CollectionUtils.isNotEmpty(eventInfos)) {
            vo.setEventTaskFrequency(eventInfos.size());
            int eventComplete = 0;
            int eventDisposal = 0;
            int eventNotDisposal = 0;
            for (BizEventInfo eventInfo : eventInfos) {
                int status = eventInfo.getEventStatus();
                if (status == 4) {
                    ++eventComplete;
                }
                if (status == 2 || status == 3) {
                    ++eventDisposal;
                }
                if (status != 1 && status != 0 && status != -1) continue;
                ++eventNotDisposal;
            }
            vo.setEventComplete(eventComplete);
            vo.setEventDisposal(eventDisposal);
            vo.setEventNotDisposal(eventNotDisposal);
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResult<List<TaskListVO>> realtimeEvent(OpenBaseQueryDTO dto) {
        dto.setStartTime(LocalDate.now().atStartOfDay());
        dto.setEndTime(LocalDate.now().atTime(23, 59, 59));
        List<BizEventInfo> eventInfos = this.getEventInfos(dto.getRoadIds(), dto.getStartTime(), dto.getEndTime());
        ArrayList<TaskListVO> taskList = new ArrayList<TaskListVO>();
        if (CollectionUtils.isNotEmpty(eventInfos)) {
            for (BizEventInfo eventInfo : eventInfos) {
                taskList.add(new TaskListVO(eventInfo.getId(), eventInfo.getRoadName(), eventInfo.getPegSVal(), eventInfo.getPegEVal(), eventInfo.getEventLevel(), eventInfo.getEventType(), eventInfo.getEventTime(), eventInfo.getLng(), eventInfo.getLat(), EventTypeLwEnum.getResultByValue(eventInfo.getLwEventType()), eventInfo.getMemo(), this.cameraInfos(eventInfo.getLng(), eventInfo.getLat())));
            }
        }
        return CommonResult.success(taskList, (String)"");
    }

    @Override
    public CommonResult<List<BizTrafficControl>> controlList(OpenBaseQueryDTO dto) {
        LambdaQueryWrapper controlWrapper = new LambdaQueryWrapper();
        controlWrapper.eq(BizTrafficControl::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            controlWrapper.in(BizTrafficControl::getRoadId, dto.getRoadIds());
        }
        controlWrapper.and(e -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.between(BizTrafficControl::getStartTime, (Object)dto.getStartTime(), (Object)dto.getEndTime())).or()).eq(BizTrafficControl::getStatus, (Object)1);
        });
        List controlList = this.trafficControlManager.list((Wrapper)controlWrapper);
        return new CommonResult(true, "", (Object)controlList);
    }

    public List<BizEventInfo> getEventInfos(List<String> roadIds, LocalDateTime startTime, LocalDateTime endTime) {
        LambdaQueryWrapper eventQueryWrapper = new LambdaQueryWrapper();
        if (CollectionUtils.isNotEmpty(roadIds)) {
            eventQueryWrapper.in(BizEventInfo::getRoadId, roadIds);
        }
        eventQueryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.or(subWrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)subWrapper.between(BizEventInfo::getEventTime, (Object)startTime, (Object)endTime);
            })).or(subWrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)subWrapper.lt(BizEventInfo::getEventTime, (Object)startTime)).ne(BizEventInfo::getEventStatus, (Object)4);
            });
        });
        return this.eventInfoManager.list((Wrapper)eventQueryWrapper);
    }

    public List<CameraInfoDTO> cameraInfos(String lng, String lat) {
        ArrayList<CameraInfoDTO> list = new ArrayList<CameraInfoDTO>();
        if (StringUtil.isEmpty((String)lng) || StringUtil.isEmpty((String)lat)) {
            return list;
        }
        GetCamerasBySpatialIndexWithPageRequest request = GetCamerasBySpatialIndexWithPageRequest.builder().pageNo(1).pageSize(20).geometryType("Circle").treeCode("0").longitude(lng).latitude(lat).distance(1000).build();
        try {
            JSONObject data;
            JSONArray jsonArray;
            String cameraJsonString = this.hkArtemisRequest.getCamerasBySpatialIndexWithPage(request);
            JSONObject jsonResult = JSONObject.parseObject((String)cameraJsonString);
            if ("0".equals(jsonResult.getString("code")) && CollectionUtils.isNotEmpty((Collection)(jsonArray = (data = jsonResult.getJSONObject("data")).getJSONArray("list")))) {
                List bizVideoAreaInfos = jsonArray.toJavaList(BizVideoMonitorPointInfo.class);
                bizVideoAreaInfos.forEach(info -> {
                    CameraInfoDTO dto = new CameraInfoDTO();
                    dto.setId(info.getCameraIndexCode());
                    dto.setName(info.getName());
                    dto.setCameraType(info.getCameraTypeName());
                    dto.setStatus(info.getStatus());
                    list.add(dto);
                });
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u7ecf\u7eac\u5ea6\u83b7\u53d6\u5468\u8fb9\u6444\u50cf\u5934\u4fe1\u606f\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            return list;
        }
        return list;
    }
}

