/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.video.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.rescue.video.dao.BizVideoAreaInfoDao;
import com.artfess.rescue.video.dto.VideoMonitorPointCountDTO;
import com.artfess.rescue.video.manager.BizVideoAreaInfoManager;
import com.artfess.rescue.video.manager.BizVideoMonitorPointInfoManager;
import com.artfess.rescue.video.model.BizVideoAreaInfo;
import com.artfess.rescue.video.vo.VideoAreaInfoTreeVO;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizVideoAreaInfoManagerImpl
extends BaseManagerImpl<BizVideoAreaInfoDao, BizVideoAreaInfo>
implements BizVideoAreaInfoManager {
    private static final Logger log = LoggerFactory.getLogger(BizVideoAreaInfoManagerImpl.class);
    @Resource
    private BizVideoMonitorPointInfoManager videoMonitorPointInfoManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSynchronizationInfo(JSONArray jsonArray) {
        List bizVideoAreaInfos = jsonArray.toJavaList(BizVideoAreaInfo.class);
        if (CollectionUtils.isNotEmpty((Collection)bizVideoAreaInfos)) {
            bizVideoAreaInfos.forEach(e -> e.setId(e.getIndexCode()));
            this.saveOrUpdateBatch(bizVideoAreaInfos);
        }
    }

    @Override
    public CommonResult<List<VideoAreaInfoTreeVO>> getTree() {
        List allList = this.getAll();
        if (CollectionUtils.isEmpty((Collection)allList)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)Lists.newArrayList());
        }
        List<VideoAreaInfoTreeVO> treeVOList = new ArrayList();
        for (BizVideoAreaInfo bizVideoAreaInfo : allList) {
            VideoAreaInfoTreeVO vo = new VideoAreaInfoTreeVO();
            try {
                BeanUtils.copyNotNullProperties((Object)((Object)vo), (Object)((Object)bizVideoAreaInfo));
                vo.setParentId(bizVideoAreaInfo.getParentIndexCode());
                treeVOList.add(vo);
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                throw new RuntimeException(e2);
            }
        }
        treeVOList = BeanUtils.listToTree(treeVOList);
        List<VideoMonitorPointCountDTO> videoMonitorPointCountDTOS = this.videoMonitorPointInfoManager.getCountGroupByUnitIndexCode();
        HashMap<String, Map<String, Integer>> countMap = new HashMap<String, Map<String, Integer>>();
        videoMonitorPointCountDTOS.forEach(e -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("onlineSum", e.getOnlineSum());
            map.put("offlineSum", e.getOfflineSum());
            countMap.put(e.getUnitIndexCode(), map);
        });
        List<VideoAreaInfoTreeVO> areaInfoTree = this.setSiteCount(treeVOList, countMap);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", areaInfoTree);
    }

    public List<VideoAreaInfoTreeVO> setSiteCount(List<VideoAreaInfoTreeVO> list, Map<String, Map<String, Integer>> countMap) {
        for (VideoAreaInfoTreeVO areaInfoTreeVO : list) {
            Integer onlineSum = 0;
            Integer offlineSum = 0;
            if (countMap.containsKey(areaInfoTreeVO.getIndexCode())) {
                onlineSum = countMap.get(areaInfoTreeVO.getIndexCode()).get("onlineSum");
                offlineSum = countMap.get(areaInfoTreeVO.getIndexCode()).get("offlineSum");
            }
            areaInfoTreeVO.setOnlineSum(onlineSum);
            areaInfoTreeVO.setVideoMonitorPointSum(onlineSum + offlineSum);
            int totalOnlineSum = onlineSum;
            int totalVideoMonitorPointSum = onlineSum + offlineSum;
            if (CollectionUtils.isNotEmpty((Collection)areaInfoTreeVO.getChildren())) {
                List childNodes = areaInfoTreeVO.getChildren();
                for (VideoAreaInfoTreeVO child : childNodes) {
                    this.setSiteCount(Collections.singletonList(child), countMap);
                    totalOnlineSum += child.getOnlineSum().intValue();
                    totalVideoMonitorPointSum += child.getVideoMonitorPointSum().intValue();
                }
            }
            areaInfoTreeVO.setOnlineSum(totalOnlineSum);
            areaInfoTreeVO.setVideoMonitorPointSum(totalVideoMonitorPointSum);
        }
        return list;
    }
}

