/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.handler.inter.IExcelVerifyHandler;
import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.rescue.monitor.utils.EmptyHandler;
import com.artfess.rescue.patrol.dao.BizInspectRankUserDao;
import com.artfess.rescue.patrol.manager.BizInspectRankInfoManager;
import com.artfess.rescue.patrol.manager.BizInspectRankUserManager;
import com.artfess.rescue.patrol.model.BizInspectRankInfo;
import com.artfess.rescue.patrol.model.BizInspectRankUser;
import com.artfess.rescue.patrol.vo.BizInspectRankUserExcelVo;
import com.artfess.rescue.patrol.vo.InspectRankUserVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizInspectRankUserManagerImpl
extends BaseManagerImpl<BizInspectRankUserDao, BizInspectRankUser>
implements BizInspectRankUserManager {
    @Resource
    private BizInspectRankInfoManager rankInfoManager;
    @Resource
    private UCFeignService feignService;

    @Override
    public List<InspectRankUserVo> findMonthArrangeInfo(String startDate, String orgId, String rankGroupId) {
        if (StringUtil.isEmpty((String)startDate)) {
            throw new BaseException("\u8bf7\u9009\u62e9\u5f00\u59cb\u65f6\u95f4");
        }
        LocalDate beginDate = null;
        try {
            beginDate = DateFormatUtil.parse((String)startDate).toLocalDate();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        LocalDate endDate = beginDate.plusMonths(1L).withDayOfMonth(1);
        List<BizInspectRankUser> rankUserList = ((BizInspectRankUserDao)this.baseMapper).findMonthArrangeInfo(startDate, endDate.toString(), orgId, rankGroupId);
        ArrayList<InspectRankUserVo> vos = new ArrayList<InspectRankUserVo>();
        if (null != rankUserList && rankUserList.size() > 0) {
            Set groupIds = rankUserList.stream().map(BizInspectRankUser::getRankId).collect(Collectors.toSet());
            List rankInfos = this.rankInfoManager.listByIds(groupIds);
            Map<String, List<BizInspectRankInfo>> rankInfoMap = rankInfos.stream().collect(Collectors.groupingBy(BizInspectRankInfo::getId));
            for (BizInspectRankUser BizInspectRankUser2 : rankUserList) {
                InspectRankUserVo InspectRankUserVo2 = new InspectRankUserVo();
                BeanUtil.copyProperties((Object)((Object)BizInspectRankUser2), (Object)((Object)InspectRankUserVo2), (String[])new String[0]);
                List<BizInspectRankInfo> bizRankInfos = rankInfoMap.get(BizInspectRankUser2.getRankId());
                if (null != bizRankInfos && !bizRankInfos.isEmpty()) {
                    BizInspectRankInfo bizRankInfo = bizRankInfos.get(0);
                    InspectRankUserVo2.setMarkColor(bizRankInfo.getMarkColor());
                    InspectRankUserVo2.setWorkEndTime(bizRankInfo.getWorkEndTime());
                    InspectRankUserVo2.setWorkStartTime(bizRankInfo.getWorkStartTime());
                    InspectRankUserVo2.setRestStartTime(bizRankInfo.getRestStartTime());
                    InspectRankUserVo2.setRestEndTime(bizRankInfo.getRestEndTime());
                }
                vos.add(InspectRankUserVo2);
            }
        }
        return vos;
    }

    @Override
    public CommonResult importRankUsers(MultipartFile file, String orgId) {
        ImportParams params = new ImportParams();
        params.setTitleRows(1);
        params.setHeadRows(1);
        params.setStartSheetIndex(0);
        params.setSheetNum(1);
        params.setVerifyHandler((IExcelVerifyHandler)new EmptyHandler());
        List list = null;
        try {
            System.out.println("\u5bfc\u5165\u6392\u73ed\u4fe1\u606f\u89e3\u6790Excel\u6570\u636e\u5f00\u59cb");
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), BizInspectRankUserExcelVo.class, (ImportParams)params);
            System.out.println("\u5bfc\u5165\u6392\u73ed\u4fe1\u606f\u89e3\u6790Excel\u6570\u636e\u5b8c\u6bd5");
            list = result.getList();
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u5165\u6392\u73ed\u4fe1\u606f\u89e3\u6790\u5931\u8d25,errorMsg:" + e.getMessage());
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (list.size() == 0) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        ArrayList<BizInspectRankUser> rankUsers = new ArrayList<BizInspectRankUser>();
        ArrayList<String> removeIds = new ArrayList<String>();
        for (BizInspectRankUserExcelVo excelVo : list) {
            ArrayList userIdList;
            HashMap<String, String> userMap;
            if (null == excelVo.getRankName() || "".equals(excelVo.getRankName())) continue;
            QueryWrapper infoQueryWrapper = new QueryWrapper();
            infoQueryWrapper.eq((Object)"org_id_", (Object)orgId);
            infoQueryWrapper.eq((Object)"is_dele_", (Object)"0");
            infoQueryWrapper.eq((Object)"name_", (Object)excelVo.getRankName());
            List rankInfos = this.rankInfoManager.list((Wrapper)infoQueryWrapper);
            if (null == rankInfos || rankInfos.isEmpty()) {
                throw new BaseException("\u73ed\u6b21\u540d\u79f0\u4e0d\u5b58\u5728-" + excelVo.getRankName());
            }
            BizInspectRankInfo rankInfo = (BizInspectRankInfo)((Object)rankInfos.get(0));
            BizInspectRankUser rankUser = new BizInspectRankUser();
            rankUser.setRankName(excelVo.getRankName());
            rankUser.setRankId(rankInfo.getId());
            rankUser.setOrgId(orgId);
            Date rankDate = excelVo.getRankDate();
            LocalDate rankDateLocal = DateUtil.asLocalDate((Date)rankDate);
            rankUser.setRankDate(rankDateLocal);
            rankUser.setResponsName(excelVo.getResponsName());
            String userNameStr = excelVo.getUserName();
            if (StringUtil.isNotEmpty((String)userNameStr)) {
                userNameStr = userNameStr.replaceAll("[\uff0c\u3001\\s]+", ",");
                ObjectNode allOrgsUsers = this.feignService.getAllOrgsUsers(orgId);
                JsonNode rows = allOrgsUsers.get("rows");
                userMap = new HashMap<String, String>();
                for (JsonNode row : rows) {
                    ObjectNode user = (ObjectNode)row;
                    String name = user.get("fullname").asText();
                    String id = user.get("id").asText();
                    userMap.put(name, id);
                }
                List<String> nameList = Arrays.asList(userNameStr.split(","));
                userIdList = new ArrayList();
                for (String userName : nameList) {
                    if (!userMap.containsKey(userName)) continue;
                    userIdList.add(userMap.get(userName));
                }
            } else {
                throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u503c\u73ed\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String id = String.join((CharSequence)",", userIdList);
            rankUser.setResponsId(userMap.getOrDefault(rankUser.getResponsName(), ""));
            rankUser.setUserName(userNameStr);
            rankUser.setUserId(id);
            QueryWrapper rankUserQueryWrapper = new QueryWrapper();
            rankUserQueryWrapper.eq((Object)"rank_id_", (Object)rankInfo.getId());
            rankUserQueryWrapper.eq((Object)"is_dele_", (Object)"0");
            rankUserQueryWrapper.eq((Object)"rank_date_", (Object)rankDateLocal);
            List BizInspectRankUsers = this.list((Wrapper)rankUserQueryWrapper);
            if (null != BizInspectRankUsers && BizInspectRankUsers.isEmpty()) {
                for (BizInspectRankUser user : BizInspectRankUsers) {
                    removeIds.add(user.getId());
                }
            }
            rankUser.setIsDele("0");
            rankUsers.add(rankUser);
        }
        this.removeByIds(removeIds);
        this.saveBatch(rankUsers);
        return new CommonResult(true, "\u5bfc\u5165\u5b8c\u6210");
    }
}

