/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.report.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.JsonUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.rescue.event.dao.BizEventInfoDao;
import com.artfess.rescue.event.vo.CountEventNumVO;
import com.artfess.rescue.event.vo.CountIncidentNumVO;
import com.artfess.rescue.event.vo.CountOtIncidentNumVO;
import com.artfess.rescue.event.vo.CountRoadOrderNumVO;
import com.artfess.rescue.event.vo.CountTrafficCongestionNumVO;
import com.artfess.rescue.event.vo.CountTrafficControlNumVO;
import com.artfess.rescue.report.dto.FilterDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/statsReport/v1/"})
@Api(tags={"\u62a5\u8868\u7edf\u8ba1"})
@ApiGroup(group={"group_biz_rescue"})
public class StatsReportController {
    @Resource
    BizEventInfoDao eventInfoDao;

    @PostMapping(value={"/eventNum"})
    @ApiOperation(value="\u4e8b\u4ef6\u6570")
    public CommonResult<?> eventNum(@RequestBody FilterDto dto) {
        List<CountIncidentNumVO> voList = this.eventInfoDao.incidentNumCount(dto);
        return CommonResult.success(voList, (String)"");
    }

    @PostMapping(value={"/eventNum/export"})
    @ApiOperation(value="\u4e8b\u4ef6\u6570-excel\u5bfc\u51fa")
    public void eventNumExport(HttpServletResponse response, @RequestBody FilterDto dto) throws Exception {
        List<CountIncidentNumVO> voList = this.eventInfoDao.incidentNumCount(dto);
        ArrayList<Map> list = new ArrayList<Map>();
        if (voList != null && voList.size() > 0) {
            for (CountIncidentNumVO vo : voList) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                list.add(map);
            }
        }
        String tempName = "\u4e8b\u6545\u7edf\u8ba1";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("orgName", "\u4e8b\u6545\u533a\u57df");
        exportMaps.put("roadName", "\u4e8b\u6545\u8def\u6bb5");
        exportMaps.put("eventLevelNum", "\u4e8b\u6545\u7b49\u7ea7\uff08\u8d77\uff09\uff08\u91cd\u8981\u4e8b\u4ef6\uff09");
        exportMaps.put("totalNum", "\u7a81\u53d1\u4e8b\u6545\u603b\u6570\uff08\u8d77\uff09");
        exportMaps.put("trafficNum", "\u4ea4\u901a\u4e8b\u6545\uff08\u8d77\uff09");
        exportMaps.put("dgNum", "\u5371\u5316\u54c1\u4e8b\u6545\uff08\u8d77\uff09");
        exportMaps.put("fireNum", "\u706b\u707e\u4e8b\u6545\uff08\u8d77\uff09");
        exportMaps.put("otherNum", "\u5176\u5b83\u4e8b\u6545\uff08\u8d77\uff09");
        exportMaps.put("hurtNum", "\u4eba\u4f24\u4e8b\u6545\uff08\u8d77\uff09");
        exportMaps.put("hurtPeopleNum", "\u53d7\u4f24\u4eba\u6570\uff08\u540d\uff09");
        exportMaps.put("deadPeopleNum", "\u53d7\u4f24\u4eba\u6570\uff08\u540d\uff09");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @PostMapping(value={"/otEventNum"})
    @ApiOperation(value="\u7a81\u53d1\u4e8b\u4ef6\u6570")
    public CommonResult<?> otEventNum(@RequestBody FilterDto dto) {
        List<CountOtIncidentNumVO> voList = this.eventInfoDao.otEventNumCount(dto);
        return CommonResult.success(voList, (String)"");
    }

    @PostMapping(value={"/otEventNum/export"})
    @ApiOperation(value="\u7a81\u53d1\u4e8b\u4ef6\u6570-excel\u5bfc\u51fa")
    public void otEventNumExport(HttpServletResponse response, @RequestBody FilterDto dto) throws Exception {
        List<CountOtIncidentNumVO> voList = this.eventInfoDao.otEventNumCount(dto);
        ArrayList<Map> list = new ArrayList<Map>();
        if (voList != null && voList.size() > 0) {
            for (CountOtIncidentNumVO vo : voList) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                list.add(map);
            }
        }
        String tempName = "\u7a81\u53d1\u4e8b\u4ef6\u7edf\u8ba1";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("orgName", "\u4e8b\u6545\u533a\u57df");
        exportMaps.put("roadName", "\u4e8b\u6545\u8def\u6bb5");
        exportMaps.put("eventLevelNum", "\u4e8b\u6545\u7b49\u7ea7\uff08\u8d77\uff09\uff08\u91cd\u8981\u4e8b\u4ef6\uff09");
        exportMaps.put("totalNum", "\u7a81\u53d1\u4e8b\u6545\u603b\u6570\uff08\u8d77\uff09");
        exportMaps.put("weatherHazardNum", "\u6c14\u8c61\u707e\u5bb3\uff08\u4ef6\uff09");
        exportMaps.put("geoHazardNum", "\u5730\u8d28\u707e\u5bb3\u4e8b\u4ef6\uff08\u4ef6\uff09");
        exportMaps.put("eventNum", "\u4e8b\u6545\u707e\u96be\uff08\u4ef6\uff09");
        exportMaps.put("groupEventNum", "\u7fa4\u4f53\u4e8b\u4ef6\uff08\u4ef6\uff09");
        exportMaps.put("repairNum", "\u517b\u62a4\u65bd\u5de5\uff08\u4ef6\uff09");
        exportMaps.put("trafficNum", "\u7a81\u53d1\u5927\u8f66\u6d41\u91cf\uff08\u6b21\uff09");
        exportMaps.put("otRoadNum", "\u6545\u969c\u8f66\u5360\u9053\uff08\u6b21\uff09");
        exportMaps.put("otherNum", "\u5176\u4ed6\u4e8b\u4ef6\uff08\u6b21\uff09");
        exportMaps.put("hurtNum", "\u4eba\u4f24\u4e8b\u6545\uff08\u8d77\uff09");
        exportMaps.put("hurtPeopleNum", "\u53d7\u4f24\u4eba\u6570\uff08\u540d\uff09");
        exportMaps.put("deadPeopleNum", "\u6b7b\u4ea1\u4eba\u6570\uff08\u540d");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @PostMapping(value={"/trafficControlNum"})
    @ApiOperation(value="\u4ea4\u901a\u7ba1\u5236\u6570")
    public CommonResult<?> trafficControlNum(@RequestBody FilterDto dto) {
        List<CountTrafficControlNumVO> voList = this.eventInfoDao.trafficControlNumCount(dto);
        return CommonResult.success(voList, (String)"");
    }

    @PostMapping(value={"/trafficControlNum/export"})
    @ApiOperation(value="\u4ea4\u901a\u7ba1\u5236\u6570-excel\u5bfc\u51fa")
    public void trafficControlNumExport(HttpServletResponse response, @RequestBody FilterDto dto) throws Exception {
        List<CountTrafficControlNumVO> voList = this.eventInfoDao.trafficControlNumCount(dto);
        ArrayList<Map> list = new ArrayList<Map>();
        if (voList != null && voList.size() > 0) {
            for (CountTrafficControlNumVO vo : voList) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                list.add(map);
            }
        }
        String tempName = "\u4ea4\u901a\u7ba1\u5236\u7edf\u8ba1";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("orgName", "\u7ba1\u5236\u533a\u57df");
        exportMaps.put("roadName", "\u7ba1\u5236\u8def\u6bb5");
        exportMaps.put("totalNum", "\u5171\u8ba1\u7ba1\u5236\u6570\u91cf\uff08\u6b21\uff09");
        exportMaps.put("otRoadNum", "\u5360\u9053\u7ba1\u5236\uff08\u8d77\uff09");
        exportMaps.put("halfClosedNum", "\u534a\u5e45\u5c01\u95ed\uff08\u8d77\uff09");
        exportMaps.put("outletClosedNum", "\u51fa\u53e3\u5c01\u95ed\uff08\u8d77\uff09");
        exportMaps.put("inletClosedNum", "\u5165\u53e3\u5c01\u95ed\uff08\u8d77\uff09");
        exportMaps.put("laneClosedNum", "\u5c01\u95ed\u8f66\u9053\uff08\u8d77\uff09");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @PostMapping(value={"/taskLedgerNum"})
    @ApiOperation(value="\u5de1\u67e5\u6551\u63f4\u7edf\u8ba1")
    public CommonResult<?> taskLedgerNum(@RequestBody FilterDto dto) {
        List<CountEventNumVO> voList = this.eventInfoDao.eventNumCount(dto);
        return CommonResult.success(voList, (String)"");
    }

    @PostMapping(value={"/taskLedgerNum/export"})
    @ApiOperation(value="\u5de1\u67e5\u6551\u63f4\u7edf\u8ba1-excel\u5bfc\u51fa")
    public void taskLedgerNumExport(HttpServletResponse response, @RequestBody FilterDto dto) throws Exception {
        List<CountEventNumVO> voList = this.eventInfoDao.eventNumCount(dto);
        ArrayList<Map> list = new ArrayList<Map>();
        if (voList != null && voList.size() > 0) {
            for (CountEventNumVO vo : voList) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                list.add(map);
            }
        }
        String tempName = "\u4ea4\u901a\u7ba1\u5236\u7edf\u8ba1";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("orgName", "\u6240\u5c5e\u533a\u57df");
        exportMaps.put("roadName", "\u6240\u5c5e\u8def\u6bb5");
        exportMaps.put("insTaskNum", "\u5171\u8ba1\u5de1\u67e5\u4efb\u52a1\uff08\u6b21\uff09");
        exportMaps.put("insMileage", "\u5de1\u67e5\u516c\u91cc\u6570\uff08\u516c\u91cc\uff09");
        exportMaps.put("etTaskNum", "\u7a81\u53d1\u4e8b\u4ef6\u5904\u7f6e\uff08\u6b21\uff09");
        exportMaps.put("rePointNum", "\u5e03\u7f6e\u6551\u63f4\u70b9\uff08\u4e2a\uff09");
        exportMaps.put("reCarNum", "\u5e03\u7f6e\u6551\u63f4\u8f66\u8f86\uff08\u8f86\uff09");
        exportMaps.put("reMemberNum", "\u5e03\u7f6e\u6551\u63f4\u4eba\u5458\uff08\u540d\uff09");
        exportMaps.put("reTaskNum", "\u51fa\u53d1\u6551\u63f4\u4efb\u52a1\uff08\u6b21\uff09");
        exportMaps.put("reHandTime", "\u5e73\u5747\u5904\u7f6e\u65f6\u957f\uff08\u5206\u949f\uff09");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @PostMapping(value={"/trafficCongestionNum"})
    @ApiOperation(value="\u4ea4\u901a\u62e5\u5835\u7edf\u8ba1")
    public CommonResult<?> trafficCongestionNum(@RequestBody FilterDto dto) {
        ArrayList<CountTrafficCongestionNumVO> voList = new ArrayList<CountTrafficCongestionNumVO>();
        CountTrafficCongestionNumVO countEventNumVO = new CountTrafficCongestionNumVO();
        voList.add(countEventNumVO);
        return CommonResult.success(voList, (String)"");
    }

    @PostMapping(value={"/roadOrderNum"})
    @ApiOperation(value="\u8def\u4ea7\u5355\u6570\u91cf\u7edf\u8ba1")
    public CommonResult<?> roadOrderNum(@RequestBody FilterDto dto) {
        List<CountRoadOrderNumVO> voList = this.eventInfoDao.roadOrderCount(dto);
        return CommonResult.success(voList, (String)"");
    }

    @PostMapping(value={"/roadOrderNum/export"})
    @ApiOperation(value="\u8def\u4ea7\u5355\u6570\u91cf\u7edf\u8ba1-excel\u5bfc\u51fa")
    public void roadOrderNumExport(HttpServletResponse response, @RequestBody FilterDto dto) throws Exception {
        List<CountRoadOrderNumVO> voList = this.eventInfoDao.roadOrderCount(dto);
        ArrayList<Map> list = new ArrayList<Map>();
        if (voList != null && voList.size() > 0) {
            for (CountRoadOrderNumVO vo : voList) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                list.add(map);
            }
        }
        String tempName = "\u8def\u4ea7\u5355\u6570\u91cf\u7edf\u8ba1";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("roadName", "\u6240\u5c5e\u8def\u6bb5");
        exportMaps.put("loss", "\u8def\u4ea7\u635f\u5931\uff08\u5143\uff09");
        exportMaps.put("totalNum", "\u603b\u5355\u6570");
        exportMaps.put("finishNum", "\u5b8c\u7ed3\u5355\u6570");
        exportMaps.put("unFinishNum", "\u672a\u5b8c\u7ed3\u5355\u6570");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }
}

