/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.job;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.job.model.BaseJob;
import com.artfess.rescue.video.dto.RegionsRequest;
import com.artfess.rescue.video.manager.BizVideoAreaInfoManager;
import com.artfess.rescue.video.util.HkArtemisRequest;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoAreaInfoSynchronizationJob
extends BaseJob {
    private static final Logger log = LoggerFactory.getLogger(VideoAreaInfoSynchronizationJob.class);
    @Resource
    private BizVideoAreaInfoManager videoAreaInfoManager;
    @Resource
    private HkArtemisRequest hkArtemisRequest;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;

    public void executeJob(JobExecutionContext context) throws Exception {
        int j = 1;
        for (int i = 1; i <= j; ++i) {
            String regionsResponse = this.fetchRegionsData(i);
            JSONObject regionsJson = JSONObject.parseObject((String)regionsResponse);
            if ("0".equals(regionsJson.getString("code"))) {
                JSONObject dataJson = regionsJson.getJSONObject("data");
                Integer total = dataJson.getInteger("total");
                if (total == null || total == 0) continue;
                j = (total + 199) / 200;
                JSONArray list = dataJson.getJSONArray("list");
                if (list == null || list.isEmpty()) continue;
                this.executorService.execute(() -> this.videoAreaInfoManager.saveSynchronizationInfo(list));
                continue;
            }
            log.error("Failed to fetch regions data with response: {}", (Object)regionsResponse);
            break;
        }
    }

    private String fetchRegionsData(int pageNo) {
        RegionsRequest regionsRequest = RegionsRequest.builder().pageNo(pageNo).pageSize(200).treeCode("0").build();
        try {
            return this.hkArtemisRequest.regions(regionsRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

