/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.external.manager.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.util.HttpUtils;
import com.artfess.rescue.base.manager.BizBaseRoadManager;
import com.artfess.rescue.base.manager.BizBaseTeamManager;
import com.artfess.rescue.base.manager.BizCarTaskLogManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.model.BizBaseTeam;
import com.artfess.rescue.base.model.BizCarTaskLog;
import com.artfess.rescue.common.util.PointUtil;
import com.artfess.rescue.external.enums.DirectionEnum;
import com.artfess.rescue.external.enums.InspectionTaskStatusEnum;
import com.artfess.rescue.external.enums.PointCategoryEnum;
import com.artfess.rescue.external.manager.BizRoadCheckWorkDetailManager;
import com.artfess.rescue.external.manager.BizRoadCheckWorkManager;
import com.artfess.rescue.external.manager.SyncRoadCheckManger;
import com.artfess.rescue.external.model.BizRoadCheckWork;
import com.artfess.rescue.external.model.BizRoadCheckWorkDetail;
import com.artfess.rescue.patrol.manager.BizInspectionResultDetailManager;
import com.artfess.rescue.patrol.manager.BizInspectionResultManager;
import com.artfess.rescue.patrol.manager.BizInspectionTaskManager;
import com.artfess.rescue.patrol.model.BizInspectionResult;
import com.artfess.rescue.patrol.model.BizInspectionResultDetail;
import com.artfess.rescue.patrol.model.BizInspectionTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SyncInspectionMangerImpl
implements SyncRoadCheckManger {
    private static final Logger log = LoggerFactory.getLogger(SyncInspectionMangerImpl.class);
    @Resource
    private BizInspectionTaskManager bizInspectionTaskManager;
    @Resource
    private BizInspectionResultManager bizInspectionResultManager;
    @Resource
    private BizInspectionResultDetailManager bizInspectionResultDetailManager;
    @Resource
    private BizCarTaskLogManager bizCarTaskLogManager;
    @Resource
    private BizBaseRoadManager bizBaseRoadManager;
    @Resource
    private BizRoadCheckWorkManager bizRoadCheckWorkManager;
    @Resource
    private BizBaseTeamManager bizBaseTeamManager;
    @Resource
    private BizRoadCheckWorkDetailManager bizRoadCheckWorkDetailManager;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;
    @Resource
    private PointUtil pointUtil;
    @Value(value="${zhundian.api.url}")
    private String url;
    @Value(value="${zhundian.api.sQueryKey}")
    private String sQueryKey;
    private static final String CQ_ORG_ID = "1766017472697475072";
    private static final String ROAD_CHECK_WORK_URL = "/extapi/getRoadCheckWorkList";
    private static final String ROAD_CHECK_WORK_DETAIL_URL = "/extapi/getRoadCheckWorkDetail";
    private static Map<String, BizBaseRoad> ROAD_MAP = new HashMap<String, BizBaseRoad>();
    private static Map<String, BizBaseTeam> TEAM_MAP = new HashMap<String, BizBaseTeam>();

    @Override
    public void syncEvent() {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sQueryKey", this.sQueryKey);
            params.put("start", 0);
            params.put("size", 100);
            String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(DateUtils.addDays((Date)new Date(), (int)-7));
            params.put("dBeginTimeBegin", URLEncoder.encode(format, "UTF-8"));
            this.syncInspection(params);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void syncInspection(Map<String, Object> params) throws Exception {
        ArrayList<BizRoadCheckWork> roadCheckWorkList = new ArrayList<BizRoadCheckWork>();
        ArrayList<BizRoadCheckWorkDetail> roadCheckWorkDetailList = new ArrayList<BizRoadCheckWorkDetail>();
        ObjectMapper mapper = new ObjectMapper();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        while (true) {
            String jsonRoadCheckWork;
            JsonNode data;
            JSONArray inspections;
            if ((inspections = JSONUtil.parseArray((String)(data = mapper.readTree(jsonRoadCheckWork = HttpUtils.get((String)(this.url + ROAD_CHECK_WORK_URL), params)).get("data")).toString())).isEmpty()) break;
            List inspectionMaps = (List)mapper.readValue(data.toString(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            List collect = inspectionMaps.stream().filter(inspection -> "\u5b8c\u6210".equals(inspection.get("sStatus"))).collect(Collectors.toList());
            for (Map map : collect) {
                BizRoadCheckWork roadCheckWork = this.buildRoadCheckWork(map, formatter);
                HashMap<String, String> detailParams = new HashMap<String, String>();
                detailParams.put("sQueryKey", this.sQueryKey);
                detailParams.put("nId", (String)map.get("nId"));
                String detailJson = HttpUtils.get((String)(this.url + ROAD_CHECK_WORK_DETAIL_URL), detailParams);
                JsonNode detailData = mapper.readTree(detailJson).get("data");
                this.enrichInspectionFromDetail(roadCheckWork, detailData);
                JsonNode recordList = detailData.get("recordList");
                if (recordList != null && recordList.isArray()) {
                    List diseaseList = (List)mapper.readValue(recordList.toString(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                    for (Map diseaseMap : diseaseList) {
                        BizRoadCheckWorkDetail roadCheckWorkDetail = this.buildDiseaseFromMap(diseaseMap, formatter);
                        roadCheckWorkDetail.setNId(roadCheckWork.getId());
                        if (!StringUtils.isNotEmpty((String)roadCheckWorkDetail.getId()) || !StringUtils.isNotEmpty((String)roadCheckWorkDetail.getSRoad())) continue;
                        roadCheckWorkDetailList.add(roadCheckWorkDetail);
                    }
                }
                if (!StringUtils.isNotEmpty((String)roadCheckWork.getId()) || !StringUtils.isNotEmpty((String)roadCheckWork.getSRoad())) continue;
                roadCheckWorkList.add(roadCheckWork);
            }
            this.executorService.execute(() -> this.saveDistinctBatch(roadCheckWorkList, roadCheckWorkDetailList));
            params.put("start", Integer.parseInt(params.get("start").toString()) + 1);
        }
        log.info("\u5de1\u68c0\u4efb\u52a1\u6570\u636e\u540c\u6b65\u5b8c\u6210\uff0cstart={}", params.get("start"));
    }

    private BizRoadCheckWork buildRoadCheckWork(Map<String, Object> map, DateTimeFormatter formatter) {
        BizRoadCheckWork roadCheckWork = new BizRoadCheckWork();
        roadCheckWork.setId(this.toStr(map.get("nId")));
        roadCheckWork.setSNo(this.toStr(map.get("sNo")));
        roadCheckWork.setSRoadCheckWorkPlanNo(this.toStr(map.get("sRoadCheckWorkPlanNo")));
        roadCheckWork.setSPlateNo(this.toStr(map.get("sPlateNo")));
        roadCheckWork.setSWeather(this.toStr(map.get("sWeather")));
        roadCheckWork.setNBeginLong(this.toStr(map.get("nBeginLong")));
        roadCheckWork.setNEndLong(this.toStr(map.get("nEndLong")));
        roadCheckWork.setNRunLong(this.toStr(map.get("nRunLong")));
        roadCheckWork.setDBeginTime(this.parseDate(map.get("dBeginTime"), formatter));
        roadCheckWork.setDEndTime(this.parseDate(map.get("dEndTime"), formatter));
        roadCheckWork.setNTime(this.toStr(map.get("nTime")));
        roadCheckWork.setSStatus(this.toStr(map.get("sStatus")));
        return roadCheckWork;
    }

    private void enrichInspectionFromDetail(BizRoadCheckWork roadCheckWork, JsonNode detail) {
        roadCheckWork.setSType(this.getJsonString(detail.get("sType")));
        roadCheckWork.setSRoad(this.getJsonString(detail.get("sRoad")));
        roadCheckWork.setSClass(this.getJsonString(detail.get("sClass")));
        roadCheckWork.setSKind(this.getJsonString(detail.get("sKind")));
        roadCheckWork.setSTaskValue(this.getJsonString(detail.get("sTaskValue")));
        roadCheckWork.setSBeginStation(this.getJsonString(detail.get("sBeginStation")));
        roadCheckWork.setSEndStation(this.getJsonString(detail.get("sEndStation")));
        roadCheckWork.setSDoPersonName(this.getJsonString(detail.get("sDoPersonName")));
        roadCheckWork.setNCheckPoint(this.getJsonString(detail.get("nCheckPoint")));
        roadCheckWork.setNErrorPoint(this.getJsonString(detail.get("nErrorPoint")));
    }

    private BizRoadCheckWorkDetail buildDiseaseFromMap(Map<String, Object> map, DateTimeFormatter formatter) {
        BizRoadCheckWorkDetail detail = new BizRoadCheckWorkDetail();
        detail.setId(this.toStr(map.get("nId")));
        detail.setSRoad(this.toStr(map.get("sRoad")));
        detail.setSValue(this.toStr(map.get("sValue")));
        detail.setSStatus(this.toStr(map.get("sStatus")));
        detail.setSCheckMessage(this.toStr(map.get("sCheckMessage")));
        detail.setSDoResult(this.toStr(map.get("sDoResult")));
        detail.setSDir(this.toStr(map.get("sDir")));
        detail.setSType(this.toStr(map.get("sType")));
        detail.setSKind(this.toStr(map.get("sKind")));
        detail.setSName(this.toStr(map.get("sName")));
        detail.setSDoPerson(this.toStr(map.get("sDoPerson")));
        detail.setSDoValue(this.toStr(map.get("sDoValue")));
        detail.setSLongitude(this.toStr(map.get("sLongitude")));
        detail.setSLatitude(this.toStr(map.get("sLatitude")));
        detail.setDCreateDate(this.parseDate(map.get("dCreateDate"), formatter));
        return detail;
    }

    private void saveDistinctBatch(List<BizRoadCheckWork> roadCheckWorkList, List<BizRoadCheckWorkDetail> roadCheckWorkDetailList) {
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        List roadCheckWorks = roadCheckWorkList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BizRoadCheckWork>(Comparator.comparing(BizRoadCheckWork::getId))), ArrayList::new));
        List roadCheckWorkDetails = roadCheckWorkDetailList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BizRoadCheckWorkDetail>(Comparator.comparing(BizRoadCheckWorkDetail::getId))), ArrayList::new));
        Future<Boolean> workFuture = this.executorService.submit(() -> this.bizRoadCheckWorkManager.saveOrUpdateBatch(roadCheckWorks));
        futures.add(workFuture);
        Future<Boolean> workDetailFuture = this.executorService.submit(() -> this.bizRoadCheckWorkDetailManager.saveOrUpdateBatch(roadCheckWorkDetails));
        futures.add(workDetailFuture);
        ArrayList taskList = new ArrayList();
        ArrayList resultList = new ArrayList();
        ArrayList resultDetailList = new ArrayList();
        ArrayList carTaskLogList = new ArrayList();
        Map<String, List<BizRoadCheckWorkDetail>> detailMap = roadCheckWorkDetails.stream().collect(Collectors.groupingBy(BizRoadCheckWorkDetail::getNId));
        roadCheckWorks.forEach(roadCheckWork -> {
            BizInspectionTask bizInspectionTask = new BizInspectionTask();
            bizInspectionTask.setId(roadCheckWork.getId());
            bizInspectionTask.setPlanId(roadCheckWork.getSRoadCheckWorkPlanNo());
            bizInspectionTask.setTaskNo(roadCheckWork.getSNo());
            bizInspectionTask.setTaskDate(roadCheckWork.getDBeginTime() != null ? roadCheckWork.getDBeginTime().toLocalDate() : null);
            bizInspectionTask.setTaskEndDate(roadCheckWork.getDEndTime() != null ? roadCheckWork.getDEndTime().toLocalDate() : null);
            String roadCode = roadCheckWork.getSRoad();
            if (ROAD_MAP.containsKey(roadCode)) {
                BizBaseRoad baseRoad = ROAD_MAP.get(roadCode);
                BizBaseTeam baseTeam = TEAM_MAP.get(roadCode);
                bizInspectionTask.setRoadId(baseRoad.getId());
                bizInspectionTask.setRoadName(baseRoad.getName());
                bizInspectionTask.setRoadCode(baseRoad.getCode());
                bizInspectionTask.setTeamId(baseTeam.getId());
                bizInspectionTask.setTeamName(baseTeam.getName());
            } else {
                LambdaQueryWrapper roadQueryWrapper = new LambdaQueryWrapper();
                roadQueryWrapper.eq(BizBaseRoad::getCode, (Object)roadCode);
                roadQueryWrapper.like(BizBaseRoad::getCompanyIds, (Object)CQ_ORG_ID);
                List roads = this.bizBaseRoadManager.list((Wrapper)roadQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)roads)) {
                    BizBaseRoad baseRoad = (BizBaseRoad)((Object)((Object)((Object)roads.get(0))));
                    bizInspectionTask.setRoadId(baseRoad.getId());
                    bizInspectionTask.setRoadName(baseRoad.getName());
                    bizInspectionTask.setRoadCode(baseRoad.getCode());
                    ROAD_MAP.put(roadCode, baseRoad);
                    LambdaQueryWrapper teamQueryWrapper = new LambdaQueryWrapper();
                    teamQueryWrapper.eq(BizBaseTeam::getRoadId, (Object)baseRoad.getId());
                    teamQueryWrapper.eq(BizDelModel::getIsDele, (Object)"0");
                    List list = this.bizBaseTeamManager.list((Wrapper)teamQueryWrapper);
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        BizBaseTeam baseTeam = (BizBaseTeam)((Object)((Object)((Object)list.get(0))));
                        bizInspectionTask.setTeamId(baseTeam.getId());
                        bizInspectionTask.setTeamName(baseTeam.getName());
                        TEAM_MAP.put(roadCode, baseTeam);
                    }
                }
            }
            bizInspectionTask.setPlanType(roadCheckWork.getSKind() != null ? ("\u65e5\u5e38".equals(roadCheckWork.getSKind()) ? "1" : "2") : null);
            bizInspectionTask.setWorkclass(roadCheckWork.getSClass() != null ? ("\u767d\u73ed".equals(roadCheckWork.getSClass()) ? "1" : "2") : null);
            bizInspectionTask.setInspectType(roadCheckWork.getSType() != null ? ("\u5f80\u8fd4".equals(roadCheckWork.getSType()) ? "1" : "2") : null);
            bizInspectionTask.setStartPatrolName(roadCheckWork.getSBeginStation());
            bizInspectionTask.setEndPatrolName(roadCheckWork.getSEndStation());
            bizInspectionTask.setTaskStatus(InspectionTaskStatusEnum.getStatusByYjjyValue(roadCheckWork.getSStatus()));
            if (bizInspectionTask.getTaskStatus() != 4 && bizInspectionTask.getTaskDate().isBefore(LocalDate.now())) {
                bizInspectionTask.setOverdueLog(1);
            } else {
                bizInspectionTask.setOverdueLog(0);
            }
            BizInspectionResult bizInspectionResult = new BizInspectionResult();
            bizInspectionResult.setId(roadCheckWork.getId());
            bizInspectionResult.setTaskId(bizInspectionTask.getId());
            bizInspectionResult.setPlanId(bizInspectionTask.getPlanId());
            bizInspectionResult.setTaskNo(bizInspectionTask.getTaskNo());
            bizInspectionResult.setRoadId(bizInspectionTask.getRoadId());
            bizInspectionResult.setRoadName(bizInspectionTask.getRoadName());
            bizInspectionResult.setRoadCode(bizInspectionTask.getRoadCode());
            bizInspectionResult.setStartPatrolName(bizInspectionTask.getStartPatrolName());
            bizInspectionResult.setEndPatrolName(bizInspectionTask.getEndPatrolName());
            bizInspectionResult.setType(bizInspectionTask.getPlanType());
            bizInspectionResult.setWorkclass(bizInspectionTask.getWorkclass());
            bizInspectionResult.setInspectType(bizInspectionTask.getInspectType());
            bizInspectionResult.setStartTime(roadCheckWork.getDBeginTime());
            bizInspectionResult.setEndTime(roadCheckWork.getDEndTime());
            bizInspectionResult.setInspectUsersName(roadCheckWork.getSDoPersonName());
            bizInspectionResult.setWeather(roadCheckWork.getSWeather());
            bizInspectionResult.setCarCode(roadCheckWork.getSPlateNo());
            bizInspectionResult.setTimeSpent(StringUtils.isNotEmpty((String)roadCheckWork.getNTime()) ? Long.valueOf(Long.parseLong(roadCheckWork.getNTime()) * 60L) : null);
            bizInspectionResult.setMileage(SyncInspectionMangerImpl.convertMetersToKilometers(roadCheckWork.getNRunLong()));
            bizInspectionResult.setReportingPoint(StringUtils.isNotEmpty((String)roadCheckWork.getNCheckPoint()) ? Integer.valueOf(Integer.parseInt(roadCheckWork.getNCheckPoint())) : null);
            bizInspectionResult.setOutlierPoint(StringUtils.isNotEmpty((String)roadCheckWork.getNErrorPoint()) ? Integer.valueOf(Integer.parseInt(roadCheckWork.getNErrorPoint())) : null);
            BizCarTaskLog bizCarTaskLog = new BizCarTaskLog();
            bizCarTaskLog.setId(roadCheckWork.getId());
            bizCarTaskLog.setTaskId(bizInspectionTask.getId());
            bizCarTaskLog.setCarCode(bizInspectionResult.getCarCode());
            bizCarTaskLog.setStartMileage(SyncInspectionMangerImpl.convertMeters(roadCheckWork.getNBeginLong()));
            String nEndLong = roadCheckWork.getNEndLong();
            if (nEndLong == null || nEndLong.equals("0")) {
                bizCarTaskLog.setEndMileage(Objects.requireNonNull(SyncInspectionMangerImpl.convertMeters(roadCheckWork.getNBeginLong())).add(SyncInspectionMangerImpl.convertMetersToKilometers(roadCheckWork.getNRunLong())));
            } else {
                bizCarTaskLog.setEndMileage(SyncInspectionMangerImpl.convertMeters(roadCheckWork.getNEndLong()));
            }
            bizCarTaskLog.setIsUse(1);
            bizCarTaskLog.setTaskType("i");
            taskList.add(bizInspectionTask);
            resultList.add(bizInspectionResult);
            carTaskLogList.add(bizCarTaskLog);
            List roadCheckWorkResultDetails = (List)detailMap.get(roadCheckWork.getId());
            if (CollectionUtils.isNotEmpty((Collection)roadCheckWorkResultDetails)) {
                roadCheckWorkResultDetails.forEach(resultDetail -> {
                    BizInspectionResultDetail detail = new BizInspectionResultDetail();
                    detail.setId(resultDetail.getId());
                    detail.setTaskId(bizInspectionTask.getId());
                    detail.setResultId(bizInspectionResult.getId());
                    detail.setCategory(resultDetail.getSType().equals("\u4e34\u65f6\u70b9") ? 2 : 1);
                    detail.setType(PointCategoryEnum.getCodeByDescription(resultDetail.getSKind()));
                    detail.setTypeContent(resultDetail.getSValue());
                    detail.setTypeContentDetail(resultDetail.getSName());
                    detail.setDirection(DirectionEnum.getXcCodeByName(resultDetail.getSDir()));
                    detail.setLng(resultDetail.getSLongitude());
                    detail.setLat(resultDetail.getSLatitude());
                    try {
                        JSONObject jsonContent;
                        String stakeNum;
                        String pegVal = this.pointUtil.pointMapping(Double.parseDouble(detail.getLat()), Double.parseDouble(detail.getLng()), "02", bizInspectionTask.getRoadCode(), detail.getDirection());
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pegVal) && StringUtils.isNotEmpty((String)(stakeNum = (jsonContent = JSONObject.parseObject((String)pegVal)).getString("stakeNum")))) {
                            if (!stakeNum.contains(".")) {
                                stakeNum = stakeNum + ".000";
                            }
                            String[] parts = stakeNum.split("\\.");
                            String result = "K" + parts[0] + "+" + parts[1];
                            detail.setPegVal(result);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u7ecf\u7eac\u5ea6\u8f6c\u6869\u53f7\u5931\u8d25\uff01\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    }
                    detail.setInspectTime(resultDetail.getDCreateDate());
                    detail.setInspectInfo(resultDetail.getSCheckMessage());
                    detail.setInspectUserName(resultDetail.getSDoPerson());
                    detail.setHandleType(resultDetail.getSDoResult().equals("\u5df2\u5904\u7406") ? "1" : "2");
                    detail.setInspectStatus(resultDetail.getSStatus().equals("\u6b63\u5e38") ? "1" : "0");
                    detail.setTeamId(bizInspectionTask.getTeamId());
                    detail.setHandleStatus(detail.getInspectStatus().equals("0") ? (detail.getHandleType().equals("1") ? "1" : "0") : null);
                    detail.setHandleContent(resultDetail.getSDoValue());
                    detail.setHandleUserName(resultDetail.getSDoPerson());
                    detail.setHandleTime(resultDetail.getDCreateDate());
                    resultDetailList.add(detail);
                });
            }
        });
        Future<Boolean> taskFuture = this.executorService.submit(() -> this.bizInspectionTaskManager.saveOrUpdateBatch(taskList));
        futures.add(taskFuture);
        Future<Boolean> resultFuture = this.executorService.submit(() -> this.bizInspectionResultManager.saveOrUpdateBatch(resultList));
        futures.add(resultFuture);
        Future<Boolean> resultDetailFuture = this.executorService.submit(() -> this.bizInspectionResultDetailManager.saveOrUpdateBatch(resultDetailList));
        futures.add(resultDetailFuture);
        Future<Boolean> carLogFuture = this.executorService.submit(() -> this.bizCarTaskLogManager.saveOrUpdateBatch(carTaskLogList));
        futures.add(carLogFuture);
        for (Future future : futures) {
            try {
                if (((Boolean)future.get()).booleanValue()) continue;
                log.error("\u540c\u6b65\u5de1\u68c0\u4efb\u52a1\u5931\u8d25\uff01");
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Error in async execution", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private String toStr(Object obj) {
        if (obj == null) {
            return null;
        }
        String str = obj.toString().trim();
        if (StringUtils.isBlank((String)str)) {
            log.error("\u5f85\u8f6c\u6362\u7684\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff0c\u539f\u59cb\u5bf9\u8c61\u4e3a\uff1a{}", obj);
            return null;
        }
        return str;
    }

    private LocalDateTime parseDate(Object dateObj, DateTimeFormatter formatter) {
        if (dateObj == null) {
            return null;
        }
        String dateStr = dateObj.toString().trim();
        if (StringUtils.isBlank((String)dateStr)) {
            log.error("\u5f85\u89e3\u6790\u7684\u65e5\u671f\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff0c\u539f\u59cb\u5bf9\u8c61\u4e3a\uff1a{}", dateObj);
            return null;
        }
        try {
            return LocalDateTime.parse(dateStr, formatter);
        }
        catch (DateTimeParseException e) {
            log.error("\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff1a\u5b57\u7b26\u4e32 [{}] \u683c\u5f0f\u4e0d\u6b63\u786e", (Object)dateStr, (Object)e);
            return null;
        }
    }

    private String getJsonString(JsonNode node) {
        if (node == null) {
            return null;
        }
        String rawStr = node.toString().trim();
        if (StringUtils.isBlank((String)rawStr)) {
            log.warn("JsonNode \u8f6c\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff0c\u539f\u59cb\u5bf9\u8c61\u4e3a\uff1a{}", (Object)node);
            return null;
        }
        return StringUtils.strip((String)rawStr, (String)"\"");
    }

    public static BigDecimal convertMetersToKilometers(String metersStr) {
        if (metersStr == null || metersStr.trim().isEmpty()) {
            return BigDecimal.ZERO;
        }
        try {
            BigDecimal meters = new BigDecimal(metersStr.trim());
            return meters.divide(BigDecimal.valueOf(1000L), 6, RoundingMode.HALF_UP);
        }
        catch (NumberFormatException e) {
            log.error("\u8f93\u5165\u7684\u7c73\u6570\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57: {}", (Object)metersStr, (Object)e);
            return null;
        }
    }

    public static BigDecimal convertMeters(String metersStr) {
        if (metersStr == null || metersStr.trim().isEmpty()) {
            return BigDecimal.ZERO;
        }
        try {
            BigDecimal meters = new BigDecimal(metersStr.trim());
            return meters;
        }
        catch (NumberFormatException e) {
            log.error("\u8f93\u5165\u7684\u7c73\u6570\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57: {}", (Object)metersStr, (Object)e);
            return null;
        }
    }

    @Override
    public void test(String startTime, String endTime) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sQueryKey", this.sQueryKey);
        params.put("start", 0);
        params.put("size", 100);
        params.put("dBeginTimeBegin", URLEncoder.encode(startTime, "UTF-8"));
        params.put("dBeginTimeEnd", URLEncoder.encode(endTime, "UTF-8"));
        this.syncInspection(params);
    }
}

