/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.cloud.manager.impl;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.rescue.cloud.dao.BizCloudApplyDetailDao;
import com.artfess.rescue.cloud.dto.CloudApplyDetailSaveDTO;
import com.artfess.rescue.cloud.dto.CloudApplyPortDTO;
import com.artfess.rescue.cloud.manager.BizCloudApplyDetailManager;
import com.artfess.rescue.cloud.manager.BizCloudApplyDetailPortManager;
import com.artfess.rescue.cloud.model.BizCloudApplyDetail;
import com.artfess.rescue.cloud.model.BizCloudApplyDetailPort;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizCloudApplyDetailManagerImpl
extends BaseManagerImpl<BizCloudApplyDetailDao, BizCloudApplyDetail>
implements BizCloudApplyDetailManager {
    @Resource
    private BizCloudApplyDetailPortManager cloudApplyDetailPortManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> saveList(List<BizCloudApplyDetail> cloudApplyDetailList) {
        boolean result = this.saveOrUpdateBatch(cloudApplyDetailList);
        if (!result) {
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25");
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> saveInfo(CloudApplyDetailSaveDTO dto) {
        BizCloudApplyDetail detail = dto.getCloudApplyDetail();
        boolean result = this.save((Object)detail);
        boolean portResult = true;
        String PrivateCloudApplyDetailedId = detail.getId();
        if (CollectionUtils.isNotEmpty(dto.getCloudApplyDetailPorts())) {
            List<BizCloudApplyDetailPort> list = dto.getCloudApplyDetailPorts();
            list.forEach(e -> e.setPrivateCloudApplyDetailedId(PrivateCloudApplyDetailedId));
            portResult = this.cloudApplyDetailPortManager.saveBatch(dto.getCloudApplyDetailPorts());
        }
        if (!result || !portResult) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u65b0\u589e\u6210\u529f", (Object)PrivateCloudApplyDetailedId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> updateInfo(CloudApplyDetailSaveDTO dto) {
        BizCloudApplyDetail detail = dto.getCloudApplyDetail();
        boolean result = this.updateById((Object)detail);
        if (CollectionUtils.isNotEmpty(dto.getCloudApplyDetailPorts())) {
            String PrivateCloudApplyDetailedId = detail.getId();
            List<BizCloudApplyDetailPort> list = dto.getCloudApplyDetailPorts();
            list.forEach(e -> e.setPrivateCloudApplyDetailedId(PrivateCloudApplyDetailedId));
            this.cloudApplyDetailPortManager.saveOrUpdateBatch(list);
        }
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u4fee\u6539\u6210\u529f", (Object)detail.getId());
    }

    @Override
    @Transactional(readOnly=true)
    public CommonResult<List<CloudApplyDetailSaveDTO>> getListByPrivateCloudApplyId(String privateCloudApplyId) {
        Assert.hasText((String)privateCloudApplyId, (String)"\u4e91\u8d44\u6e90\u7533\u8bf7ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList list = new ArrayList();
        LambdaQueryWrapper queryDetailWrapper = new LambdaQueryWrapper();
        queryDetailWrapper.eq(BizCloudApplyDetail::getPrivateCloudApplyId, (Object)privateCloudApplyId);
        queryDetailWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        List detailList = this.list((Wrapper)queryDetailWrapper);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            List detailIds = detailList.stream().map(BizCloudApplyDetail::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryDetailPortWrapper = new LambdaQueryWrapper();
            queryDetailPortWrapper.in(BizCloudApplyDetailPort::getPrivateCloudApplyDetailedId, detailIds);
            queryDetailPortWrapper.eq(BizDelModel::getIsDele, (Object)"0");
            List detailPortList = this.cloudApplyDetailPortManager.list((Wrapper)queryDetailPortWrapper);
            Map<String, List<BizCloudApplyDetailPort>> map = detailPortList.stream().collect(Collectors.groupingBy(BizCloudApplyDetailPort::getPrivateCloudApplyDetailedId));
            detailList.forEach(e -> {
                CloudApplyDetailSaveDTO dto = new CloudApplyDetailSaveDTO();
                dto.setCloudApplyDetail((BizCloudApplyDetail)((Object)e));
                dto.setCloudApplyDetailPorts(new ArrayList<BizCloudApplyDetailPort>());
                if (map.containsKey(e.getId())) {
                    dto.setCloudApplyDetailPorts((List)map.get(e.getId()));
                }
                list.add(dto);
            });
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", list);
    }

    @Override
    public List<CloudApplyPortDTO> getCloudApplyPortDTOList(String privateCloudApplyId) {
        return ((BizCloudApplyDetailDao)this.baseMapper).getCloudApplyPortDTOList(privateCloudApplyId);
    }
}

