/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.mqtt.config;

import com.artfess.rescue.mqtt.model.MqttServerConfig;
import com.artfess.rescue.mqtt.service.MqttConfigService;
import com.artfess.rescue.video.manager.GpsService;
import java.util.List;
import javax.annotation.Resource;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

@Configuration
public class MqttDynamicConfig {
    private static final Logger log = LoggerFactory.getLogger(MqttDynamicConfig.class);
    @Resource
    private MqttConfigService configService;
    @Resource
    private GpsService gpsService;

    @EventListener(value={ApplicationReadyEvent.class})
    public void setupMqttConnections() {
        if (!this.configService.isMqttEnabled()) {
            log.info("mqtt\u914d\u7f6e\u5173\u95ed\uff0c\u4e0d\u76d1\u542c\u6570\u636e\uff01");
            return;
        }
        List<MqttServerConfig> configs = this.configService.fetchMqttConfigurations();
        if (configs != null && !configs.isEmpty()) {
            for (MqttServerConfig config : configs) {
                try {
                    MqttClient client = new MqttClient(config.getServerUrl(), config.getClientId());
                    MqttConnectOptions options = new MqttConnectOptions();
                    options.setUserName(config.getUsername());
                    options.setPassword(config.getPassword().toCharArray());
                    options.setCleanSession(false);
                    options.setConnectionTimeout(1800);
                    options.setKeepAliveInterval(20);
                    options.setAutomaticReconnect(true);
                    client.connect(options);
                    client.subscribe(config.getTopic(), config.getQos(), (topic, message) -> this.handleMqttMessage(topic, new String(message.getPayload())));
                    log.info("MQTT \u8fde\u63a5\u5efa\u7acb\u6210\u529f:{},{} ", (Object)config.getServerUrl(), (Object)config.getClientId());
                }
                catch (MqttException e) {
                    e.printStackTrace();
                    log.error("MQTT \u8fde\u63a5\u5931\u8d25: {},{}", (Object)config.getServerUrl(), (Object)e.getMessage());
                }
            }
        } else {
            log.error("\u672a\u83b7\u53d6\u5230 MQTT \u670d\u52a1\u5668\u914d\u7f6e\uff0c\u65e0\u6cd5\u521b\u5efa MQTT \u8fde\u63a5\uff01");
        }
    }

    private void handleMqttMessage(String topic, String payload) {
        log.debug("\u63a5\u6536\u5230\u4e3b\u9898 [ {} ]\u7684\u6d88\u606f:{} ", (Object)topic, (Object)payload);
        this.gpsService.save(payload);
    }

    @Bean
    @Scope(value="prototype")
    public MessageHandler mqttMessageHandler() {
        return new MessageHandler(){

            public void handleMessage(Message<?> message) throws MessagingException {
                String topic = (String)message.getHeaders().get((Object)"mqtt_receivedTopic");
                String payload = (String)message.getPayload();
                if (topic != null && payload != null) {
                    MqttDynamicConfig.this.handleMqttMessage(topic, payload);
                } else {
                    log.error("\u63a5\u6536\u5230\u7684\u6d88\u606f\u4e3b\u9898\u6216\u5185\u5bb9\u4e3a\u7a7a");
                }
            }
        };
    }
}

