/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.uc.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.rescue.base.manager.BizBaseRoadManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.model.BizBaseTeam;
import com.artfess.rescue.uc.dao.RescueOrgDao;
import com.artfess.rescue.uc.manager.RescueOrgManager;
import com.artfess.rescue.uc.model.Org;
import com.artfess.rescue.uc.vo.OrgInfoVO;
import com.artfess.rescue.uc.vo.OrganizeInfoVO;
import com.artfess.rescue.uc.vo.RoadSegmentLevelVO;
import com.artfess.rescue.utils.UserControlUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class RescueOrgManagerImpl
extends BaseManagerImpl<RescueOrgDao, Org>
implements RescueOrgManager {
    @Resource
    UserControlUtils userControlUtils;
    @Resource
    BizBaseRoadManager roadManager;
    final String FIRST_ORG_ID = "1766017468444450816";

    @Override
    public List<OrgInfoVO> orgTree() {
        String orgId = this.userControlUtils.getOrgGrade();
        List<String> orgIds = this.userControlUtils.getOrgIds(orgId);
        return ((RescueOrgDao)this.baseMapper).orgTree(orgIds);
    }

    @Override
    public List<OrgInfoVO> roadTree() {
        List<String> orgIds = this.userControlUtils.getOrgIds();
        return ((RescueOrgDao)this.baseMapper).roadTree(orgIds);
    }

    @Override
    public RoadSegmentLevelVO countRoadTree() {
        Org org = (Org)this.get((Serializable)((Object)"1766017468444450816"));
        if (org == null) {
            throw new BaseException("\u672a\u627e\u5230code\u4e3a100101\u7684\u7ec4\u7ec7\u8282\u70b9");
        }
        RoadSegmentLevelVO vo = new RoadSegmentLevelVO();
        vo.setName(org.getName());
        vo.setId(org.getId());
        vo.setParentId(org.getParentId());
        vo.setCode(org.getCode());
        List<String> orgIds = this.userControlUtils.getOrgIds();
        List<OrgInfoVO> orgList = ((RescueOrgDao)this.baseMapper).userRoadCountTree(orgIds);
        Integer sunNum = 0;
        vo.setChildren(orgList);
        if (!CollectionUtils.isEmpty(orgList)) {
            for (OrgInfoVO infoVO : orgList) {
                int totalMembers = Optional.ofNullable(infoVO.getTeamList()).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).mapToInt(BizBaseTeam::getMemberNum).sum();
                infoVO.setMemberNum(totalMembers);
                sunNum = sunNum + totalMembers;
            }
        }
        vo.setMemberNum(sunNum);
        return vo;
    }

    @Override
    public RoadSegmentLevelVO teamTree(String type) {
        Org org = (Org)this.get((Serializable)((Object)"1766017468444450816"));
        if (org == null) {
            throw new BaseException("\u672a\u627e\u5230code\u4e3a100101\u7684\u7ec4\u7ec7\u8282\u70b9");
        }
        RoadSegmentLevelVO vo = new RoadSegmentLevelVO();
        vo.setName(org.getName());
        vo.setId(org.getId());
        vo.setParentId(org.getParentId());
        vo.setCode(org.getCode());
        List<String> orgIds = this.userControlUtils.getOrgIds();
        List<OrgInfoVO> orgInfoVOS = ((RescueOrgDao)this.baseMapper).teamTree(orgIds, type);
        vo.setChildren(orgInfoVOS);
        return vo;
    }

    @Override
    public OrganizeInfoVO roadNode() {
        List<String> orgIds = this.userControlUtils.getOrgIds();
        orgIds.add("1766017468444450816");
        List<OrganizeInfoVO> orgList = ((RescueOrgDao)this.baseMapper).orgInfo(orgIds);
        List roadList = this.roadManager.list();
        Map<String, Map<String, List<OrganizeInfoVO>>> groupedOrgs = orgList.stream().collect(Collectors.groupingBy(OrganizeInfoVO::getGrade, Collectors.groupingBy(OrganizeInfoVO::getParentId)));
        Map<String, BizBaseRoad> roadNameMap = roadList.stream().filter(road -> road.getName() != null).collect(Collectors.toMap(BizBaseRoad::getName, Function.identity(), (existing, replacement) -> existing));
        OrganizeInfoVO rootOrg = orgList.stream().filter(o -> "100101".equals(o.getCode())).findFirst().orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230code\u4e3a100101\u7684\u7ec4\u7ec7\u8282\u70b9"));
        this.buildTreeAndMatchRoads(groupedOrgs, roadNameMap, rootOrg);
        return rootOrg;
    }

    @Override
    public OrganizeInfoVO orgNode() {
        List<String> orgIds = this.userControlUtils.getOrgIds();
        orgIds.add("1766017468444450816");
        List<OrganizeInfoVO> orgList = ((RescueOrgDao)this.baseMapper).orgInfo(orgIds);
        List roadList = this.roadManager.list();
        Map<String, Map<String, List<OrganizeInfoVO>>> groupedOrgs = orgList.stream().collect(Collectors.groupingBy(OrganizeInfoVO::getGrade, Collectors.groupingBy(OrganizeInfoVO::getParentId)));
        OrganizeInfoVO rootOrg = orgList.stream().filter(o -> "100101".equals(o.getCode())).findFirst().orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230code\u4e3a100101\u7684\u7ec4\u7ec7\u8282\u70b9"));
        Set roadNames = roadList.stream().map(BizBaseRoad::getName).filter(Objects::nonNull).collect(Collectors.toSet());
        Map grade3Map = groupedOrgs.getOrDefault("3", Collections.emptyMap());
        Map grade4Map = groupedOrgs.getOrDefault("4", Collections.emptyMap());
        Map grade5Map = groupedOrgs.getOrDefault("5", Collections.emptyMap());
        List<OrganizeInfoVO> filteredGrade3Orgs = grade3Map.values().stream().flatMap(Collection::stream).filter(grade3Org -> this.hasGrade5InRoads(grade3Org.getId(), grade4Map, grade5Map, roadNames)).collect(Collectors.toList());
        rootOrg.setChildren(filteredGrade3Orgs);
        return rootOrg;
    }

    private void buildTreeAndMatchRoads(Map<String, Map<String, List<OrganizeInfoVO>>> groupedOrgs, Map<String, BizBaseRoad> roadNameMap, OrganizeInfoVO parentOrg) {
        Map<String, List<OrganizeInfoVO>> grade3Map = groupedOrgs.get("3");
        if (grade3Map == null) {
            return;
        }
        List<OrganizeInfoVO> grade3Children = grade3Map.get(parentOrg.getId());
        if (grade3Children == null || grade3Children.isEmpty()) {
            return;
        }
        Map<String, List<OrganizeInfoVO>> grade4Map = groupedOrgs.get("4");
        Map<String, List<OrganizeInfoVO>> grade5Map = groupedOrgs.get("5");
        List<OrganizeInfoVO> filteredGrade3Children = grade3Children.stream().filter(grade3Child -> this.hasGrade5Children(grade4Map, grade5Map, grade3Child.getId())).peek(grade3Child -> this.setGrade5ChildrenWithRoadMatch(grade4Map, grade5Map, roadNameMap, (OrganizeInfoVO)grade3Child)).collect(Collectors.toList());
        parentOrg.setChildren(filteredGrade3Children);
    }

    private boolean hasGrade5Children(Map<String, List<OrganizeInfoVO>> grade4Map, Map<String, List<OrganizeInfoVO>> grade5Map, String grade3Id) {
        if (grade4Map == null || grade5Map == null) {
            return false;
        }
        List<OrganizeInfoVO> grade4Children = grade4Map.get(grade3Id);
        if (grade4Children == null) {
            return false;
        }
        return grade4Children.stream().anyMatch(grade4Child -> {
            List grade5Children = (List)grade5Map.get(grade4Child.getId());
            return grade5Children != null && !grade5Children.isEmpty();
        });
    }

    private void setGrade5ChildrenWithRoadMatch(Map<String, List<OrganizeInfoVO>> grade4Map, Map<String, List<OrganizeInfoVO>> grade5Map, Map<String, BizBaseRoad> roadNameMap, OrganizeInfoVO grade3Child) {
        List<OrganizeInfoVO> grade4Children;
        ArrayList<OrganizeInfoVO> finalChildren = new ArrayList<OrganizeInfoVO>();
        if (grade4Map != null && (grade4Children = grade4Map.get(grade3Child.getId())) != null) {
            for (OrganizeInfoVO grade4Child : grade4Children) {
                List<OrganizeInfoVO> grade5Children;
                if (grade5Map == null || (grade5Children = grade5Map.get(grade4Child.getId())) == null) continue;
                Iterator<OrganizeInfoVO> iterator = grade5Children.iterator();
                while (iterator.hasNext()) {
                    OrganizeInfoVO grade5Child = iterator.next();
                    if (!"dept".equals(grade5Child.getOrgKind())) continue;
                    BizBaseRoad matchedRoad = roadNameMap.get(grade5Child.getName());
                    if (matchedRoad != null) {
                        grade5Child.setId(matchedRoad.getId());
                        grade5Child.setCode(matchedRoad.getCode());
                        String originalPath = grade5Child.getPath();
                        String[] pathParts = originalPath.split("\\.");
                        if (pathParts.length >= 2) {
                            StringBuilder newPath = new StringBuilder();
                            for (int i = 0; i < pathParts.length - 2; ++i) {
                                if (i > 0) {
                                    newPath.append(".");
                                }
                                newPath.append(pathParts[i]);
                            }
                            if (newPath.length() > 0) {
                                newPath.append(".");
                            }
                            newPath.append(grade5Child.getId());
                            grade5Child.setPath(newPath.toString());
                            continue;
                        }
                        grade5Child.setPath(grade5Child.getId());
                        continue;
                    }
                    iterator.remove();
                }
                finalChildren.addAll(grade5Children);
            }
        }
        grade3Child.setChildren(finalChildren);
    }

    private boolean hasGrade5InRoads(String grade3Id, Map<String, List<OrganizeInfoVO>> grade4Map, Map<String, List<OrganizeInfoVO>> grade5Map, Set<String> roadNames) {
        List<OrganizeInfoVO> grade4Children = grade4Map.get(grade3Id);
        if (grade4Children == null || grade4Children.isEmpty()) {
            return false;
        }
        for (OrganizeInfoVO grade4Child : grade4Children) {
            List<OrganizeInfoVO> grade5Children = grade5Map.get(grade4Child.getId());
            if (grade5Children == null) continue;
            for (OrganizeInfoVO grade5Child : grade5Children) {
                if (grade5Child.getName() == null || !roadNames.contains(grade5Child.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

