/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.rescue.uc.manager.RescueOrgManager;
import com.artfess.rescue.uc.vo.OrgInfoVO;
import com.artfess.rescue.uc.vo.OrganizeInfoVO;
import com.artfess.rescue.uc.vo.RoadSegmentLevelVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/org/"})
@Api(tags={"\u7ec4\u7ec7\u7ba1\u7406"})
@ApiGroup(group={"group_biz_rescue"})
public class RescueOrgController {
    @Resource
    RescueOrgManager orgManager;

    @GetMapping(value={"/orgTree"})
    @ApiOperation(value="\u7ec4\u7ec7\u6811")
    public CommonResult<?> orgTree() {
        List<OrgInfoVO> orgs = this.orgManager.orgTree();
        return CommonResult.success(orgs, (String)"");
    }

    @GetMapping(value={"/roadTree"})
    @ApiOperation(value="\u7ec4\u7ec7\u8def\u6bb5\u6811")
    public CommonResult<?> roadTree() {
        List<OrgInfoVO> orgs = this.orgManager.roadTree();
        return CommonResult.success(orgs, (String)"");
    }

    @GetMapping(value={"/into/roadTree"})
    @ApiOperation(value="\u65b0\u7248-\u7ec4\u7ec7\u8def\u6bb5\u6811")
    public CommonResult<?> roadNode() {
        OrganizeInfoVO vos = this.orgManager.roadNode();
        return CommonResult.success((Object)vos, (String)"");
    }

    @GetMapping(value={"/into/orgTree"})
    @ApiOperation(value="\u65b0\u7248-\u7ec4\u7ec7\u6811")
    public CommonResult<?> orgNode() {
        OrganizeInfoVO vos = this.orgManager.orgNode();
        return CommonResult.success((Object)vos, (String)"");
    }

    @GetMapping(value={"/teamTree"})
    @ApiOperation(value="\u7ec4\u7ec7\u961f\u4f0d\u6811")
    public CommonResult<?> teamTree(@RequestParam(required=false, value="type") String type) {
        RoadSegmentLevelVO vo = this.orgManager.teamTree(type);
        return CommonResult.success((Object)vo, (String)"");
    }

    @GetMapping(value={"/countTeamTree"})
    @ApiOperation(value="\u7ec4\u7ec7\u8def\u6bb5\u6811-\u7edf\u8ba1\u4eba\u5458")
    public CommonResult<?> countRoadTree() {
        return CommonResult.success((Object)this.orgManager.countRoadTree(), (String)"");
    }
}

