/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.rescue.file.manager.BizRescueFileCommonManager;
import com.artfess.rescue.file.model.BizRescueFileCommon;
import com.artfess.rescue.patrol.dao.BizInspectionVideoDao;
import com.artfess.rescue.patrol.dto.VideoInspectErrorDTO;
import com.artfess.rescue.patrol.manager.BizInspectionVideoManager;
import com.artfess.rescue.patrol.model.BizInspectionVideo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizInspectionVideoManagerImpl
extends BaseManagerImpl<BizInspectionVideoDao, BizInspectionVideo>
implements BizInspectionVideoManager {
    @Resource
    private BaseContext baseContext;
    @Resource
    private BizRescueFileCommonManager rescueFileManager;
    @Resource
    private FileManager fileManager;
    @Resource
    private UCFeignService feignService;
    private static final String FILE_TYPE = "video_abnormal";

    @Override
    public List<BizInspectionVideo> getVideoTaskStatus(String taskId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizInspectionVideo::getTaskId, (Object)taskId);
        queryWrapper.orderByDesc(BizInspectionVideo::getRank);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> inspect(String userId, Integer time, List<String> ids) {
        String inspectUserId = StringUtil.isNotEmpty((String)userId) ? userId : this.baseContext.getCurrentUserId();
        CommonResult userNode = this.feignService.getUserById(inspectUserId);
        JsonNode user = (JsonNode)userNode.getValue();
        String inspectUserName = JsonUtil.getString((JsonNode)user, (String)"fullname");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BizInspectionVideo::getId, ids);
        List inspectionVideos = this.list((Wrapper)queryWrapper);
        LocalDateTime now = LocalDateTime.now();
        inspectionVideos.forEach(videoResult -> {
            videoResult.setInspectUserId(inspectUserId);
            videoResult.setInspectUserName(inspectUserName);
            videoResult.setStartTime(now);
            videoResult.setEndTime(now.plusSeconds(time.intValue()));
            videoResult.setTaskStatus(1);
            videoResult.setInspecetStatus(0);
        });
        boolean result = this.updateBatchById(inspectionVideos);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> inspectError(VideoInspectErrorDTO dto) {
        String inspectUserId = this.baseContext.getCurrentUserId();
        String inspectUserName = this.baseContext.getCurrentUserName();
        BizInspectionVideo inspectionVideoInfo = (BizInspectionVideo)((Object)this.getById((Serializable)((Object)dto.getId())));
        inspectionVideoInfo.setInspectUserId(inspectUserId);
        inspectionVideoInfo.setInspectUserName(inspectUserName);
        inspectionVideoInfo.setInspecetStatus(1);
        inspectionVideoInfo.setTaskStatus(1);
        inspectionVideoInfo.setAbnormalTime(dto.getAbnormalTime());
        inspectionVideoInfo.setInspectInfo(dto.getInspectInfo());
        List fileIds = dto.getFileList().stream().map(BizRescueFileCommon::getCommonId).collect(Collectors.toList());
        this.fileManager.updateFileBizIdByIds(fileIds, inspectionVideoInfo.getId());
        boolean result = this.updateById((Object)inspectionVideoInfo);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @Override
    public BizInspectionVideo getInfoById(String id) {
        BizInspectionVideo inspectionVideoInfo = (BizInspectionVideo)((Object)this.getById((Serializable)((Object)id)));
        if (Objects.isNull((Object)inspectionVideoInfo)) {
            return new BizInspectionVideo();
        }
        List<BizRescueFileCommon> fileList = this.rescueFileManager.getFileByCommonId(inspectionVideoInfo.getId());
        inspectionVideoInfo.setFileList(fileList);
        return inspectionVideoInfo;
    }
}

