/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.monitor.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.redis.util.RedisUtil;
import com.artfess.rescue.base.manager.BizBaseRoadManager;
import com.artfess.rescue.base.manager.BizOrgReflectionManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.model.BizOrgReflection;
import com.artfess.rescue.common.util.PointUtil;
import com.artfess.rescue.monitor.dao.BizEarlyWarningManagementDao;
import com.artfess.rescue.monitor.dto.EarlyWarningConfirmationDto;
import com.artfess.rescue.monitor.eunms.AlertColor;
import com.artfess.rescue.monitor.eunms.RefreshType;
import com.artfess.rescue.monitor.manager.BizEarlyWarningCallManagementManager;
import com.artfess.rescue.monitor.manager.BizEarlyWarningManagementManager;
import com.artfess.rescue.monitor.model.BizEarlyWarningCallManagement;
import com.artfess.rescue.monitor.model.BizEarlyWarningManagement;
import com.artfess.rescue.monitor.utils.MessageUtil;
import com.artfess.rescue.monitor.vo.EarlyWarningExportVo;
import com.artfess.rescue.monitor.vo.MonitorRegionalVo;
import com.artfess.rescue.uc.manager.RescueOrgManager;
import com.artfess.rescue.uc.model.Org;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.vo.DictionaryDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BizEarlyWarningManagementManagerImpl
extends BaseManagerImpl<BizEarlyWarningManagementDao, BizEarlyWarningManagement>
implements BizEarlyWarningManagementManager {
    @Resource
    private PointUtil pointUtil;
    @Resource
    private BizBaseRoadManager roadManager;
    @Resource
    private RescueOrgManager orgManager;
    @Resource
    private SysDictionaryDetailManager sysDictionaryDetailManager;
    @Resource
    private BizEarlyWarningCallManagementManager callManagementManager;
    @Resource
    private BizOrgReflectionManager orgReflectionManager;
    @Resource
    private RedisUtil redisUtil;
    private static final String API_KEY = "wPHg9E23YPxuDBfP";
    private static final String PARAMETERS = "?alert=true&hourlysteps=2";
    private static final String CACHE_KEY = "bpm:early";
    private static final int CACHE_EXPIRE_TIME = 172800;
    private static final int BATCH_SIZE = 500;

    public void create(BizEarlyWarningManagement bizEarlyWarningManagement) {
        this.setLngAndLat(bizEarlyWarningManagement);
        super.create((Model)bizEarlyWarningManagement);
    }

    public boolean save(BizEarlyWarningManagement bizEarlyWarningManagement) {
        this.setLngAndLat(bizEarlyWarningManagement);
        return super.save((Object)bizEarlyWarningManagement);
    }

    public void update(BizEarlyWarningManagement bizEarlyWarningManagement) {
        this.setLngAndLat(bizEarlyWarningManagement);
        super.update((Model)bizEarlyWarningManagement);
    }

    private void setLngAndLat(BizEarlyWarningManagement bizEarlyWarningManagement) {
        String roadCode = bizEarlyWarningManagement.getRoadCode();
        String direction = bizEarlyWarningManagement.getDirection();
        String startPegVal = bizEarlyWarningManagement.getPegSVal();
        if (StringUtils.isNotEmpty((CharSequence)startPegVal)) {
            Gson gson;
            Map locationMap;
            Double stakeNum = this.parseStakeNumber(startPegVal);
            direction = "2".equalsIgnoreCase(direction) ? direction : "1";
            String str = this.pointUtil.mappingPoint("02", roadCode, stakeNum, direction);
            if (StringUtils.isNotBlank((CharSequence)str) && (locationMap = (Map)(gson = new Gson()).fromJson(str, Map.class)) != null) {
                try {
                    Double lng = (Double)locationMap.get("lon");
                    Double lat = (Double)locationMap.get("lat");
                    if (lng != null && lat != null) {
                        bizEarlyWarningManagement.setLng(lng);
                        bizEarlyWarningManagement.setLat(lat);
                    }
                }
                catch (Exception e) {
                    System.err.println("\u89e3\u6790\u7ecf\u7eac\u5ea6\u65f6\u51fa\u73b0\u9519\u8bef: " + e.getMessage());
                }
            }
        }
    }

    private Double parseStakeNumber(String pegVal) throws IllegalArgumentException {
        if (!pegVal.matches("^[Kk]?\\d+([+\\-]\\d+)?$")) {
            throw new IllegalArgumentException("\u8f93\u5165\u7684\u6869\u53f7\u4e0d\u7b26\u5408\u8981\u6c42 " + pegVal);
        }
        return Double.valueOf(pegVal.replaceAll("[Kk]", "").replaceAll("[+\\-]", "."));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<BizEarlyWarningManagement> list, String roadId, String belongAreaId) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        BizBaseRoad bizBaseRoad = (BizBaseRoad)this.roadManager.get((Serializable)((Object)roadId));
        if (bizBaseRoad == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5f53\u524d\u8def\u6bb5");
        }
        Org org = (Org)this.orgManager.get((Serializable)((Object)belongAreaId));
        if (org == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5f53\u524d\u533a\u57df");
        }
        String roadName = bizBaseRoad.getName();
        String roadCode = bizBaseRoad.getCode();
        String orgName = org.getName();
        String orgCode = org.getCode();
        for (BizEarlyWarningManagement l : list) {
            l.setRoadId(roadId);
            l.setRoadName(roadName);
            l.setRoadCode(roadCode);
            l.setBelongAreaId(belongAreaId);
            l.setBelongAreaName(orgName);
            l.setBelongAreaCode(orgCode);
            l.setPubStatus(1);
            this.setLngAndLat(l);
        }
        return this.saveBatch(list);
    }

    @Override
    public void export(HttpServletResponse response, QueryFilter<BizEarlyWarningManagement> queryFilter) throws Exception {
        PageList query = this.query(queryFilter);
        List rows = query.getRows();
        if (Objects.isNull(rows)) {
            throw new RuntimeException("\u65e0\u6570\u636e\u5bfc\u51fa");
        }
        ArrayList<EarlyWarningExportVo> voList = new ArrayList<EarlyWarningExportVo>();
        int num = 1;
        Map yjdj = this.sysDictionaryDetailManager.getTextByMap("yxjc-yjdj");
        Map yjlx = this.sysDictionaryDetailManager.getTextByMap("yxjc-yjlx");
        Map fx = this.sysDictionaryDetailManager.getTextByMap("yxjc-fx");
        for (BizEarlyWarningManagement e : rows) {
            DictionaryDetailVo detailVo;
            EarlyWarningExportVo exportVo = new EarlyWarningExportVo();
            if (fx != null && e.getDirection() != null && fx.get(e.getDirection()) != null) {
                detailVo = (DictionaryDetailVo)fx.get(e.getDirection());
                exportVo.setDirection(detailVo.getName());
            }
            if (yjdj != null && e.getWarningLevel() != null && yjdj.get(e.getWarningLevel().toString()) != null) {
                detailVo = (DictionaryDetailVo)yjdj.get(e.getWarningLevel().toString());
                exportVo.setWarningLevel(detailVo.getName());
            }
            if (yjlx != null && e.getWarningType() != null && yjlx.get(e.getWarningType().toString()) != null) {
                detailVo = (DictionaryDetailVo)yjlx.get(e.getWarningType().toString());
                exportVo.setWarningType(detailVo.getName());
            }
            exportVo.setNo(num);
            if (e.getWarningTime() != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String formattedDate = e.getWarningTime().format(formatter);
                exportVo.setWarningTime(formattedDate);
            }
            exportVo.setStartPegVal(e.getPegSVal());
            exportVo.setEndPegVal(e.getPegEVal());
            exportVo.setLocationCatUncle(e.getLocationCatUncle());
            exportVo.setWarningContent(e.getWarningContent());
            exportVo.setPublishDeviceName(e.getPublishDeviceName());
            exportVo.setPublishDeviceType(e.getPublishDeviceType());
            exportVo.setNationalStandardCode(e.getNationalStandardCode());
            exportVo.setForwardObject(e.getForwardObject());
            exportVo.setRelieveWarningTime(e.getRelieveWarningTime());
            exportVo.setRegionalName(e.getRegionalName());
            exportVo.setRegionalName(e.getRegionalName());
            ++num;
            voList.add(exportVo);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("list", voList);
        TemplateExportParams params = new TemplateExportParams("model/warnExport.xlsx", new Integer[0]);
        String fileName = "\u9884\u8b66\u4fe1\u606f\u5bfc\u51fa.xlsx";
        this.exportExcelWorkbook(fileName, params, map, response);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cyWeather() {
        List<MonitorRegionalVo> regionalAllList = ((BizEarlyWarningManagementDao)this.baseMapper).getRegional(null);
        List regionalList = regionalAllList.stream().filter(r -> r.getAdcode() != null && r.getRoadId() != null).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(regionalList)) {
            return;
        }
        HashSet<String> existingAlertIds = new HashSet<String>(this.getAlertIds());
        ArrayList<BizEarlyWarningManagement> allNewWarnings = new ArrayList<BizEarlyWarningManagement>();
        for (MonitorRegionalVo region : regionalList) {
            this.processRegion(region, existingAlertIds, allNewWarnings);
        }
        if (!allNewWarnings.isEmpty()) {
            this.saveWarningsInBatches(allNewWarnings);
            List<BizEarlyWarningManagement> collect = allNewWarnings.stream().filter(m -> m.getWarningValue() == null || m.getWarningValue() != null && !m.getWarningValue().equals("07")).collect(Collectors.toList());
            if (!collect.isEmpty()) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                List orgReflections = this.orgReflectionManager.list((Wrapper)wrapper);
                Map<String, List<BizOrgReflection>> listMap = orgReflections.stream().filter(o -> o.getRoadId() != null).collect(Collectors.groupingBy(BizOrgReflection::getRoadId));
                this.bathSaveCallEarly(collect, listMap);
            }
            existingAlertIds.addAll(allNewWarnings.stream().map(BizEarlyWarningManagement::getAlertId).collect(Collectors.toList()));
            this.redisUtil.set(CACHE_KEY, new ArrayList<String>(existingAlertIds), 172800L);
            MessageUtil.sendWebSocketMessage(RefreshType.YJXX.toString(), "ADD", null);
        }
    }

    boolean bathSaveCallEarly(List<BizEarlyWarningManagement> allNewWarnings, Map<String, List<BizOrgReflection>> listMap) {
        ArrayList<BizEarlyWarningCallManagement> callManagements = new ArrayList<BizEarlyWarningCallManagement>();
        for (BizEarlyWarningManagement e : allNewWarnings) {
            String group;
            Pattern pattern;
            Matcher matcher;
            List<BizOrgReflection> reflectionList;
            BizEarlyWarningCallManagement call = new BizEarlyWarningCallManagement();
            call.setPubStatus(0);
            call.setEarlyId(e.getId());
            call.setRoadId(e.getRoadId());
            call.setRoadName(e.getRoadName());
            call.setRoadCode(e.getRoadCode());
            call.setWarningTime(e.getWarningTime());
            call.setWarningLevel(e.getWarningLevel());
            call.setWarningChannel(e.getPublishDeviceName());
            call.setWarningContent(e.getWarningContent());
            call.setLat(e.getLat());
            call.setLng(e.getLng());
            call.setPegEVal(e.getPegEVal());
            call.setPegSVal(e.getPegSVal());
            call.setResponseMechanism("0");
            call.setWarningType(e.getWarningType());
            call.setWarningValue(e.getWarningValue());
            call.setRegionalCode(e.getRegionalCode());
            call.setRegionalName(e.getRegionalName());
            if (listMap != null && (reflectionList = listMap.get(e.getRoadId())) != null && !reflectionList.isEmpty()) {
                call.setProvince(reflectionList.get(0).getProvince());
            }
            if ((matcher = (pattern = Pattern.compile("^(.*?\u6c14\u8c61\u53f0)")).matcher(e.getWarningContent())).find() && StringUtils.isNotEmpty((CharSequence)(group = matcher.group(1)))) {
                call.setWarningUnit(group);
                call.setWarnRange(group.replace("\u6c14\u8c61\u53f0", ""));
            }
            callManagements.add(call);
        }
        return this.callManagementManager.saveBatch(callManagements);
    }

    @Override
    public JSONObject getRegional(String roadId) {
        JSONObject object = new JSONObject();
        List<MonitorRegionalVo> regional = ((BizEarlyWarningManagementDao)this.baseMapper).getRegional(roadId);
        if (regional != null && !regional.isEmpty()) {
            object.put("regional", regional.stream().distinct().collect(Collectors.toList()));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizOrgReflection::getRoadId, (Object)roadId);
        wrapper.last("LIMIT 1");
        BizOrgReflection orgReflection = (BizOrgReflection)((Object)this.orgReflectionManager.getOne((Wrapper)wrapper));
        if (orgReflection != null) {
            object.put("province", (Object)orgReflection.getProvince());
        }
        return object;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean bhConfirmation(EarlyWarningConfirmationDto dto) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BizEarlyWarningManagement::getId, dto.getIds());
        updateWrapper.set(BizEarlyWarningManagement::getPublishDeviceName, (Object)dto.getPublishDeviceName());
        updateWrapper.set(BizEarlyWarningManagement::getPublishDeviceType, (Object)dto.getPublishDeviceType());
        updateWrapper.set(BizEarlyWarningManagement::getDirection, (Object)dto.getDirection());
        updateWrapper.set(BizEarlyWarningManagement::getPubStatus, (Object)1);
        boolean update = this.update((Wrapper)updateWrapper);
        return update;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean publish(BizEarlyWarningManagement e) {
        e.setPubStatus(1);
        boolean update = this.saveOrUpdate((Object)e);
        return update;
    }

    private void processRegion(MonitorRegionalVo region, Set<String> existingAlertIds, List<BizEarlyWarningManagement> allNewWarnings) {
        String url = String.format("https://api.caiyunapp.com/v2.6/%s/%s,%s/hourly%s", API_KEY, region.getLng(), region.getLat(), PARAMETERS);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet request = new HttpGet(url);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    return;
                }
                ObjectMapper mapper = new ObjectMapper();
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                JsonNode root = mapper.readTree(result);
                JsonNode content = root.path("result").path("alert").path("content");
                if (content.isArray()) {
                    for (JsonNode alertItem : content) {
                        BizEarlyWarningManagement warning;
                        String alertId = alertItem.path("alertId").asText();
                        if (existingAlertIds.contains(alertId) || (warning = this.parseAlertItem(alertItem, region)) == null) continue;
                        warning.setAlertId(alertId);
                        allNewWarnings.add(warning);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }

    private BizEarlyWarningManagement parseAlertItem(JsonNode alertItem, MonitorRegionalVo region) {
        try {
            JsonNode latlon;
            long timestamp = alertItem.path("pubtimestamp").asLong();
            LocalDateTime dateTime = BizEarlyWarningManagementManagerImpl.convertTimestampToLocalDateTime(timestamp);
            BizEarlyWarningManagement management = new BizEarlyWarningManagement();
            management.setRoadName(region.getRoadName());
            management.setRoadId(region.getRoadId());
            management.setRoadCode(region.getRoadCode());
            management.setWarningTime(dateTime);
            management.setWarningType(1);
            management.setPegSVal(region.getPegSVal());
            management.setPegEVal(region.getPegEVal());
            management.setRegionalCode(region.getAdcode());
            management.setRegionalName(region.getAdname());
            String code = alertItem.path("code").asText();
            if (StringUtils.isNotEmpty((CharSequence)code) && code.length() >= 4) {
                String lastTwo = code.substring(code.length() - 2);
                management.setWarningLevel(AlertColor.getNameByCode(lastTwo));
                String firstTwo = code.substring(0, 2);
                management.setWarningValue(firstTwo);
            }
            if ((latlon = alertItem.path("latlon")).isArray() && latlon.size() >= 2) {
                double lat = latlon.get(0).asDouble();
                double lon = latlon.get(1).asDouble();
                management.setLng(lon);
                management.setLat(lat);
            }
            management.setLocationCatUncle(alertItem.path("location").asText());
            management.setWarningContent(alertItem.path("description").asText());
            management.setPublishDeviceName("\u4e2d\u56fd\u6c14\u8c61APP");
            management.setPubStatus(0);
            management.setData(alertItem.toString());
            return management;
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            return null;
        }
    }

    private List<String> getAlertIds() {
        List alertIds = (List)this.redisUtil.get(CACHE_KEY);
        if (!CollectionUtils.isEmpty((Collection)alertIds)) {
            return alertIds;
        }
        LocalDateTime threeMonthsAgo = LocalDateTime.now().minusMonths(3L);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.ge(BizEarlyWarningManagement::getWarningTime, (Object)threeMonthsAgo)).isNotNull(BizEarlyWarningManagement::getAlertId);
        return this.list((Wrapper)wrapper).stream().map(BizEarlyWarningManagement::getAlertId).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void saveWarningsInBatches(List<BizEarlyWarningManagement> warnings) {
        for (int i = 0; i < warnings.size(); i += 500) {
            List<BizEarlyWarningManagement> batch = warnings.subList(i, Math.min(i + 500, warnings.size()));
            try {
                this.saveBatch(batch);
                continue;
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
                batch.forEach(w -> {
                    try {
                        this.save((BizEarlyWarningManagement)((Object)w));
                    }
                    catch (Exception ex) {
                        this.log.error(ex.getMessage());
                    }
                });
            }
        }
    }

    public static LocalDateTime convertTimestampToLocalDateTime(long timestamp) {
        return Instant.ofEpochSecond(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcelWorkbook(String fileName, TemplateExportParams params, Map<String, Object> map, HttpServletResponse response) {
        OutputStream os = null;
        try {
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
            String encodedFileName = URLEncoder.encode(fileName, "utf-8");
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "attachment; filename=" + encodedFileName);
            response.addHeader("fileName", encodedFileName);
            os = response.getOutputStream();
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25\uff01");
                }
            }
        }
    }
}

