/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.manager.impl;

import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.common.util.ExcelUtil;
import com.artfess.rescue.event.dao.BizRescueInfoDao;
import com.artfess.rescue.event.manager.BizRescueCarManager;
import com.artfess.rescue.event.manager.BizRescueCostManager;
import com.artfess.rescue.event.manager.BizRescueDispatchManager;
import com.artfess.rescue.event.manager.BizRescueHandleManager;
import com.artfess.rescue.event.manager.BizRescueInfoManager;
import com.artfess.rescue.event.model.BizRescueCar;
import com.artfess.rescue.event.model.BizRescueCost;
import com.artfess.rescue.event.model.BizRescueDispatch;
import com.artfess.rescue.event.model.BizRescueHandle;
import com.artfess.rescue.event.model.BizRescueInfo;
import com.artfess.rescue.event.vo.CountRescueByRoadVO;
import com.artfess.rescue.event.vo.CountRescueByUserVO;
import com.artfess.rescue.event.vo.RescueLedgerVO;
import com.artfess.rescue.file.manager.BizRescueFileCommonManager;
import com.artfess.rescue.file.model.BizRescueFileCommon;
import com.artfess.rescue.uc.manager.RescueOrgManager;
import com.artfess.rescue.uc.vo.OrgInfoVO;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizRescueInfoManagerImpl
extends BaseManagerImpl<BizRescueInfoDao, BizRescueInfo>
implements BizRescueInfoManager {
    @Resource
    BizRescueHandleManager handleManager;
    @Resource
    BizRescueDispatchManager dispatchManager;
    @Resource
    BizRescueCostManager costManager;
    @Resource
    SysDictionaryManager sdm;
    @Resource
    BaseContext baseContext;
    @Resource
    BizRescueCarManager carManager;
    @Resource
    BizRescueFileCommonManager fileCommonManager;
    @Resource
    SysIdentityManager sysIdentityManager;
    @Resource
    private RescueOrgManager rescueOrgManager;

    @Override
    public int countByEventId(String eventId, List<Integer> status) {
        LambdaQueryWrapper lambdaWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaWrapper.eq(BizRescueInfo::getEventId, (Object)eventId)).in(BizRescueInfo::getRescueStatus, status)).eq(BizRescueInfo::getIsDele, (Object)"0");
        return this.count((Wrapper)lambdaWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizRescueInfo entity) {
        String rescueNo = this.sysIdentityManager.nextId("jydjh");
        entity.setRescueNo(rescueNo);
        entity.setRescueStatus(-1);
        boolean save = this.save((Object)entity);
        if (!save) {
            return false;
        }
        int count = this.handleManager.countNode(entity.getId(), "1");
        if (count < 1) {
            BizRescueHandle handle = this.setUser(entity.getId(), "1", LocalDateTime.now());
            this.handleManager.save((Object)handle);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizRescueInfo entity) {
        int count;
        boolean update = this.updateById((Object)entity);
        if (!update) {
            return false;
        }
        if (entity.getRescueStatus() == -1 && (count = this.handleManager.countNode(entity.getId(), "1")) < 1) {
            BizRescueHandle handle = this.setUser(entity.getId(), "1", LocalDateTime.now());
            this.handleManager.save((Object)handle);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean appoint(BizRescueInfo entity) {
        List<BizRescueDispatch> dispatch = entity.getDispatches();
        if (dispatch == null) {
            return false;
        }
        if (entity.getRescueNo() == null) {
            String rescueNo = this.sysIdentityManager.nextId("jydjh");
            entity.setRescueNo(rescueNo);
        }
        entity.setRescueStatus(1);
        boolean update = super.saveOrUpdate((Object)entity);
        if (!update) {
            return false;
        }
        dispatch.forEach(user -> {
            user.setDispatchTime(LocalDateTime.now());
            user.setRescueId(entity.getId());
            user.setDispatchTeamId(entity.getTeamId());
        });
        this.dispatchManager.saveBatch(dispatch);
        BizRescueCar car = entity.getCar();
        if (car != null && StringUtils.isNotEmpty((CharSequence)car.getDispatchCarCode())) {
            car.setId(null);
            car.setRescueId(entity.getId());
            car.setDispatchTime(LocalDateTime.now());
            this.carManager.save((Object)car);
        }
        ArrayList<BizRescueHandle> bizRescueHandles = new ArrayList<BizRescueHandle>();
        LocalDateTime now = LocalDateTime.now();
        int countBcNode = this.handleManager.countNode(entity.getId(), "1");
        if (countBcNode < 1) {
            BizRescueHandle handleOne = this.setUser(entity.getId(), "1", now);
            bizRescueHandles.add(handleOne);
            BizRescueHandle handleTwo = this.setUser(entity.getId(), "2", now.plusSeconds(1L));
            bizRescueHandles.add(handleTwo);
        } else {
            BizRescueHandle handleTwo = this.setUser(entity.getId(), "2", now);
            bizRescueHandles.add(handleTwo);
        }
        this.handleManager.saveBatch(bizRescueHandles);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean cancel(String id) {
        BizRescueInfo rescueInfo = (BizRescueInfo)((Object)super.getById((Serializable)((Object)id)));
        if (rescueInfo == null) {
            throw new BaseException("\u672a\u627e\u5230\u8be5\u4e8b\u4ef6!!!");
        }
        if (rescueInfo.getRescueStatus() == null) {
            throw new BaseException("\u8be5\u4e8b\u4ef6\u672a\u8fdb\u884c\u64cd\u4f5c\uff0c\u65e0\u6cd5\u64a4\u56de!!!");
        }
        if (rescueInfo.getRescueStatus() > 1) {
            throw new BaseException("\u8be5\u4e8b\u4ef6\u5df2\u8fdb\u5165\u6d41\u7a0b\uff0c\u65e0\u6cd5\u64a4\u56de!!!");
        }
        rescueInfo.setRescueStatus(-1);
        boolean update = super.updateById((Object)rescueInfo);
        if (!update) {
            return false;
        }
        LambdaQueryWrapper handWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)handWrapper.eq(BizRescueHandle::getRescueId, (Object)rescueInfo.getId())).eq(BizRescueHandle::getIsDele, (Object)"0");
        this.handleManager.remove((Wrapper)handWrapper);
        LambdaQueryWrapper dispatchWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)dispatchWrapper.eq(BizRescueDispatch::getRescueId, (Object)rescueInfo.getId())).eq(BizRescueDispatch::getIsDele, (Object)"0");
        this.dispatchManager.remove((Wrapper)dispatchWrapper);
        LambdaQueryWrapper carWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)carWrapper.eq(BizRescueCar::getRescueId, (Object)rescueInfo.getId())).eq(BizRescueCar::getIsDele, (Object)"0");
        this.carManager.remove((Wrapper)carWrapper);
        return true;
    }

    @Override
    public BizRescueInfo getDetailById(String id) {
        BizRescueInfo entity = ((BizRescueInfoDao)this.baseMapper).findById(id);
        if (entity == null) {
            return null;
        }
        if (entity.getRescueStatus() < 1) {
            return entity;
        }
        entity = this.setExpandInfo(entity);
        return entity;
    }

    @Override
    public List<BizRescueInfo> getDetailByEventId(String eventId) {
        LambdaQueryWrapper rescueInfoWrapper = new LambdaQueryWrapper();
        rescueInfoWrapper.eq(BizRescueInfo::getEventId, (Object)eventId);
        rescueInfoWrapper.eq(BizRescueInfo::getIsDele, (Object)"0");
        List list = super.list((Wrapper)rescueInfoWrapper);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        list.forEach(p -> {
            p = this.setExpandInfo((BizRescueInfo)((Object)p));
        });
        return list;
    }

    BizRescueInfo setExpandInfo(BizRescueInfo entity) {
        LambdaQueryWrapper handleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)handleWrapper.eq(BizRescueHandle::getRescueId, (Object)entity.getId())).eq(BizRescueHandle::getIsDele, (Object)"0")).orderByDesc((Object[])new SFunction[]{BizRescueHandle::getHandleTime, BizRescueHandle::getRescueNode});
        List handles = this.handleManager.list((Wrapper)handleWrapper);
        if (handles == null) {
            throw new BaseException("\u5b58\u5728\u672a\u8bb0\u5f55\u6570\u636e\u60c5\u51b5!!!");
        }
        entity.setHandles(handles);
        List<String> fileCommonIds = handles.stream().map(BizRescueHandle::getId).collect(Collectors.toList());
        if (!fileCommonIds.isEmpty()) {
            Map<String, List<BizRescueFileCommon>> map = this.fileCommonManager.getFilePreviewLikeCommonIds(fileCommonIds).stream().collect(Collectors.groupingBy(BizRescueFileCommon::getCommonId));
            handles.forEach(file -> file.setFiles((List)map.get(file.getId())));
        }
        LambdaQueryWrapper carWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)carWrapper.eq(BizRescueCar::getRescueId, (Object)entity.getId())).last("limit 1");
        BizRescueCar car = (BizRescueCar)((Object)this.carManager.getOne((Wrapper)carWrapper));
        entity.setCar(car);
        LambdaQueryWrapper dispatchWrapper = new LambdaQueryWrapper();
        dispatchWrapper.eq(BizRescueDispatch::getRescueId, (Object)entity.getId());
        List dispatch = this.dispatchManager.list((Wrapper)dispatchWrapper);
        entity.setDispatches(dispatch);
        LambdaQueryWrapper costWrapper = new LambdaQueryWrapper();
        costWrapper.eq(BizRescueCost::getRescueId, (Object)entity.getId());
        costWrapper.eq(BizRescueCost::getIsDele, (Object)"0");
        List costs = this.costManager.list((Wrapper)costWrapper);
        entity.setCosts(costs);
        return entity;
    }

    @Override
    public PageList<BizRescueInfo> queryByPower(QueryFilter<BizRescueInfo> queryFilter) {
        queryFilter.addFilter("r.is_dele_", (Object)"0", QueryOP.EQUAL);
        String userId = this.baseContext.getCurrentUserId();
        if (userId == null) {
            throw new BaseException("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!this.baseContext.isAdmin().booleanValue()) {
            IPage<BizRescueInfo> page = ((BizRescueInfoDao)this.baseMapper).queryByPower((IPage<BizRescueInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizRescueInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()), userId);
            return new PageList(page);
        }
        IPage<BizRescueInfo> page = ((BizRescueInfoDao)this.baseMapper).queryByNo((IPage<BizRescueInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizRescueInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(page);
    }

    @Override
    public PageList<BizRescueInfo> queryByAppraise(QueryFilter<BizRescueInfo> queryFilter) {
        queryFilter.addFilter("r.is_dele_", (Object)"0", QueryOP.EQUAL);
        IPage<BizRescueInfo> page = ((BizRescueInfoDao)this.baseMapper).queryByAppraise((IPage<BizRescueInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizRescueInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeBath(List<String> rescueIds) {
        LambdaQueryWrapper rescueHandleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)rescueHandleWrapper.in(BizRescueHandle::getRescueId, rescueIds)).eq(BizRescueHandle::getIsDele, (Object)"0");
        boolean remove = this.handleManager.remove((Wrapper)rescueHandleWrapper);
        if (!remove) {
            throw new BaseException("\u5904\u7f6e\u60c5\u51b5\u5220\u9664\u5931\u8d25");
        }
        LambdaQueryWrapper dispatchWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)dispatchWrapper.in(BizRescueDispatch::getRescueId, rescueIds)).eq(BizRescueDispatch::getIsDele, (Object)"0");
        boolean removeDispatch = this.dispatchManager.remove((Wrapper)dispatchWrapper);
        if (!removeDispatch) {
            throw new BaseException("\u5904\u7f6e\u60c5\u51b5\u5220\u9664\u5931\u8d25");
        }
        boolean removeId = this.removeByIds(rescueIds);
        if (!removeId) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return true;
    }

    @Override
    public PageList<BizRescueInfo> pushTaskList(QueryFilter<BizRescueInfo> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("rescue_status_", Arrays.asList(1, 2, 4), QueryOP.IN);
        IPage<BizRescueInfo> iPage = ((BizRescueInfoDao)this.baseMapper).queryByWorkbench((IPage<BizRescueInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizRescueInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public CommonResult<List<CountRescueByUserVO>> countByUser(QueryFilter<BizRescueInfo> queryFilter) {
        return null;
    }

    @Override
    public CommonResult<JSONObject> countByRoad(QueryFilter<BizRescueInfo> queryFilter) {
        JSONObject object = new JSONObject();
        ArrayList vos = new ArrayList();
        queryFilter.addFilter("rescueStatus", Arrays.asList(5, 6), QueryOP.IN);
        List<OrgInfoVO> orgInfoVOS = this.rescueOrgManager.roadTree();
        ArrayList roadIds = new ArrayList();
        orgInfoVOS.forEach(orgInfoVO -> {
            List roadIdList = orgInfoVO.getRoadList().stream().map(BizBaseRoad::getId).collect(Collectors.toList());
            roadIds.addAll(roadIdList);
        });
        queryFilter.addFilter("ROAD_ID_", roadIds, QueryOP.IN);
        List rescueInfos = this.query(queryFilter).getRows();
        if (CollectionUtils.isNotEmpty((Collection)rescueInfos)) {
            List rescueIds = rescueInfos.stream().map(BizRescueInfo::getId).collect(Collectors.toList());
            LambdaQueryWrapper handleWrapper = new LambdaQueryWrapper();
            handleWrapper.in(BizRescueHandle::getRescueId, rescueIds);
            handleWrapper.eq(BizRescueHandle::getIsDele, (Object)"0");
            List handleList = this.handleManager.list((Wrapper)handleWrapper);
            LambdaQueryWrapper costWrapper = new LambdaQueryWrapper();
            costWrapper.in(BizRescueCost::getRescueId, rescueIds);
            costWrapper.eq(BizRescueCost::getIsDele, (Object)"0");
            List costList = this.costManager.list((Wrapper)costWrapper);
            Map<String, List<BizRescueInfo>> rescueInfoMap = rescueInfos.stream().filter(rescueInfo -> StringUtil.isNotEmpty((String)rescueInfo.getRoadId())).collect(Collectors.groupingBy(BizRescueInfo::getRoadId));
            Map<String, List<BizRescueHandle>> handleMap = handleList.stream().collect(Collectors.groupingBy(BizRescueHandle::getRescueId));
            Map<String, List<BizRescueCost>> costMap = costList.stream().collect(Collectors.groupingBy(BizRescueCost::getRescueId));
            AtomicLong reachTotalSum = new AtomicLong(0L);
            AtomicLong totalResponseTime = new AtomicLong(0L);
            AtomicLong totalAttendanceTime = new AtomicLong(0L);
            AtomicLong totalReachTime = new AtomicLong(0L);
            AtomicLong totalWorkTime = new AtomicLong(0L);
            AtomicLong totalHandlingTime = new AtomicLong(0L);
            AtomicInteger totalRescueCount = new AtomicInteger(0);
            AtomicReference<BigDecimal> trailersTotalMileage = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> trailersTotalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            rescueInfoMap.forEach((roadId, rescueInfoList) -> {
                CountRescueByRoadVO vo = new CountRescueByRoadVO();
                vo.setRoadId((String)roadId);
                vo.setRoadName(((BizRescueInfo)((Object)((Object)rescueInfoList.get(0)))).getRoadName());
                AtomicLong reachSum = new AtomicLong(0L);
                AtomicLong responseTimeSum = new AtomicLong(0L);
                AtomicLong attendanceTimeSum = new AtomicLong(0L);
                AtomicLong reachTimeSum = new AtomicLong(0L);
                AtomicLong workTimeSum = new AtomicLong(0L);
                AtomicLong handlingTimeSum = new AtomicLong(0L);
                AtomicReference<BigDecimal> trailersMileage = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> trailersAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                rescueInfoList.forEach(rescueInfo -> {
                    List handles = (List)handleMap.get(rescueInfo.getId());
                    if (CollectionUtils.isNotEmpty((Collection)handles)) {
                        long minutes;
                        LocalDateTime departTime;
                        long minutes2;
                        Map<String, List<BizRescueHandle>> rescueHandleNodeMap = handles.stream().filter(e -> StringUtil.isNotEmpty((String)e.getRescueNode())).collect(Collectors.groupingBy(BizRescueHandle::getRescueNode));
                        if (rescueHandleNodeMap.containsKey("2") && rescueHandleNodeMap.containsKey("3")) {
                            LocalDateTime assignTime = rescueHandleNodeMap.get("2").get(0).getHandleTime();
                            LocalDateTime acceptTime = rescueHandleNodeMap.get("3").get(0).getHandleTime();
                            minutes2 = Duration.between(assignTime, acceptTime).toMinutes();
                            responseTimeSum.addAndGet(minutes2);
                            totalResponseTime.addAndGet(minutes2);
                        }
                        if (rescueHandleNodeMap.containsKey("3") && rescueHandleNodeMap.containsKey("4")) {
                            LocalDateTime acceptTime = rescueHandleNodeMap.get("3").get(0).getHandleTime();
                            departTime = rescueHandleNodeMap.get("4").get(0).getHandleTime();
                            minutes2 = Duration.between(acceptTime, departTime).toMinutes();
                            attendanceTimeSum.addAndGet(minutes2);
                            totalAttendanceTime.addAndGet(minutes2);
                        }
                        boolean hasReached = false;
                        if (rescueHandleNodeMap.containsKey("4")) {
                            long reachMinutes;
                            departTime = rescueHandleNodeMap.get("4").get(0).getHandleTime();
                            if (rescueHandleNodeMap.containsKey("5")) {
                                LocalDateTime arriveTime = rescueHandleNodeMap.get("5").get(0).getHandleTime();
                                reachMinutes = Duration.between(departTime, arriveTime).toMinutes();
                                reachTimeSum.addAndGet(reachMinutes);
                                totalReachTime.addAndGet(reachMinutes);
                                if (reachMinutes <= 30L) {
                                    reachSum.incrementAndGet();
                                    reachTotalSum.incrementAndGet();
                                }
                                hasReached = true;
                            }
                            if (!hasReached && rescueHandleNodeMap.containsKey("7")) {
                                LocalDateTime startTowTime = rescueHandleNodeMap.get("7").get(0).getHandleTime();
                                reachMinutes = Duration.between(departTime, startTowTime).toMinutes();
                                reachTimeSum.addAndGet(reachMinutes);
                                totalReachTime.addAndGet(reachMinutes);
                                if (reachMinutes <= 30L) {
                                    reachSum.incrementAndGet();
                                    reachTotalSum.incrementAndGet();
                                }
                                hasReached = true;
                            }
                            if (!hasReached && rescueHandleNodeMap.containsKey("12")) {
                                LocalDateTime returnTime = rescueHandleNodeMap.get("12").get(0).getHandleTime();
                                reachMinutes = Duration.between(departTime, returnTime).toMinutes();
                                reachTimeSum.addAndGet(reachMinutes);
                                totalReachTime.addAndGet(reachMinutes);
                                if (reachMinutes <= 30L) {
                                    reachSum.incrementAndGet();
                                    reachTotalSum.incrementAndGet();
                                }
                            }
                        }
                        if (rescueHandleNodeMap.containsKey("7") && rescueHandleNodeMap.containsKey("8")) {
                            LocalDateTime startTowTime = rescueHandleNodeMap.get("7").get(0).getHandleTime();
                            LocalDateTime endTowTime = rescueHandleNodeMap.get("8").get(0).getHandleTime();
                            minutes = Duration.between(startTowTime, endTowTime).toMinutes();
                            workTimeSum.addAndGet(minutes);
                            totalWorkTime.addAndGet(minutes);
                        }
                        if (rescueHandleNodeMap.containsKey("8") && rescueHandleNodeMap.containsKey("9")) {
                            LocalDateTime endTowTime = rescueHandleNodeMap.get("8").get(0).getHandleTime();
                            LocalDateTime chargeTime = rescueHandleNodeMap.get("9").get(0).getHandleTime();
                            minutes = Duration.between(endTowTime, chargeTime).toMinutes();
                            handlingTimeSum.addAndGet(minutes);
                            totalHandlingTime.addAndGet(minutes);
                        }
                        if (costMap.containsKey(rescueInfo.getId())) {
                            ((List)costMap.get(rescueInfo.getId())).forEach(cost -> {
                                BigDecimal mileage = BigDecimal.valueOf(cost.getTrailingMileage());
                                trailersMileage.set(((BigDecimal)trailersMileage.get()).add(mileage));
                                trailersTotalMileage.set(((BigDecimal)trailersTotalMileage.get()).add(mileage));
                                BigDecimal money = cost.getActualMoney() != null ? BigDecimal.valueOf(cost.getActualMoney()) : BigDecimal.ZERO;
                                trailersAmount.set(((BigDecimal)trailersAmount.get()).add(money));
                                trailersTotalAmount.set(((BigDecimal)trailersTotalAmount.get()).add(money));
                            });
                        }
                    }
                });
                int rescueCount = rescueInfoList.size();
                totalRescueCount.addAndGet(rescueCount);
                vo.setReachSum((int)reachSum.get());
                vo.setAverageResponseTime(rescueCount > 0 ? (int)(responseTimeSum.get() / (long)rescueCount) : 0);
                vo.setAverageAttendanceTime(rescueCount > 0 ? (int)(attendanceTimeSum.get() / (long)rescueCount) : 0);
                vo.setAverageReachTime(rescueCount > 0 ? (int)(reachTimeSum.get() / (long)rescueCount) : 0);
                vo.setAverageWorkTime(rescueCount > 0 ? (int)(workTimeSum.get() / (long)rescueCount) : 0);
                vo.setAverageHandlingTime(rescueCount > 0 ? (int)(handlingTimeSum.get() / (long)rescueCount) : 0);
                vo.setTrailersMileage(trailersMileage.get());
                vo.setTrailersAmount(trailersAmount.get());
                vos.add(vo);
            });
            object.put("data", vos);
            if (!vos.isEmpty()) {
                CountRescueByRoadVO totalVo = new CountRescueByRoadVO();
                int totalCount = totalRescueCount.get();
                totalVo.setReachSum((int)reachTotalSum.get());
                totalVo.setAverageResponseTime(totalCount > 0 ? (int)(totalResponseTime.get() / (long)totalCount) : 0);
                totalVo.setAverageAttendanceTime(totalCount > 0 ? (int)(totalAttendanceTime.get() / (long)totalCount) : 0);
                totalVo.setAverageReachTime(totalCount > 0 ? (int)(totalReachTime.get() / (long)totalCount) : 0);
                totalVo.setAverageWorkTime(totalCount > 0 ? (int)(totalWorkTime.get() / (long)totalCount) : 0);
                totalVo.setAverageHandlingTime(totalCount > 0 ? (int)(totalHandlingTime.get() / (long)totalCount) : 0);
                totalVo.setTrailersMileage(trailersTotalMileage.get());
                totalVo.setTrailersAmount(trailersTotalAmount.get());
                object.put("total", (Object)totalVo);
            }
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)object);
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResponseEntity<org.springframework.core.io.Resource> exportLedger(QueryFilter<BizRescueInfo> queryFilter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public RescueLedgerVO getTaskLedger(QueryFilter<BizRescueInfo> queryFilter) {
        List<RescueLedgerVO> voList = ((BizRescueInfoDao)this.baseMapper).rescueLedger((Wrapper<BizRescueInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        if (voList != null && !voList.isEmpty()) {
            return voList.get(0);
        }
        return new RescueLedgerVO();
    }

    @Override
    public void ledgerExport(HttpServletResponse response, QueryFilter<BizRescueInfo> queryFilter) {
        List<RescueLedgerVO> voList = ((BizRescueInfoDao)this.baseMapper).rescueLedger((Wrapper<BizRescueInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        if (voList != null && !voList.isEmpty()) {
            RescueLedgerVO vo = voList.get(0);
            TemplateExportParams params = new TemplateExportParams("model/rescueTask.xlsx", new Integer[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            String tempName = "\u9ad8\u901f\u516c\u8def\u6e05\u969c\u6551\u63f4\u4f5c\u4e1a\u786e\u8ba4\u5355.xlsx";
            map.put("carCode", vo.getCarCode());
            map.put("carUserTel", vo.getCarUserTel());
            map.put("carTypeText", vo.getCarTypeText());
            map.put("carClassText", vo.getCarClassText());
            map.put("rescueYear", vo.getRescueYear());
            map.put("rescueMonth", vo.getRescueMonth());
            map.put("rescueDay", vo.getRescueDay());
            map.put("rescueHour", vo.getRescueHour());
            map.put("rescueMinute", vo.getRescueMinute());
            map.put("pegVal", vo.getPegVal());
            map.put("handleInfo", vo.getHandleInfo());
            map.put("totalMoney", vo.getTotalMoney());
            map.put("revisitResult", vo.getRevisitResult());
            map.put("eventUserName", vo.getEventUserName());
            map.put("acceptUserName", vo.getAcceptUserName());
            ExcelUtil.exportExcelWorkbook(tempName, params, map, response);
        }
    }

    @Override
    public BizRescueHandle setUser(String id, String node, LocalDateTime handleTime) {
        Map jyCzhj = this.sdm.dictMapByCode("jy_czlc");
        BizRescueHandle handle = new BizRescueHandle();
        handle.setRescueId(id);
        handle.setHandleUserId(ContextUtil.getCurrentUserId());
        handle.setHandleUserName(ContextUtil.getCurrentUserName());
        handle.setHandleTeamId(ContextUtil.getCurrentOrgId());
        handle.setHandleTeamName(ContextUtil.getCurrentOrgName());
        if (handle.getHandleTime() == null) {
            handle.setHandleTime(handleTime);
        }
        handle.setRescueNode(node);
        if (jyCzhj != null && !jyCzhj.isEmpty()) {
            handle.setHandleInfo(ContextUtil.getCurrentUserName() + "\u8fdb\u884c" + ((DictModel)((List)jyCzhj.get(node)).get(0)).getName());
        }
        return handle;
    }
}

