/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.controller;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.rescue.patrol.manager.BizInspectionTaskManager;
import com.artfess.rescue.patrol.model.BizInspectionTask;
import com.artfess.rescue.patrol.vo.BaseTaskLedgerVO;
import com.artfess.rescue.patrol.vo.CountByContentToUserVO;
import com.artfess.rescue.patrol.vo.CountByContentVO;
import com.artfess.rescue.patrol.vo.CountByRoadVO;
import com.artfess.rescue.patrol.vo.TaskSummaryVO;
import com.artfess.rescue.report.dto.FilterDto;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/patrol/bizInspectionTask/v1/"})
@Api(tags={"\u5de1\u68c0\u4efb\u52a1"})
@ApiGroup(group={"group_biz_rescue"})
public class BizInspectionTaskController
extends BaseController<BizInspectionTaskManager, BizInspectionTask> {
    @Resource
    SysDictionaryDetailManager sysDictionaryDetailManager;

    @PostMapping(value={"/queryByPower"})
    @ApiOperation(value="\u5e26\u6743\u9650\u5206\u9875\u67e5\u8be2", httpMethod="POST", notes="\u5e26\u6743\u9650\u5206\u9875\u67e5\u8be2")
    public PageList<BizInspectionTask> queryByPower(@RequestBody QueryFilter<BizInspectionTask> queryFilter) {
        return ((BizInspectionTaskManager)this.baseService).powerList(queryFilter);
    }

    @PostMapping(value={"/query"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2-\u5de1\u68c0\u4efb\u52a1", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2")
    public PageList<BizInspectionTask> query(@RequestBody QueryFilter<BizInspectionTask> queryFilter) {
        List<Integer> status = Arrays.asList(0, 1, 2, 3, 5);
        queryFilter.addFilter("t.task_status_", status, QueryOP.IN);
        return ((BizInspectionTaskManager)this.baseService).queryPage(queryFilter);
    }

    @PostMapping(value={"/complete/query"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2-\u5de1\u68c0\u5f02\u5e38", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2")
    public PageList<BizInspectionTask> completeQuery(@RequestBody QueryFilter<BizInspectionTask> queryFilter) {
        List<Integer> status = Arrays.asList(3, 4, 5);
        queryFilter.addFilter("t.task_status_", status, QueryOP.IN);
        return ((BizInspectionTaskManager)this.baseService).queryPage(queryFilter);
    }

    @PostMapping(value={"/query/open"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2-\u5de1\u68c0\u4efb\u52a1", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2")
    public PageList<BizInspectionTask> queryNoStatus(@RequestBody QueryFilter<BizInspectionTask> queryFilter) {
        return ((BizInspectionTaskManager)this.baseService).queryPage(queryFilter);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizInspectionTask getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizInspectionTaskManager)this.baseService).findById(id);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizInspectionTask t) {
        boolean result = ((BizInspectionTaskManager)this.baseService).saveInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/updateByStatus"})
    @ApiOperation(value="\u6839\u636eid\u4fee\u6539\u72b6\u6001")
    public CommonResult<String> updateByStatus(@RequestParam(value="id") String id, @RequestParam(value="taskStatus") String taskStatus) {
        boolean result = ((BizInspectionTaskManager)this.baseService).updateByStatus(id, taskStatus);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/count/road"})
    @ApiOperation(value="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1")
    public CommonResult<JSONObject> countByRoad(@RequestBody QueryFilter<BizInspectionTask> queryFilter) {
        return ((BizInspectionTaskManager)this.baseService).countByRoad(queryFilter);
    }

    @PostMapping(value={"/export/road"})
    @ApiOperation(value="excel\u5bfc\u51fa-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1")
    public void exportByRoad(HttpServletResponse response, @RequestBody QueryFilter<BizInspectionTask> queryFilter) throws Exception {
        CommonResult<JSONObject> result = ((BizInspectionTaskManager)this.baseService).countByRoad(queryFilter);
        JSONObject object = (JSONObject)result.getValue();
        List voList = (List)object.get((Object)"data");
        ArrayList<Map> list = new ArrayList<Map>();
        if (voList != null && voList.size() > 0) {
            int i = 1;
            for (CountByRoadVO vo : voList) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                map.put("sn", i);
                ++i;
                list.add(map);
            }
        }
        String tempName = "\u5de1\u67e5\u8def\u6bb5\u6c47\u603b\u7edf\u8ba1";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("roadName", "\u8def\u6bb5\u540d\u79f0");
        exportMaps.put("teamName", "\u5de1\u68c0\u961f\u4f0d");
        exportMaps.put("taskMileage", "\u5de1\u68c0\u91cc\u7a0b\uff08km\uff09");
        exportMaps.put("taskTime", "\u5de1\u68c0\u65f6\u95f4\uff08\u5c0f\u65f6\uff09\uff09");
        exportMaps.put("taskNum", "\u5de1\u67e5\u6b21\u6570\uff08\u6b21\uff09");
        exportMaps.put("outlierPoint", "\u5f02\u5e38\u70b9\u6570\uff08\u4e2a\uff09");
        exportMaps.put("handleAll", "\u4e0a\u62a5\u603b\u6570\uff08\u4e2a\uff09");
        exportMaps.put("handleScene", "\u4e0a\u62a5\u4e2d\u5fc3\u6570\uff08\u4e2a\uff09");
        exportMaps.put("handleCenter", "\u73b0\u573a\u5904\u7f6e\u6570\uff08\u4e2a\uff09");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @PostMapping(value={"/count/user"})
    @ApiOperation(value="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u4eba\u5458\u6c47\u603b\u7edf\u8ba1", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u4eba\u5458\u6c47\u603b\u7edf\u8ba1")
    public CommonResult<JSONObject> countByUser(@RequestBody QueryFilter<BizInspectionTask> queryFilter) {
        return ((BizInspectionTaskManager)this.baseService).countByUser(queryFilter);
    }

    @PostMapping(value={"/export/user"})
    @ApiOperation(value="excel\u5bfc\u51fa-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1")
    public void exportByUser(HttpServletResponse response, @RequestBody QueryFilter<BizInspectionTask> queryFilter) throws Exception {
        CommonResult<JSONObject> result = ((BizInspectionTaskManager)this.baseService).countByUser(queryFilter);
        JSONObject object = (JSONObject)result.getValue();
        List voList = (List)object.get((Object)"data");
        ArrayList<Map> list = new ArrayList<Map>();
        if (voList != null && voList.size() > 0) {
            int i = 1;
            for (CountByRoadVO vo : voList) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                map.put("sn", i);
                ++i;
                list.add(map);
            }
        }
        String tempName = "\u5de1\u67e5\u4eba\u5458\u6c47\u603b\u7edf\u8ba1";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("userName", "\u5de1\u68c0\u4eba\u5458");
        exportMaps.put("roadName", "\u8def\u6bb5\u540d\u79f0");
        exportMaps.put("taskMileage", "\u5de1\u68c0\u91cc\u7a0b\uff08km\uff09");
        exportMaps.put("taskTime", "\u5de1\u68c0\u65f6\u95f4\uff08\u5c0f\u65f6\uff09\uff09");
        exportMaps.put("taskNum", "\u5de1\u67e5\u6b21\u6570\uff08\u6b21\uff09");
        exportMaps.put("outlierPoint", "\u5f02\u5e38\u70b9\u6570\uff08\u4e2a\uff09");
        exportMaps.put("handleAll", "\u4e0a\u62a5\u603b\u6570\uff08\u4e2a\uff09");
        exportMaps.put("handleScene", "\u4e0a\u62a5\u4e2d\u5fc3\u6570\uff08\u4e2a\uff09");
        exportMaps.put("handleCenter", "\u73b0\u573a\u5904\u7f6e\u6570\uff08\u4e2a\uff09");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @PostMapping(value={"/count/content"})
    @ApiOperation(value="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u5185\u5bb9\u6c47\u603b\u7edf\u8ba1", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u5185\u5bb9\u6c47\u603b\u7edf\u8ba1")
    public CommonResult<JSONObject> countContent(@RequestBody QueryFilter<BizInspectionTask> queryFilter) {
        return ((BizInspectionTaskManager)this.baseService).countContent(queryFilter);
    }

    @PostMapping(value={"/export/content"})
    @ApiOperation(value="excel\u5bfc\u51fa-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1")
    public void exportByContent(HttpServletResponse response, @RequestBody QueryFilter<BizInspectionTask> queryFilter) throws Exception {
        CommonResult<JSONObject> result = ((BizInspectionTaskManager)this.baseService).countContent(queryFilter);
        JSONObject object = (JSONObject)result.getValue();
        List voList = (List)object.get((Object)"data");
        ArrayList<Map> list = new ArrayList<Map>();
        if (voList != null && voList.size() > 0) {
            int i = 1;
            for (CountByContentVO vo : voList) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                map.put("sn", i);
                ++i;
                if (map.get("type") != null) {
                    String type = map.get("type").toString();
                    String typeText = this.sysDictionaryDetailManager.getTextByValue("xcdwlx", type);
                    map.put("typeText", typeText);
                } else {
                    map.put("typeText", "");
                }
                list.add(map);
            }
        }
        String tempName = "\u5de1\u67e5\u5185\u5bb9\u6c47\u603b\u7edf\u8ba1";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("sn", "\u5e8f\u53f7");
        exportMaps.put("taskNum", "\u5de1\u68c0\u6b21\u6570");
        exportMaps.put("typeText", "\u70b9\u4f4d\u7c7b\u578b");
        exportMaps.put("outlierPoint", "\u5f02\u5e38\u70b9\u6570(\u4e2a)");
        exportMaps.put("handleAll", "\u5f02\u5e38\u70b9\u4e0a\u62a5\u603b\u6570(\u4e2a)");
        exportMaps.put("disposalAll", "\u73b0\u573a\u5904\u7f6e\u603b\u6570(\u4e2a)");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @PostMapping(value={"/count/user/content"})
    @ApiOperation(value="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u4eba\u5458\u5185\u5bb9\u7edf\u8ba1", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u4eba\u5458\u5185\u5bb9\u7edf\u8ba1")
    public CommonResult<List<CountByContentToUserVO>> countUserContent(@RequestBody QueryFilter<BizInspectionTask> queryFilter) {
        return ((BizInspectionTaskManager)this.baseService).countUserContent(queryFilter);
    }

    @PostMapping(value={"/export/user/content"})
    @ApiOperation(value="excel\u5bfc\u51fa-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1")
    public void exportByUserContent(HttpServletResponse response, @RequestBody QueryFilter<BizInspectionTask> queryFilter) throws Exception {
        CommonResult<List<CountByContentToUserVO>> result = ((BizInspectionTaskManager)this.baseService).countUserContent(queryFilter);
        List userVOS = (List)result.getValue();
        ArrayList<Map> list = new ArrayList<Map>();
        if (userVOS != null && userVOS.size() > 0) {
            for (CountByContentToUserVO vo : userVOS) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                list.add(map);
            }
        }
        String tempName = "\u5de1\u67e5\u8def\u6bb5\u6c47\u603b\u7edf\u8ba1";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("roadName", "\u8def\u6bb5\u540d\u79f0");
        exportMaps.put("teamName", "\u5de1\u68c0\u961f\u4f0d");
        exportMaps.put("taskMileage", "\u5de1\u68c0\u91cc\u7a0b\uff08km\uff09");
        exportMaps.put("taskTime", "\u5de1\u68c0\u65f6\u95f4\uff08\u5c0f\u65f6\uff09\uff09");
        exportMaps.put("taskNum", "\u5de1\u67e5\u6b21\u6570\uff08\u6b21\uff09");
        exportMaps.put("outlierPoint", "\u5f02\u5e38\u70b9\u6570\uff08\u4e2a\uff09");
        exportMaps.put("handleAll", "\u4e0a\u62a5\u603b\u6570");
        exportMaps.put("handleScene", "\u4e0a\u62a5\u4e2d\u5fc3\u6570");
        exportMaps.put("handleCenter", "\u73b0\u573a\u5904\u7f6e\u6570");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @PostMapping(value={"/task/content"})
    @ApiOperation(value="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u4efb\u52a1\u5b8c\u6210\u60c5\u51b5\u7edf\u8ba1", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u4eba\u5458\u5185\u5bb9\u7edf\u8ba1")
    public CommonResult taskContent(@RequestBody FilterDto dto) {
        return CommonResult.success((Object)((BizInspectionTaskManager)this.baseService).countTaskSummary(dto), (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/export/task/content"})
    @ApiOperation(value="excel\u5bfc\u51fa-\u5de1\u67e5\u4efb\u52a1\u5b8c\u6210\u60c5\u51b5\u7edf\u8ba1", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1")
    public void exportByTaskContent(HttpServletResponse response, @RequestBody FilterDto dto) throws Exception {
        JSONObject object = ((BizInspectionTaskManager)this.baseService).countTaskSummary(dto);
        List voList = (List)object.get((Object)"data");
        ArrayList<Map> list = new ArrayList<Map>();
        Integer no = 1;
        if (voList != null && voList.size() > 0) {
            for (TaskSummaryVO vo : voList) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                map.put("no", no);
                list.add(map);
                Integer n = no;
                Integer n2 = no = Integer.valueOf(no + 1);
            }
        }
        String tempName = "\u5de1\u67e5\u4efb\u52a1\u5b8c\u6210\u60c5\u51b5\u7edf\u8ba1";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("no", "\u5e8f\u53f7");
        exportMaps.put("roadName", "\u8def\u6bb5\u540d\u79f0");
        exportMaps.put("taskNum", "\u4efb\u52a1\u603b\u6570");
        exportMaps.put("taskFinishNum", "\u4efb\u52a1\u5b8c\u6210\u6570\u91cf");
        exportMaps.put("taskFinishRate", "\u4efb\u52a1\u5b8c\u6210\u7387");
        exportMaps.put("pointNum", "\u8ba1\u5212\u6253\u5361\u70b9\u6570\u91cf");
        exportMaps.put("pointFinishNum", "\u5b8c\u6210\u6253\u5361\u70b9\u6570\u91cf");
        exportMaps.put("pointFinishRate", "\u6253\u5361\u70b9\u5b8c\u6210\u7387");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list, (int)0, (int)10);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @PostMapping(value={"/ledger/export"})
    @ApiOperation(value="\u53f0\u8d26\u5bfc\u51fa", httpMethod="POST", notes="\u53f0\u8d26\u5bfc\u51fa")
    public ResponseEntity<?> exportToBrowser(@RequestBody QueryFilter<BizInspectionTask> queryFilter) {
        return ((BizInspectionTaskManager)this.baseService).exportLedger(queryFilter);
    }

    @PostMapping(value={"/ledger"})
    @ApiOperation(value="\u53f0\u8d26\u8be6\u60c5", httpMethod="POST", notes="\u53f0\u8d26\u8be6\u60c5")
    public BaseTaskLedgerVO getEventTaskLedger(@RequestBody QueryFilter<BizInspectionTask> queryFilter) {
        return ((BizInspectionTaskManager)this.baseService).getTaskLedger(queryFilter);
    }

    @PostMapping(value={"/ledger/excelExport"})
    @ApiOperation(value="\u53f0\u8d26\u8be6\u60c5", httpMethod="POST", notes="\u53f0\u8d26\u8be6\u60c5\u5bfc\u51fa")
    public void getEventTaskLedger(HttpServletResponse response, @RequestBody QueryFilter<BizInspectionTask> queryFilter) {
        ((BizInspectionTaskManager)this.baseService).ledgerExport(response, queryFilter);
    }
}

