/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.cloud.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.rescue.cloud.dto.CloudApplyApprovalRecordDTO;
import com.artfess.rescue.cloud.manager.BizCloudApplyApprovalRecordManager;
import com.artfess.rescue.cloud.model.BizCloudApplyApprovalRecord;
import com.artfess.rescue.cloud.vo.ApprovalRecordVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizCloudApplyApprovalRecord/v1/"})
@Api(tags={"\u79c1\u6709\u4e91\u8d44\u6e90\u7533\u8bf7\u5ba1\u6279\u8bb0\u5f55"})
@ApiGroup(group={"group_biz_rescue"})
public class BizCloudApplyApprovalRecordController
extends BaseController<BizCloudApplyApprovalRecordManager, BizCloudApplyApprovalRecord> {
    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody BizCloudApplyApprovalRecord t) {
        boolean result = ((BizCloudApplyApprovalRecordManager)this.baseService).saveInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody BizCloudApplyApprovalRecord t) {
        boolean result = ((BizCloudApplyApprovalRecordManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizCloudApplyApprovalRecord> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizCloudApplyApprovalRecord> queryFilter) {
        return ((BizCloudApplyApprovalRecordManager)this.baseService).queryInfoPage(queryFilter);
    }

    @PostMapping(value={"start"})
    @ApiOperation(value="\u5ba1\u6838\u53d1\u8d77")
    public CommonResult<String> start(@ApiParam(name="\u5ba1\u6838\u8bb0\u5f55DTO", value="\u5ba1\u6838\u8bb0\u5f55") @RequestBody CloudApplyApprovalRecordDTO dto) {
        ((BizCloudApplyApprovalRecordManager)this.baseService).applyStart(dto);
        return new CommonResult(true, "\u53d1\u8d77\u6210\u529f");
    }

    @PostMapping(value={"agree"})
    @ApiOperation(value="\u5ba1\u6838\u540c\u610f")
    public CommonResult<String> agree(@ApiParam(name="\u5ba1\u6838\u8bb0\u5f55DTO", value="\u5ba1\u6838\u8bb0\u5f55") @RequestBody CloudApplyApprovalRecordDTO dto) {
        ((BizCloudApplyApprovalRecordManager)this.baseService).applyAgree(dto);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"reject"})
    @ApiOperation(value="\u5ba1\u6838\u9a73\u56de")
    public CommonResult<String> reject(@ApiParam(name="\u5ba1\u6838\u8bb0\u5f55DTO", value="\u5ba1\u6838\u8bb0\u5f55") @RequestBody CloudApplyApprovalRecordDTO dto) {
        ((BizCloudApplyApprovalRecordManager)this.baseService).applyReject(dto);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"complete"})
    @ApiOperation(value="\u5ba1\u6838\u5b8c\u6210")
    public CommonResult<String> complete(@ApiParam(name="\u5ba1\u6838\u8bb0\u5f55DTO", value="\u5ba1\u6838\u8bb0\u5f55") @RequestBody CloudApplyApprovalRecordDTO dto) {
        ((BizCloudApplyApprovalRecordManager)this.baseService).applyComplete(dto);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"getRecord/{privateCloudApplyId}"})
    @ApiOperation(value="\u83b7\u53d6\u5ba1\u6838\u65e5\u5fd7\u8bb0\u5f55")
    public CommonResult<List<ApprovalRecordVO>> getRecord(@ApiParam(name="privateCloudApplyId", value="\u4e91\u8d44\u6e90\u7533\u8bf7\u5355ID") @PathVariable String privateCloudApplyId) {
        return ((BizCloudApplyApprovalRecordManager)this.baseService).getRecord(privateCloudApplyId);
    }
}

