export function classifyDataInJs() {
  const classifyData = [
    {name: '路产单数量统计', type: 'RoadProductionList', hasPagination: false, customPagination: false}
    // {name: '路产损失项目统计', type: 'RoadProductionLossProject', hasPagination: false, customPagination: false}
    // { name: '已完成路产单统计', type: '1' },
    // { name: '未完成路产单统计', type: '2' },
    // { name: '路产损失项目统计', type: '3' },
    // { name: '超时路产单统计', type: '4' },
    // { name: '路产损失赔偿复核率统计表', type: '5' }
  ]
  return classifyData
}

// 查询参数
export function paramsListInJs(key) {
  const defaultParams = {
    pageBean: {pageSize: -1, page: 1, total: 0},
    querys: [
      {operation: 'BETWEEN', property: 'eventTime', value: [startOfMonth, endOfMonth]},
      {operation: 'IN', property: 'road_id_'}
    ]
  }
  const paramsObj = {
    RoadProductionList: defaultParams,
    RoadProductionLossProject: defaultParams
  }
  return paramsObj[key] || {}
}

// 搜索条件
export function optionListInJs(key) {
  const defaultOption = [
    {
      title: '所属路段',
      prop: 'road_id_',
      type: 'select',
      option: [],
      default: true
    }
  ]
  const optionsObj = {
    RoadProductionList: defaultOption,
    RoadProductionLossProject: defaultOption
  }
  return optionsObj[key] || []
}

// 表格列 
// prop：字段名，label：显示名称，minWidth：最小宽度，formatter：自定义格式化, children：子列
// formatter 示例：({ value }) => value ? value.toFixed(2) : '-'

export function tableColumnInJs(type) {
  const tableColumnData = {
    RoadProductionList: [
      {label: '路段名称', minWidth: '100', prop: 'roadName'},
      // {label: '路损赔偿清单总条数', minWidth: '120', prop: 'total'},
      {label: '路产损失条数', minWidth: '120', prop: 'compensatedCount'},
      // {label: '未赔偿条数', minWidth: '120', prop: 'notCompensatedCount'},
      {label: '路产损失(元)', minWidth: '120', prop: 'compensationMoney'}
    ],
    RoadProductionLossProject: [
      {label: '类型', minWidth: '120', prop: 'type'},
      {label: '路产损失（元）', minWidth: '200', prop: 'compensationMoney'},
      {label: '总单数', minWidth: '120', prop: 'total'}
    ],
    '3': [
      {label: '公司', minWidth: '80', prop: 'code'},
      {label: '处置部门', minWidth: '80', prop: 'name'},
      {label: '项目大类', minWidth: '80', prop: 'routeName'},
      {label: '项目(细类)', minWidth: '80', prop: 'companyName'},
      {label: '单位', minWidth: '80', prop: 'startingPoint'},
      {label: '数量', minWidth: '80', prop: 'startingPoint'},
      {label: '金额', minWidth: '80', prop: 'startingPoint'}
    ],
    '4': [
      {label: '时间', minWidth: '80', prop: 'code'},
      {label: '路产单号', minWidth: '80', prop: 'name'},
      {label: '事件单号', minWidth: '80', prop: 'terminalPoint'},
      {label: '路段', minWidth: '80', prop: 'terminalPoint'},
      {label: '位置', minWidth: '80', prop: 'terminalPoint'},
      {label: '事件类型', minWidth: '80', prop: 'terminalPoint'},
      {label: '处置部门', minWidth: '80', prop: 'terminalPoint'},
      {label: '最后处置时间', minWidth: '100', prop: 'terminalPoint'},
      {label: '路产损失', minWidth: '80', prop: 'terminalPoint'},
      {label: '超时次数', minWidth: '80', prop: 'terminalPoint'},
      {label: '距离下一次超时(小时)', minWidth: '160', prop: 'terminalPoint'}
    ],
    '5': [
      {label: '运营部门', minWidth: '80', prop: 'code'},
      {label: '路产单件数', minWidth: '80', prop: 'name'},
      {label: '未复核次数', minWidth: '80', prop: 'routeName'},
      {label: '复核率(%)', minWidth: '80', prop: 'companyName'}
    ]
  }
  return tableColumnData[type]
}



