import moment from 'moment'

const startOfMonth = moment().startOf('month').format('YYYY-MM-DD')
const endOfMonth = moment().endOf('month').format('YYYY-MM-DD')

export function classifyDataInJs() {
  const classifyData = [
    {name: '拖车路段汇总统计', type: 'TrailerDept', hasPagination: false, customPagination: false}
    // { name: '拖车人员汇总统计', type: 'TrailerUser', hasPagination: true, customPagination: true },
    // { name: '拖车类别汇总统计', type: '3' },
    // { name: '清障救援考核统计', type: '4' },
    // { name: '30分钟清障救援完成率统计表', type: '5' },
    // { name: '30分钟清障救援到达率统计表', type: '6' },
    // { name: '救援超时统计表', type: '7' },
  ]
  return classifyData
}

// 查询参数
export function paramsListInJs(key) {
  const defaultParams = {
    pageBean: {pageSize: -1, page: 1, total: 0},
    querys: [
      {operation: 'BETWEEN', property: 'rescueTime', value: [startOfMonth, endOfMonth]},
      {operation: 'IN', property: 'road_id_'}
    ]
  }
  const paramsObj = {
    TrailerDept: defaultParams,
    TrailerUser: {pageBeanShow: {pageSize: 20, page: 1, total: 0}, ...defaultParams}
  }
  return paramsObj[key] || {}
}

// 搜索条件
export function optionListInJs(key) {
  const defaultOption = [
    {
      title: '所属路段',
      prop: 'road_id_',
      type: 'select',
      option: [],
      default: true
    }
  ]
  const optionsObj = {
    TrailerDept: defaultOption,
    TrailerUser: defaultOption
  }
  return optionsObj[key] || []
}

// 表格列 
// prop：字段名，label：显示名称，minWidth：最小宽度，formatter：自定义格式化, children：子列
// formatter 示例：({ value }) => value ? value.toFixed(2) : '-'
export function tableColumnInJs(type) {
  const tableColumnData = {
    TrailerDept: [
      {label: '路段名称', minWidth: '140', prop: 'roadName'},
      {label: '30分钟到达\n次数（次）', minWidth: '140', prop: 'reachSum'},
      {label: '拖车里程\n（km）', minWidth: '100', prop: 'trailersMileage'},
      {
        label: '平均响应时间\n（分）',
        minWidth: '140',
        prop: 'averageResponseTime',
        tip: '计算方式：委派→接单的平均响应时间'
      },
      {
        label: '平均出勤时间\n（分）',
        minWidth: '140',
        prop: 'averageAttendanceTime',
        tip: '计算方式：接单→出发的平均出勤时间'
      },
      {
        label: '平均到达时间\n（分）',
        minWidth: '140',
        prop: 'averageReachTime',
        tip: '计算方式：出发→到达/起拖/返空的平均到达时间'
      },
      {
        label: '平均作业时间\n（分）',
        minWidth: '140',
        prop: 'averageWorkTime',
        tip: '计算方式：起拖→拖行结束的平均作业时间'
      },
      // {
      //   label: '平均处置时间\n（分）',
      //   minWidth: '140',
      //   prop: 'averageHandlingTime',
      //   tip: '计算方式：拖行结束→收费的平均处置时间'
      // },
      {label: '拖车总金额\n（元）', minWidth: '140', prop: 'trailersAmount'}
    ],
    TrailerUser: [
      {label: '人员姓名', minWidth: '100', prop: 'userName'},
      {label: '路段名称', minWidth: '100', prop: 'roadName'},
      {label: '拖车数量\n（辆）', minWidth: '80', prop: 'trailersNum'},
      {label: '拖车里程\n（km）', minWidth: '100', prop: 'trailersMileage'},
      {label: '拖车总金额\n（元）', minWidth: '140', prop: 'trailersAmount'},
      {label: '平均出勤时间\n（分）', minWidth: '140', prop: 'averageAttendanceTime'},
      {label: '平均处置时间\n（分）', minWidth: '140', prop: 'averageHandlingTime'},
      {label: '平均到达时间\n（分）', minWidth: '140', prop: 'averageReachTime'},
      {label: '平均响应时间\n（分）', minWidth: '140', prop: 'averageResponseTime'}
    ],
    '3': [
      {label: '部门', minWidth: '80', prop: 'code'},
      {label: '拖车数量', minWidth: '80', prop: 'name'},
      {label: '一类车', minWidth: '80', prop: 'routeName'},
      {label: '二类车', minWidth: '80', prop: 'companyName'},
      {label: '三类车', minWidth: '80', prop: 'startingPoint'},
      {label: '四类车', minWidth: '80', prop: 'startingPoint'},
      {label: '五类车', minWidth: '80', prop: 'startingPoint'},
      {label: '白天', minWidth: '80', prop: 'startingPoint'},
      {label: '夜间', minWidth: '80', prop: 'startingPoint'},
      {label: '交通事故', minWidth: '80', prop: 'startingPoint'},
      {label: '危险物品', minWidth: '80', prop: 'startingPoint'},
      {label: '隧道内作业', minWidth: '100', prop: 'startingPoint'},
      {label: '放空', minWidth: '80', prop: 'startingPoint'}
    ],
    '4': [
      {label: '部门名称', minWidth: '80', prop: 'code'},
      {label: '日期', minWidth: '80', prop: 'name'},
      {label: '救援单号', minWidth: '80', prop: 'terminalPoint'},
      {label: '派单时间', minWidth: '80', prop: 'terminalPoint'},
      {label: '接单时间', minWidth: '80', prop: 'terminalPoint'},
      {label: '响应时间', minWidth: '80', prop: 'terminalPoint'},
      {label: '出发时间', minWidth: '80', prop: 'terminalPoint'},
      {label: '出勤时间', minWidth: '80', prop: 'terminalPoint'},
      {label: '到达现场时间', minWidth: '100', prop: 'terminalPoint'},
      {label: '到达时间', minWidth: '80', prop: 'terminalPoint'},
      {label: '围蔽是否有图片', minWidth: '120', prop: 'terminalPoint'},
      {label: '起拖是否有图片', minWidth: '120', prop: 'terminalPoint'}
    ],
    '5': [
      {label: '部门名称', minWidth: '80', prop: 'code'},
      {label: '拖车数量', minWidth: '80', prop: 'name'},
      {label: '30分钟完成次数', minWidth: '80', prop: 'routeName'},
      {label: '30分钟未完成次数', minWidth: '80', prop: 'companyName'},
      {label: '30分钟清障救援完成率（%）', minWidth: '140', prop: 'companyName'},
      {label: '返空次数', minWidth: '80', prop: 'companyName'}
    ],
    '6': [
      {label: '部门名称', minWidth: '80', prop: 'code'},
      {label: '拖车数量', minWidth: '80', prop: 'name'},
      {label: '到达数量', minWidth: '80', prop: 'routeName'},
      {label: '未到达数量', minWidth: '80', prop: 'companyName'},
      {label: '到达率', minWidth: '80', prop: 'companyName'}
    ],
    '7': [
      {label: '运营公司', minWidth: '80', prop: 'code'},
      {label: '拖车单数', minWidth: '80', prop: 'name'},
      {label: '响应超时单数', minWidth: '80', prop: 'routeName'},
      {label: '出勤超时单数', minWidth: '80', prop: 'companyName'}
    ]
  }
  return tableColumnData[type]
}



