// 巡查
export function classifyDataInJs() {
  const classifyData = [
    // {name: '交通拥堵统计表', type: '1'},
    {name: '巡查救援统计表', type: '2'},
    {name: '交通管制统计表', type: '3'},
    {name: '突发事件统计表', type: '4'},
    {name: '事故统计表', type: '5'}
  ]
  return classifyData
}

export function optionListInJs() {
  const optionsObj = {
    '1': [
      {title: '部门名称', prop: 'roadCode', type: 'input', default: true},
      {
        title: '时间',
        prop: 'type',
        type: 'select',
        option: getDictionaryByCode('xjlx-xjrw'),
        multiple: false
      }
    ],
    '2': [
      {title: '部门名称', prop: 'roadCode', type: 'input', default: true},
      {title: '姓名', prop: 'roadCode', type: 'input', default: true},
      {
        title: '时间',
        prop: 'type',
        type: 'select',
        option: getDictionaryByCode('xjlx-xjrw'),
        multiple: false
      }
    ]
  }
  return classifyData
}

export function tableColumnInJs(type) {
  const tableColumnData = {
    '1': [
      {label: '拥挤区域', minWidth: 'auto', prop: 'orgName'},
      {label: '拥挤路段', minWidth: 'auto', prop: 'roadName'},
      {label: '共计拥挤数量(次)', minWidth: 'auto', prop: 'totalNum'},
      {label: '拥挤主要区域', minWidth: 'auto', prop: 'startingPoint'},
      {label: '拥挤主要时间段', minWidth: 'auto', prop: 'startingPoint'}
    ],
    '2': [
      {label: '所属区域', minWidth: '140', prop: 'orgName'},
      {label: '所属路段', minWidth: '120', prop: 'roadName'},
      {label: '共计巡查任务(次)', minWidth: 'auto', prop: 'insTaskNum'},
      {label: '巡查公里数(公里)', minWidth: '160', prop: 'insMileage'},
      {label: '突发事件处置(次)', minWidth: '160', prop: 'etTaskNum'},
      {label: '布置救援点(个)', minWidth: '160', prop: 'rePointNum'},
      {label: '布置救援车辆(辆)', minWidth: '160', prop: 'reCarNum'},
      {label: '布置救援人员(名)', minWidth: '160', prop: 'reMemberNum'},
      {label: '出发救援任务(次)', minWidth: '160', prop: 'reTaskNum'},
      {label: '平均处置时间(分钟)', minWidth: '160', prop: 'reHandTime'}
    ],
    '3': [
      {label: '管制区域', minWidth: 'auto', prop: 'orgName'},
      {label: '管制路段', minWidth: 'auto', prop: 'roadName'},
      {label: '共计管制数量(次)', minWidth: '180', prop: 'totalNum'},
      {label: '占道管制(起)', minWidth: '120', prop: 'otRoadNum'},
      {label: '半幅封闭(起)', minWidth: '120', prop: 'halfClosedNum'},
      {label: '出口封闭(起)', minWidth: '120', prop: 'outletClosedNum'},
      {label: '入口封闭(起)', minWidth: '120', prop: 'inletClosedNum'},
      {label: '封闭车道(起)', minWidth: '120', prop: 'laneClosedNum'}
    ],
    '4': [
      {label: '事件区域', minWidth: '140', prop: 'orgName'},
      {label: '突发事件路段', minWidth: '120', prop: 'roadName'},
      {label: '事件等级(起)', minWidth: '120', prop: 'eventLevelNum'},
      {label: '突发事件总数(件)', minWidth: 'auto', prop: 'totalNum'},
      {label: '气象灾害(件)', minWidth: '120', prop: 'weatherHazardNum'},
      {label: '地质灾害事件(件)', minWidth: '160', prop: 'geoHazardNum'},
      {label: '事故灾难(件)', minWidth: '120', prop: 'eventNum'},
      {label: '群体事件(件)', minWidth: '120', prop: 'groupEventNum'},
      {label: '养护施工(件)', minWidth: '120', prop: 'repairNum'},
      {label: '突发大车流量(次)', minWidth: '160', prop: 'trafficNum'},
      {label: '故障车占道(次)', minWidth: '140', prop: 'otRoadNum'},
      {label: '其他事件(次)', minWidth: '120', prop: 'otherNum'},
      {label: '人伤事故(起)', minWidth: '120', prop: 'hurtNum'},
      {label: '死亡人数(名)', minWidth: '120', prop: 'deadPeopleNum'},
      {label: '受伤人数(名)', minWidth: '120', prop: 'hurtPeopleNum'}
    ],
    '5': [
      {label: '事故区域', minWidth: '140', prop: 'orgName'},
      {label: '事故路段', minWidth: '120', prop: 'roadName'},
      {label: '事故等级(起)', minWidth: '120', prop: 'eventLevelNum'},
      {label: '突发事故总数(起)', minWidth: 'auto', prop: 'totalNum'},
      {label: '交通事故(起)', minWidth: '120', prop: 'trafficNum'},
      {label: '危化品事故(起)', minWidth: '160', prop: 'dgNum'},
      {label: '火灾事故(起)', minWidth: '120', prop: 'fireNum'},
      {label: '其它事故(起)', minWidth: '120', prop: 'otherNum'},
      {label: '人伤事故(起)', minWidth: '120', prop: 'hurtNum'},
      {label: '死亡人数(名)', minWidth: '120', prop: 'hurtPeopleNum'},
      {label: '受伤人数(名)', minWidth: '120', prop: 'deadPeopleNum'}
    ]
  }
  return tableColumnData[type]
}



