import moment from 'moment'

const startOfMonth = moment().startOf('month').format('YYYY-MM-DD')
const endOfMonth = moment().endOf('month').format('YYYY-MM-DD')

export function classifyDataInJs() {
  const classifyData = [
    {name: '通话记录总统计', type: 'CallLeder', hasPagination: false, customPagination: false}
  ]
  return classifyData
}

// 查询参数
export function paramsListInJs(key) {
  const defaultParams = {
    pageBean: {pageSize: -1, page: 1, total: 0},
    querys: [
      {operation: 'BETWEEN', property: 'rescueTime', value: [startOfMonth, endOfMonth]},
      {operation: 'IN', property: 'road_id_'}
    ]
  }
  const paramsObj = {
    CallLeder: defaultParams
  }
  return paramsObj[key] || {}
}

// 搜索条件
export function optionListInJs(key) {
  const defaultOption = [
    {
      title: '所属路段',
      prop: 'road_id_',
      type: 'select',
      option: [],
      default: true
    }
  ]
  const optionsObj = {
    CallLeder: defaultOption
  }
  return optionsObj[key] || []
}

// 表格列 
// prop：字段名，label：显示名称，minWidth：最小宽度，formatter：自定义格式化, children：子列
// formatter 示例：({ value }) => value ? value.toFixed(2) : '-'
export function tableColumnInJs(type) {
  const tableColumnData = {
    CallLeder: [
      {label: '路段名称', minWidth: '140', prop: 'roadName'},
      {label: '总数', minWidth: '140', prop: 'totalNum'},
      {label: '突发事件（件）', minWidth: '100', prop: 'tfsjNum'},
      {label: '公众服务（件）', minWidth: '100', prop: 'ggfwNum'},
      {label: '施工（件）', minWidth: '100', prop: 'sgNum'},
      {label: '通知（件）', minWidth: '100', prop: 'tzNum'},
      {label: '其他（件）', minWidth: '100', prop: 'qtNum'}
    ]
  }
  return tableColumnData[type]
}



