import req from '@/request'

const portal = window.context.portal

const headersUrlencoded = {
    'Content-type': 'application/x-www-form-urlencoded'
}

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizInspectionVideoConf/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格详情
export function taskDetail(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizInspectionVideoConf/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格新增
export function taskSave(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizInspectionVideoConf/v1/saveOrUpdate`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格删除
export function taskDelete(ids) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/bizInspectionVideoConf/v1/?ids=${ids}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 启用或停止培训配置
export function toggleTriggerRun(id) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizInspectionVideoConf/v1/toggleTriggerRun?id=${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}


// 单次执行培训配置
export function executeJob(data) {
    return new Promise((resolve, reject) => {
        let param = {
            url: portal + `/bizInspectionVideoConf/v1/executeJob`,
            data,
            method: "post",
            headers: headersUrlencoded
        }
        req.request(param)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}